/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryCategoryMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(PrimaryCategoryMapper.class);
    private static final String ADD_CATEGORY_QUALIFIED_NAME_PROPERTY_WITH_VALUE_TO_CLASSIFICATION_OF_TERM = "Add categoryQualifiedName property with value '{}' to classification {} of term {}";
    private static final String TERM = "term";
    private static final String PARENT_CATEGORY = "parent_category";
    private static final String GLOSSARY_TERM = "GlossaryTerm";
    private static final String PRIMARY_CATEGORY = "PrimaryCategory";
    private static final String CATEGORY_QUALIFIED_NAME = "categoryQualifiedName";
    private static PrimaryCategoryMapper primaryCategoryMapper;

    private PrimaryCategoryMapper() {
        super(TERM, PARENT_CATEGORY, GLOSSARY_TERM, PRIMARY_CATEGORY);
        this.addMappedOmrsProperty(CATEGORY_QUALIFIED_NAME);
    }

    public static ClassificationMapping getInstance(IGCVersionEnum version) {
        if (primaryCategoryMapper == null) {
            primaryCategoryMapper = new PrimaryCategoryMapper();
        }
        return primaryCategoryMapper;
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, ObjectCache cache, Reference fromIgcObject, String userId) throws RepositoryErrorException {
        String methodName = "addMappedOMRSClassification";
        if (fromIgcObject instanceof Term) {
            try {
                IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
                Identity termIdentity = fromIgcObject.getIdentity(igcRestClient, cache);
                Identity categoryIdentity = termIdentity.getParentIdentity();
                InstanceProperties classificationProperties = new InstanceProperties();
                classificationProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), classificationProperties, CATEGORY_QUALIFIED_NAME, categoryIdentity.toString(), "addMappedOMRSClassification");
                Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                classifications.add(classification);
                log.debug(ADD_CATEGORY_QUALIFIED_NAME_PROPERTY_WITH_VALUE_TO_CLASSIFICATION_OF_TERM, new Object[]{categoryIdentity.toString(), classification.getName(), termIdentity.getName()});
            }
            catch (NumberFormatException | IGCException e) {
                PrimaryCategoryMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addMappedOMRSClassification", (Exception)e, new String[0]);
            }
        }
    }
}

