/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.ConnectionEndpointMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.SemanticAssignmentMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointMapper
extends ReferenceableMapper {
    private static final Logger log = LoggerFactory.getLogger(EndpointMapper.class);

    public static EndpointMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected EndpointMapper() {
        super("host", "Host", "Endpoint");
        this.addOtherIGCAssetType("host_(engine)");
        this.addSimplePropertyMapping("name", "name");
        this.addSimplePropertyMapping("short_description", "description");
        this.addLiteralPropertyMapping("protocol", null);
        this.addLiteralPropertyMapping("encryptionMethod", null);
        this.addRelationshipMapper(SemanticAssignmentMapper.getInstance(null));
        this.addRelationshipMapper(ConnectionEndpointMapper.getInstance(null));
        this.addComplexIgcProperty("name");
        this.addComplexOmrsProperty("networkAddress");
    }

    @Override
    public Reference getBaseIgcAssetFromAlternative(String otherAssetType, String otherAssetRid, IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache) throws RepositoryErrorException {
        String methodName = "getBaseIgcAssetFromAlternative";
        if (otherAssetType.equals("host_(engine)")) {
            IGCSearchCondition igcSearchCondition = new IGCSearchCondition("_id", "=", otherAssetRid);
            IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
            IGCSearch igcSearch = new IGCSearch("host", igcSearchConditionSet);
            igcSearch.setPageSize(2);
            try {
                ItemList hosts = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
                if (!hosts.getItems().isEmpty()) {
                    return (Reference)hosts.getItems().get(0);
                }
                log.warn("Unable to translate host_(engine) to host, returning host_(engine).");
                return super.getBaseIgcAssetFromAlternative(otherAssetType, otherAssetRid, igcomrsRepositoryConnector, cache);
            }
            catch (IGCException e) {
                EndpointMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "getBaseIgcAssetFromAlternative", (Exception)((Object)e), new String[0]);
                return null;
            }
        }
        log.debug("Not a host_(engine) asset, just returning as-is: {}", (Object)otherAssetType);
        return super.getBaseIgcAssetFromAlternative(otherAssetType, otherAssetRid, igcomrsRepositoryConnector, cache);
    }

    @Override
    protected InstanceProperties complexPropertyMappings(ObjectCache cache, EntityMappingInstance entityMap, InstanceProperties instanceProperties) throws RepositoryErrorException {
        instanceProperties = super.complexPropertyMappings(cache, entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        Reference igcEntity = entityMap.getIgcEntity();
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        try {
            String networkAddress = (String)igcRestClient.getPropertyByName(igcEntity, "name");
            instanceProperties = igcomrsRepositoryConnector.getRepositoryHelper().addStringPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), instanceProperties, "networkAddress", networkAddress, "complexPropertyMappings");
        }
        catch (IGCException e) {
            EndpointMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "complexPropertyMappings", (Exception)((Object)e), new String[0]);
        }
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException, RepositoryErrorException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("networkAddress")) {
            log.debug("Adding complex search criteria for: networkAddress");
            String networkAddress = value.valueAsString();
            IGCSearchCondition condition = IGCRepositoryHelper.getRegexSearchCondition(repositoryHelper, repositoryName, "addComplexPropertySearchCriteria", "name", operator, networkAddress);
            igcSearchConditionSet.addCondition(condition);
        }
    }

    private static class Singleton {
        private static final EndpointMapper INSTANCE = new EndpointMapper();

        private Singleton() {
        }
    }
}

