/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCConnectivityException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCParsingException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Classification;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Classificationenabledgroup;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.DataClass;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.InformationAsset;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.MainObject;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.DataClassAssignmentStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClassAssignmentMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(DataClassAssignmentMapper.class);
    private static final String R_DATA_CLASS_ASSIGNMENT = "DataClassAssignment";
    private static final String P_THRESHOLD = "threshold";

    public static DataClassAssignmentMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected DataClassAssignmentMapper() {
        super("main_object", "data_class", "detected_classifications", "classified_assets_detected", R_DATA_CLASS_ASSIGNMENT, "elementsAssignedToDataClass", "dataClassesAssignedToElement");
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.addAlternativePropertyFromOne("selected_classification");
        this.addAlternativePropertyFromTwo("classifications_selected");
        this.setRelationshipLevelIgcAsset("classification", "classifies_asset", "data_class");
        this.addMappedOmrsProperty("confidence");
        this.addMappedOmrsProperty(P_THRESHOLD);
        this.addMappedOmrsProperty("partialMatch");
        this.addMappedOmrsProperty("valueFrequency");
        this.addMappedOmrsProperty("status");
        this.addLiteralPropertyMapping("method", null);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient, ObjectCache cache) throws RepositoryErrorException {
        String methodName = "getProxyOneAssetFromAsset";
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            try {
                Reference classifiedObj;
                Object co = igcRestClient.getPropertyByName(relationshipAsset, "classifies_asset");
                if (co == null || co.equals("") || co.equals("null")) {
                    Reference classification = igcRestClient.getAssetById(relationshipAsset.getId(), cache);
                    classifiedObj = (Reference)igcRestClient.getPropertyByName(classification, "classifies_asset");
                } else {
                    classifiedObj = (Reference)co;
                }
                asList.add(classifiedObj);
            }
            catch (IGCException e) {
                DataClassAssignmentMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "getProxyOneAssetFromAsset", (Exception)((Object)e), new String[0]);
            }
        } else {
            log.debug("Not a classification asset, just returning as-is: {} of type {}", (Object)relationshipAsset.getName(), (Object)relationshipAsset.getType());
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public List<Reference> getProxyTwoAssetFromAsset(Reference relationshipAsset, IGCRestClient igcRestClient, ObjectCache cache) throws RepositoryErrorException {
        String methodName = "getProxyTwoAssetFromAsset";
        String otherAssetType = relationshipAsset.getType();
        ArrayList<Reference> asList = new ArrayList<Reference>();
        if (otherAssetType.equals("classification")) {
            try {
                Reference dataClass;
                Object dc = igcRestClient.getPropertyByName(relationshipAsset, "data_class");
                if (dc == null || dc.equals("") || dc.equals("null")) {
                    Reference classification = igcRestClient.getAssetById(relationshipAsset.getId(), cache);
                    dataClass = (Reference)igcRestClient.getPropertyByName(classification, "data_class");
                } else {
                    dataClass = (Reference)dc;
                }
                asList.add(dataClass);
            }
            catch (IGCException e) {
                DataClassAssignmentMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "getProxyTwoAssetFromAsset", (Exception)((Object)e), new String[0]);
            }
        } else {
            log.debug("Not a classification asset, just returning as-is: {} of type {}", (Object)relationshipAsset.getName(), (Object)relationshipAsset.getType());
            asList.add(relationshipAsset);
        }
        return asList;
    }

    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
        String methodName = "addMappedOMRSRelationships";
        try {
            if (fromIgcObject instanceof DataClass) {
                this.mapDetectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, cache, (DataClass)fromIgcObject, toIgcObject instanceof Classificationenabledgroup ? (Classificationenabledgroup)toIgcObject : null, sequencingOrder, userId);
                this.mapSelectedClassifications_fromDataClass(igcomrsRepositoryConnector, relationships, cache, (DataClass)fromIgcObject, userId);
            } else if (fromIgcObject instanceof Classificationenabledgroup) {
                this.mapDetectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, cache, (Classificationenabledgroup)fromIgcObject, toIgcObject instanceof DataClass ? (DataClass)toIgcObject : null, sequencingOrder, userId);
                this.mapSelectedClassifications_toDataClass(igcomrsRepositoryConnector, relationships, cache, (Classificationenabledgroup)fromIgcObject, userId);
            }
        }
        catch (IGCException e) {
            DataClassAssignmentMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addMappedOMRSRelationships", (Exception)((Object)e), new String[0]);
        }
    }

    @Override
    public List<IGCSearch> getComplexIGCSearchCriteria(IGCOMRSRepositoryConnector repositoryConnector, SearchProperties matchProperties) throws FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getComplexIGCSearchCriteria";
        IGCRestClient igcRestClient = repositoryConnector.getIGCRestClient();
        if (matchProperties == null) {
            return this.getSimpleIGCSearchCriteria();
        }
        List conditions = matchProperties.getConditions();
        if (conditions == null) {
            return this.getSimpleIGCSearchCriteria();
        }
        ArrayList<IGCSearch> searches = new ArrayList<IGCSearch>();
        IGCSearch searchForDataClass = new IGCSearch("data_class");
        searchForDataClass.addProperties(this.getProxyTwoMapping().getRealIgcRelationshipProperties());
        IGCSearchConditionSet conditionsForDataClass = new IGCSearchConditionSet();
        IGCSearch searchForClassification = new IGCSearch("classification");
        try {
            searchForClassification.addProperties(igcRestClient.getAllPropertiesForType("classification"));
        }
        catch (IGCException e) {
            DataClassAssignmentMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "getComplexIGCSearchCriteria", (Exception)((Object)e), new String[0]);
        }
        IGCSearchConditionSet conditionsForClassification = new IGCSearchConditionSet();
        this.addAllConditions(conditionsForDataClass, conditionsForClassification, matchProperties);
        if (conditionsForDataClass.size() > 0) {
            searchForDataClass.addConditions(conditionsForDataClass);
            searches.add(searchForDataClass);
        }
        if (conditionsForClassification.size() > 0) {
            searchForClassification.addConditions(conditionsForClassification);
            searches.add(searchForClassification);
        }
        return searches;
    }

    private void addAllConditions(IGCSearchConditionSet dataClassConditions, IGCSearchConditionSet classificationConditions, SearchProperties matchProperties) throws FunctionNotSupportedException {
        String methodName = "addAllConditions";
        List conditionsToMatch = matchProperties.getConditions();
        if (conditionsToMatch != null) {
            for (PropertyCondition condition : conditionsToMatch) {
                SearchProperties nestedConditions = condition.getNestedConditions();
                if (nestedConditions != null) {
                    IGCSearchConditionSet nestedDataClassConditions = new IGCSearchConditionSet();
                    IGCSearchConditionSet nestedClassificationConditions = new IGCSearchConditionSet();
                    this.addAllConditions(nestedDataClassConditions, nestedClassificationConditions, nestedConditions);
                    if (nestedDataClassConditions.size() > 0) {
                        dataClassConditions.addNestedConditionSet(nestedDataClassConditions);
                    }
                    if (nestedClassificationConditions.size() <= 0) continue;
                    classificationConditions.addNestedConditionSet(nestedClassificationConditions);
                    continue;
                }
                String propertyName = condition.getProperty();
                PropertyComparisonOperator operator = condition.getOperator();
                InstancePropertyValue value = condition.getValue();
                block9 : switch (propertyName) {
                    case "status": {
                        if (value instanceof EnumPropertyValue) {
                            EnumPropertyValue statusToFind = (EnumPropertyValue)value;
                            IGCRepositoryHelper.validateEnumOperator(operator, "addAllConditions");
                            switch (operator) {
                                case EQ: {
                                    switch (statusToFind.getSymbolicName()) {
                                        case "Discovered": {
                                            dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                            this.includeAllDetected(classificationConditions);
                                            break block9;
                                        }
                                        case "Proposed": {
                                            this.includeAllSelected(dataClassConditions);
                                            classificationConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                            break block9;
                                        }
                                    }
                                    this.includeNoResults(dataClassConditions, classificationConditions);
                                    break block9;
                                }
                                case NEQ: {
                                    switch (statusToFind.getSymbolicName()) {
                                        case "Discovered": {
                                            this.includeAllSelected(dataClassConditions);
                                            classificationConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                            break block9;
                                        }
                                        case "Proposed": {
                                            dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                            this.includeAllDetected(classificationConditions);
                                            break block9;
                                        }
                                    }
                                    this.includeAllResults(dataClassConditions, classificationConditions);
                                    break block9;
                                }
                                case IS_NULL: {
                                    this.includeNoResults(dataClassConditions, classificationConditions);
                                    break block9;
                                }
                                case NOT_NULL: {
                                    this.includeAllResults(dataClassConditions, classificationConditions);
                                    break block9;
                                }
                            }
                            throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_SEARCH_COMPARISON.getMessageDefinition(operator.getName(), InstancePropertyCategory.ENUM.getName()), this.getClass().getName(), "addAllConditions");
                        }
                        if (value == null) {
                            if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                this.includeNoResults(dataClassConditions, classificationConditions);
                                break;
                            }
                            if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                this.includeAllResults(dataClassConditions, classificationConditions);
                                break;
                            }
                            throw new FunctionNotSupportedException(IGCOMRSErrorCode.NO_VALUE_FOR_SEARCH.getMessageDefinition("status", operator.getName()), this.getClass().getName(), "addAllConditions");
                        }
                        throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_ENUMERATION.getMessageDefinition("status"), this.getClass().getName(), "addAllConditions");
                    }
                    case "threshold": {
                        if (value instanceof PrimitivePropertyValue) {
                            PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                            IGCRepositoryHelper.validateNumericOperator(operator, ppv.getTypeName(), "addAllConditions");
                            if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                this.includeAllSelected(dataClassConditions);
                            } else if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                            }
                            String igcOperator = IGCRepositoryHelper.getIgcOperator(operator);
                            IGCSearchCondition byThreshold = new IGCSearchCondition(P_THRESHOLD, igcOperator, value.valueAsString());
                            classificationConditions.addCondition(byThreshold);
                            break;
                        }
                        if (value == null) {
                            if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                this.includeAllSelected(dataClassConditions);
                                IGCSearchCondition byThreshold = new IGCSearchCondition(P_THRESHOLD, "isNull", Boolean.valueOf(false));
                                classificationConditions.addCondition(byThreshold);
                                break;
                            }
                            if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                IGCSearchCondition byThreshold = new IGCSearchCondition(P_THRESHOLD, "isNull", Boolean.valueOf(true));
                                classificationConditions.addCondition(byThreshold);
                                break;
                            }
                            throw new FunctionNotSupportedException(IGCOMRSErrorCode.NO_VALUE_FOR_SEARCH.getMessageDefinition(P_THRESHOLD, operator.getName()), this.getClass().getName(), "addAllConditions");
                        }
                        throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition(P_THRESHOLD, value.getTypeName()), this.getClass().getName(), "addAllConditions");
                    }
                    case "partialMatch": {
                        if (value instanceof PrimitivePropertyValue) {
                            IGCRepositoryHelper.validateBooleanOperator(operator, "addAllConditions");
                            boolean isPartialMatch = Boolean.parseBoolean(value.valueAsString());
                            switch (operator) {
                                case EQ: {
                                    dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                    IGCSearchCondition byPartialMatch = new IGCSearchCondition("confidencePercent", isPartialMatch ? "<" : "=", "100");
                                    classificationConditions.addCondition(byPartialMatch);
                                    break block9;
                                }
                                case NEQ: {
                                    dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                    IGCSearchCondition byPartialMatch = new IGCSearchCondition("confidencePercent", isPartialMatch ? "=" : "<", "100");
                                    classificationConditions.addCondition(byPartialMatch);
                                    break block9;
                                }
                                case IS_NULL: {
                                    this.includeAllSelected(dataClassConditions);
                                    classificationConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                    break block9;
                                }
                                case NOT_NULL: {
                                    dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                    this.includeAllDetected(classificationConditions);
                                    break block9;
                                }
                            }
                            log.error("Invalid boolean operation for search: {}", (Object)operator);
                            break;
                        }
                        if (value == null) {
                            if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                this.includeAllSelected(dataClassConditions);
                                classificationConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                break;
                            }
                            if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                this.includeAllDetected(classificationConditions);
                                break;
                            }
                            throw new FunctionNotSupportedException(IGCOMRSErrorCode.NO_VALUE_FOR_SEARCH.getMessageDefinition("partialMatch", operator.getName()), this.getClass().getName(), "addAllConditions");
                        }
                        throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition("partialMatch", value.getTypeName()), this.getClass().getName(), "addAllConditions");
                    }
                    case "valueFrequency": {
                        if (value instanceof PrimitivePropertyValue) {
                            PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                            IGCRepositoryHelper.validateNumericOperator(operator, ppv.getTypeName(), "addAllConditions");
                            try {
                                long valueFreq = Long.parseLong(value.valueAsString());
                                if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                    this.includeAllSelected(dataClassConditions);
                                } else if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                    dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                }
                                String igcOperator = IGCRepositoryHelper.getIgcOperator(operator);
                                IGCSearchCondition byValueFrequency = new IGCSearchCondition("value_frequency", igcOperator, "" + valueFreq);
                                classificationConditions.addCondition(byValueFrequency);
                            }
                            catch (NumberFormatException e) {
                                log.warn("Unable to translate the valueFrequency into a number -- ensuring no results: {}", (Object)value.valueAsString(), (Object)e);
                                dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                            }
                            break;
                        }
                        if (value == null) {
                            if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                this.includeAllSelected(dataClassConditions);
                                IGCSearchCondition byValueFrequency = new IGCSearchCondition("value_frequency", "isNull", Boolean.valueOf(false));
                                classificationConditions.addCondition(byValueFrequency);
                                break;
                            }
                            if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                IGCSearchCondition byValueFrequency = new IGCSearchCondition("value_frequency", "isNull", Boolean.valueOf(true));
                                classificationConditions.addCondition(byValueFrequency);
                                break;
                            }
                            throw new FunctionNotSupportedException(IGCOMRSErrorCode.NO_VALUE_FOR_SEARCH.getMessageDefinition("valueFrequency", operator.getName()), this.getClass().getName(), "addAllConditions");
                        }
                        throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition("valueFrequency", value.getTypeName()), this.getClass().getName(), "addAllConditions");
                    }
                    case "confidence": {
                        if (value instanceof PrimitivePropertyValue) {
                            PrimitivePropertyValue ppv = (PrimitivePropertyValue)value;
                            IGCRepositoryHelper.validateNumericOperator(operator, ppv.getTypeName(), "addAllConditions");
                            try {
                                int confidence = Integer.parseInt(value.valueAsString());
                                if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                    this.includeAllSelected(dataClassConditions);
                                } else if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                    dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                }
                                String igcOperator = IGCRepositoryHelper.getIgcOperator(operator);
                                IGCSearchCondition byValueFrequency = new IGCSearchCondition("confidencePercent", igcOperator, "" + confidence);
                                classificationConditions.addCondition(byValueFrequency);
                            }
                            catch (NumberFormatException e) {
                                log.warn("Unable to translate the confidence into a number -- ensuring no results: {}", (Object)value.valueAsString(), (Object)e);
                                dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                            }
                            break;
                        }
                        if (value == null) {
                            if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                                this.includeAllSelected(dataClassConditions);
                                IGCSearchCondition byConfidence = new IGCSearchCondition("confidencePercent", "isNull", Boolean.valueOf(false));
                                classificationConditions.addCondition(byConfidence);
                                break;
                            }
                            if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                                dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
                                IGCSearchCondition byConfidence = new IGCSearchCondition("confidencePercent", "isNull", Boolean.valueOf(true));
                                classificationConditions.addCondition(byConfidence);
                                break;
                            }
                            throw new FunctionNotSupportedException(IGCOMRSErrorCode.NO_VALUE_FOR_SEARCH.getMessageDefinition("confidence", operator.getName()), this.getClass().getName(), "addAllConditions");
                        }
                        throw new FunctionNotSupportedException(IGCOMRSErrorCode.INVALID_PRIMITIVE.getMessageDefinition("confidence", value.getTypeName()), this.getClass().getName(), "addAllConditions");
                    }
                    default: {
                        if (operator.equals((Object)PropertyComparisonOperator.IS_NULL)) {
                            this.includeAllResults(dataClassConditions, classificationConditions);
                            break;
                        }
                        this.includeNoResults(dataClassConditions, classificationConditions);
                    }
                }
            }
            MatchCriteria matchCriteria = matchProperties.getMatchCriteria();
            if (dataClassConditions.size() > 0) {
                IGCRepositoryHelper.setConditionsFromMatchCriteria(dataClassConditions, matchCriteria);
            }
            if (classificationConditions.size() > 0) {
                IGCRepositoryHelper.setConditionsFromMatchCriteria(classificationConditions, matchCriteria);
            }
        }
    }

    private void includeAllResults(IGCSearchConditionSet dataClassConditions, IGCSearchConditionSet classificationConditions) {
        this.includeAllDetected(classificationConditions);
        this.includeAllSelected(dataClassConditions);
    }

    private void includeAllDetected(IGCSearchConditionSet classificationConditions) {
        IGCSearchCondition cc = new IGCSearchCondition("classifies_asset", "isNull", Boolean.valueOf(true));
        classificationConditions.addCondition(cc);
    }

    private void includeAllSelected(IGCSearchConditionSet dataClassConditions) {
        IGCSearchCondition dcc = new IGCSearchCondition("classifications_selected", "isNull", Boolean.valueOf(true));
        dataClassConditions.addCondition(dcc);
    }

    private void includeNoResults(IGCSearchConditionSet dataClassConditions, IGCSearchConditionSet classificationConditions) {
        dataClassConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
        classificationConditions.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
    }

    private void mapDetectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, ObjectCache cache, DataClass dataClass, Classificationenabledgroup toIgcObject, SequencingOrder sequencingOrder, String userId) throws RepositoryErrorException, IGCConnectivityException, IGCParsingException {
        String methodName = "mapDetectedClassifications_fromDataClass";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchCondition byDataClass = new IGCSearchCondition("data_class", "=", dataClass.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(byDataClass);
        if (toIgcObject != null) {
            IGCSearchCondition byAsset = new IGCSearchCondition("classifies_asset", "=", toIgcObject.getId());
            igcSearchConditionSet.addCondition(byAsset);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        String[] classificationProperties = new String[]{"classifies_asset", "confidencePercent", P_THRESHOLD};
        ItemList<Classification> detectedClassifications = this.getDetectedClassifications(igcomrsRepositoryConnector, classificationProperties, igcSearchConditionSet, sequencingOrder);
        for (Classification detectedClassification : detectedClassifications.getItems()) {
            MainObject classifiedObj = detectedClassification.getClassifiesAsset();
            if (classifiedObj == null || classifiedObj.getType().equals("main_object")) continue;
            Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), cache, (Reference)classifiedObj, (Reference)dataClass, "detected_classifications", userId, detectedClassification.getId());
            this.setDetectedRelationshipProperties(detectedClassification, relationship, repositoryHelper, repositoryName, "mapDetectedClassifications_fromDataClass", igcomrsRepositoryConnector.getIGCVersion());
            log.debug("mapDetectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship.getGUID());
            relationships.add(relationship);
        }
    }

    private void mapSelectedClassifications_fromDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, ObjectCache cache, DataClass dataClass, String userId) throws RepositoryErrorException, IGCConnectivityException, IGCParsingException {
        IGCSearchCondition igcSearchCondition = new IGCSearchCondition("selected_classification", "=", dataClass.getId());
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet(igcSearchCondition);
        IGCSearch igcSearch = new IGCSearch("amazon_s3_data_file_field", igcSearchConditionSet);
        igcSearch.addType("data_file_field");
        igcSearch.addType("database_column");
        igcSearch.addProperties(IGCRestConstants.getModificationProperties());
        igcSearch.addProperty("selected_classification");
        ItemList assetsWithSelected = igcomrsRepositoryConnector.getIGCRestClient().search(igcSearch);
        List allAssetsWithSelected = igcomrsRepositoryConnector.getIGCRestClient().getAllPages(null, assetsWithSelected);
        for (InformationAsset assetWithSelected : allAssetsWithSelected) {
            Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), cache, (Reference)assetWithSelected, (Reference)dataClass, "selected_classification", userId);
            this.setSelectedRelationshipProperties(relationship, igcomrsRepositoryConnector.getIGCVersion());
            log.debug("mapSelectedClassifications_fromDataClass - adding relationship: {}", (Object)relationship.getGUID());
            relationships.add(relationship);
        }
    }

    private void mapDetectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, ObjectCache cache, Classificationenabledgroup fromIgcObject, DataClass dataClass, SequencingOrder sequencingOrder, String userId) throws RepositoryErrorException, IGCConnectivityException, IGCParsingException {
        String methodName = "mapDetectedClassifications_toDataClass";
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        IGCSearchConditionSet igcSearchConditionSet = new IGCSearchConditionSet();
        if (fromIgcObject != null) {
            IGCSearchCondition byAsset = new IGCSearchCondition("classifies_asset", "=", fromIgcObject.getId());
            igcSearchConditionSet.addCondition(byAsset);
        }
        if (dataClass != null) {
            IGCSearchCondition byDataClass = new IGCSearchCondition("data_class", "=", dataClass.getId());
            igcSearchConditionSet.addCondition(byDataClass);
            igcSearchConditionSet.setMatchAnyCondition(false);
        }
        String[] classificationProperties = new String[]{"confidencePercent", "data_class", P_THRESHOLD};
        ItemList<Classification> detectedClassifications = this.getDetectedClassifications(igcomrsRepositoryConnector, classificationProperties, igcSearchConditionSet, sequencingOrder);
        for (Classification detectedClassification : detectedClassifications.getItems()) {
            DataClass dataClassObj = detectedClassification.getDataClass();
            if (dataClassObj == null || dataClassObj.getType() == null || dataClassObj.getType().equals("main_object")) continue;
            Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), cache, (Reference)fromIgcObject, (Reference)dataClassObj, "detected_classifications", userId, detectedClassification.getId());
            this.setDetectedRelationshipProperties(detectedClassification, relationship, repositoryHelper, repositoryName, "mapDetectedClassifications_toDataClass", igcomrsRepositoryConnector.getIGCVersion());
            log.debug("mapDetectedClassifications_toDataClass - adding relationship: {}", (Object)relationship.getGUID());
            relationships.add(relationship);
        }
    }

    private void mapSelectedClassifications_toDataClass(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, ObjectCache cache, Classificationenabledgroup fromIgcObject, String userId) throws RepositoryErrorException, IGCConnectivityException, IGCParsingException {
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        DataClass selectedClassification = fromIgcObject.getSelectedClassification();
        if (selectedClassification == null) {
            Classificationenabledgroup withSelectedClassification = (Classificationenabledgroup)igcRestClient.getAssetWithSubsetOfProperties(fromIgcObject.getId(), fromIgcObject.getType(), new String[]{"selected_classification"});
            selectedClassification = withSelectedClassification.getSelectedClassification();
        }
        if (selectedClassification != null && selectedClassification.getType() != null) {
            Relationship relationship = DataClassAssignmentMapper.getMappedRelationship(igcomrsRepositoryConnector, DataClassAssignmentMapper.getInstance(igcomrsRepositoryConnector.getIGCVersion()), (RelationshipDef)igcomrsRepositoryConnector.getRepositoryHelper().getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), R_DATA_CLASS_ASSIGNMENT), cache, (Reference)fromIgcObject, (Reference)selectedClassification, "selected_classification", userId);
            this.setSelectedRelationshipProperties(relationship, igcomrsRepositoryConnector.getIGCVersion());
            log.debug("mapSelectedClassifications_toDataClass - adding relationship: {}", (Object)relationship.getGUID());
            relationships.add(relationship);
        } else {
            log.debug("No selected_classification set for asset -- skipping.");
        }
    }

    private ItemList<Classification> getDetectedClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String[] classificationProperties, IGCSearchConditionSet igcSearchConditionSet, SequencingOrder sequencingOrder) throws IGCConnectivityException, IGCParsingException {
        ItemList detectedClassifications;
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        IGCSearch igcSearch = new IGCSearch("classification", classificationProperties, igcSearchConditionSet);
        IGCVersionEnum igcVersion = igcomrsRepositoryConnector.getIGCVersion();
        if (igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) {
            igcSearch.addProperty("value_frequency");
        }
        IGCSearchSorting sorting = null;
        if (sequencingOrder != null && sequencingOrder.equals((Object)SequencingOrder.GUID)) {
            sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
        }
        if (sorting != null) {
            igcSearch.addSortingCriteria(sorting);
        }
        if (igcSearchConditionSet.size() > 0) {
            detectedClassifications = igcRestClient.search(igcSearch);
            List allPages = igcRestClient.getAllPages(null, detectedClassifications);
            detectedClassifications.setAllPages(allPages);
        } else {
            igcSearchConditionSet.addCondition(IGCRestConstants.getConditionToForceNoSearchResults());
            detectedClassifications = igcRestClient.search(igcSearch);
        }
        return detectedClassifications;
    }

    private void setDetectedRelationshipProperties(Classification detectedClassification, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String repositoryName, String methodName, IGCVersionEnum igcVersion) {
        Number valFreq;
        Number threshold;
        Number confidence;
        InstanceProperties relationshipProperties = relationship.getProperties();
        if (relationshipProperties == null) {
            relationshipProperties = new InstanceProperties();
        }
        if ((confidence = detectedClassification.getConfidencepercent()) != null) {
            int confidenceVal = confidence.intValue();
            relationshipProperties = repositoryHelper.addIntPropertyToInstance(repositoryName, relationshipProperties, "confidence", confidenceVal, methodName);
            relationshipProperties = repositoryHelper.addBooleanPropertyToInstance(repositoryName, relationshipProperties, "partialMatch", confidenceVal < 100, methodName);
        }
        if ((threshold = detectedClassification.getThreshold()) != null) {
            relationshipProperties = repositoryHelper.addFloatPropertyToInstance(repositoryName, relationshipProperties, P_THRESHOLD, threshold.floatValue(), methodName);
        }
        if ((igcVersion.isEqualTo(IGCVersionEnum.V11702) || igcVersion.isHigherThan(IGCVersionEnum.V11702)) && (valFreq = detectedClassification.getValueFrequency()) != null) {
            relationshipProperties = repositoryHelper.addLongPropertyToInstance(repositoryName, relationshipProperties, "valueFrequency", valFreq.longValue(), methodName);
        }
        EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcVersion).getEnumMappingByIgcValue("discovered");
        relationshipProperties.setProperty("status", (InstancePropertyValue)status);
        relationship.setProperties(relationshipProperties);
    }

    private void setSelectedRelationshipProperties(Relationship relationship, IGCVersionEnum igcVersion) {
        InstanceProperties relationshipProperties = relationship.getProperties();
        if (relationshipProperties == null) {
            relationshipProperties = new InstanceProperties();
        }
        EnumPropertyValue status = DataClassAssignmentStatusMapper.getInstance(igcVersion).getEnumMappingByIgcValue("selected");
        relationshipProperties.setProperty("status", (InstancePropertyValue)status);
        relationship.setProperties(relationshipProperties);
    }

    private static class Singleton {
        private static final DataClassAssignmentMapper INSTANCE = new DataClassAssignmentMapper();

        private Singleton() {
        }
    }
}

