/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.TermAssignmentStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticAssignmentMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(SemanticAssignmentMapper.class);

    public static SemanticAssignmentMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected SemanticAssignmentMapper() {
        super("database_column", "term", "assigned_to_terms", "assigned_assets", "SemanticAssignment", "assignedElements", "meaning");
        RelationshipMapping.ProxyMapping pmOne = this.getProxyOneMapping();
        pmOne.addAdditionalAssetType("database");
        pmOne.addAdditionalAssetType("data_class");
        pmOne.addAdditionalAssetType("data_file");
        pmOne.addAdditionalAssetType("database_schema");
        pmOne.addAdditionalAssetType("host");
        pmOne.addAdditionalAssetType("data_file_folder");
        pmOne.addAdditionalAssetType("category");
        pmOne.addAdditionalAssetType("database_column");
        pmOne.addAdditionalAssetType("database_table");
        pmOne.addAdditionalAssetType("data_file_field");
        pmOne.addAdditionalAssetType("data_file_record");
        this.addLiteralPropertyMapping("description", null);
        this.addLiteralPropertyMapping("expression", null);
        this.addLiteralPropertyMapping("status", TermAssignmentStatusMapper.getInstance(null).getDefaultEnumValue());
        this.addLiteralPropertyMapping("confidence", 100);
        this.addLiteralPropertyMapping("steward", null);
        this.addLiteralPropertyMapping("source", null);
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference oneObject, Reference otherObject) throws RepositoryErrorException {
        boolean isClassification;
        log.debug("Considering inclusion of objects: {} ({}) and {} ({})", new Object[]{oneObject.getName(), oneObject.getType(), otherObject.getName(), otherObject.getType()});
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        boolean bl = isClassification = ClassificationMapping.isClassification(igcRestClient, cache, oneObject) || ClassificationMapping.isClassification(igcRestClient, cache, otherObject);
        if (isClassification) {
            log.debug(" ... skipping, reserved Classification object.");
        }
        return !isClassification;
    }

    private static class Singleton {
        private static final SemanticAssignmentMapper INSTANCE = new SemanticAssignmentMapper();

        private Singleton() {
        }
    }
}

