/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.base.Term;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.ItemList;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearch;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchSorting;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.GlossaryMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermAnchorMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(TermAnchorMapper.class);

    public static TermAnchorMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected TermAnchorMapper() {
        super("category", "term", "terms", "parent_category", "TermAnchor", "anchor", "terms", "GL", null);
        this.setOptimalStart(RelationshipMapping.OptimalStart.CUSTOM);
        this.setContainedType(RelationshipMapping.ContainedType.TWO);
    }

    @Override
    public List<Reference> getProxyOneAssetFromAsset(Reference term, IGCRestClient igcRestClient, ObjectCache cache) throws RepositoryErrorException {
        ArrayList<Reference> asList;
        block5: {
            String methodName = "getProxyOneAssetFromAsset";
            String assetType = term.getType();
            asList = new ArrayList<Reference>();
            if (assetType.equals("term")) {
                try {
                    Identity termIdentity = term.getIdentity(igcRestClient, cache);
                    if (termIdentity != null) {
                        Identity rootIdentity = termIdentity.getUltimateParentIdentity();
                        Reference root = new Reference(rootIdentity.getName(), rootIdentity.getAssetType(), rootIdentity.getRid());
                        root.setContext(Collections.emptyList());
                        asList.add(root);
                        break block5;
                    }
                    log.error("Term has no identity: {}", (Object)term);
                }
                catch (IGCException e) {
                    TermAnchorMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "getProxyOneAssetFromAsset", (Exception)((Object)e), new String[0]);
                }
            } else {
                log.warn("Not a term asset, just returning as-is: {}", (Object)term);
                asList.add(term);
            }
        }
        return asList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addMappedOMRSRelationships(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Relationship> relationships, ObjectCache cache, Reference fromIgcObject, Reference toIgcObject, int fromRelationshipElement, SequencingOrder sequencingOrder, int pageSize, String userId) throws RepositoryErrorException {
        String methodName = "addMappedOMRSRelationships";
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)fromIgcObject.getType());
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        RelationshipDef relationshipDef = (RelationshipDef)repositoryHelper.getTypeDefByName(igcomrsRepositoryConnector.getRepositoryName(), "TermAnchor");
        if (GlossaryMapper.isGlossary(igcRestClient, cache, fromIgcObject)) {
            IGCSearchCondition byParent;
            IGCSearchCondition byCatPath;
            IGCSearchConditionSet conditionSet = new IGCSearchConditionSet();
            if (toIgcObject == null) {
                log.debug("Looking for all offspring terms from: {} of type {}", (Object)fromIgcObject.getName(), (Object)fromIgcObject.getType());
                byCatPath = new IGCSearchCondition("parent_category.category_path", "=", fromIgcObject.getId());
                byParent = new IGCSearchCondition("parent_category", "=", fromIgcObject.getId());
                conditionSet.addCondition(byCatPath);
                conditionSet.addCondition(byParent);
                conditionSet.setMatchAnyCondition(true);
            } else {
                log.debug("Looking for single terms for: {} of type {}", (Object)toIgcObject.getName(), (Object)toIgcObject.getType());
                byCatPath = new IGCSearchCondition("parent_category.category_path", "=", fromIgcObject.getId());
                byParent = new IGCSearchCondition("parent_category", "=", fromIgcObject.getId());
                IGCSearchCondition byTerm = new IGCSearchCondition("_id", "=", toIgcObject.getId());
                IGCSearchConditionSet inGlossary = new IGCSearchConditionSet(byCatPath);
                inGlossary.addCondition(byParent);
                inGlossary.setMatchAnyCondition(true);
                IGCSearchConditionSet byTermCS = new IGCSearchConditionSet(byTerm);
                conditionSet.addNestedConditionSet(byTermCS);
                conditionSet.addNestedConditionSet(inGlossary);
                conditionSet.setMatchAnyCondition(false);
            }
            IGCSearch igcSearch = new IGCSearch("term", IGCRestConstants.getModificationProperties(), conditionSet);
            IGCSearchSorting sorting = IGCRepositoryHelper.sortFromNonPropertySequencingOrder(sequencingOrder);
            if (sorting != null) {
                igcSearch.addSortingCriteria(sorting);
            }
            if (pageSize > 0) {
                igcSearch.setPageSize(fromRelationshipElement + pageSize);
            }
            try {
                ItemList terms = igcRestClient.search(igcSearch);
                if (terms == null) return;
                if (pageSize == 0) {
                    List allPages = igcRestClient.getAllPages(null, terms);
                    terms.setAllPages(allPages);
                }
                log.debug(" ... found a total of {} offspring terms.", (Object)terms.getItems().size());
                for (Term term : terms.getItems()) {
                    Relationship relationship = TermAnchorMapper.getMappedRelationship(igcomrsRepositoryConnector, TermAnchorMapper.getInstance(null), relationshipDef, cache, fromIgcObject, (Reference)term, "terms", userId, null, true);
                    relationships.add(relationship);
                }
                return;
            }
            catch (IGCException e) {
                TermAnchorMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addMappedOMRSRelationships", (Exception)((Object)e), new String[0]);
                return;
            }
        }
        if (assetType.equals("term")) {
            try {
                Identity catIdentity = fromIgcObject.getIdentity(igcRestClient, cache);
                Identity rootIdentity = catIdentity.getUltimateParentIdentity();
                Reference root = igcRestClient.getAssetWithSubsetOfProperties(rootIdentity.getRid(), rootIdentity.getAssetType(), IGCRestConstants.getModificationProperties());
                if (root != null) {
                    log.debug("Mapping ultimate parent category from: {} of type {}", (Object)fromIgcObject.getName(), (Object)fromIgcObject.getType());
                    Relationship relationship = TermAnchorMapper.getMappedRelationship(igcomrsRepositoryConnector, TermAnchorMapper.getInstance(null), relationshipDef, cache, root, fromIgcObject, "parent_category", userId, null, true);
                    relationships.add(relationship);
                    return;
                }
                log.error("Unable to find root-level category with identity: {}", (Object)rootIdentity);
                return;
            }
            catch (IGCException e) {
                TermAnchorMapper.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addMappedOMRSRelationships", (Exception)((Object)e), new String[0]);
            }
            return;
        }
        log.warn("Found unexpected asset type during relationship mapping: {}", (Object)fromIgcObject);
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference oneObject, Reference otherObject) throws RepositoryErrorException {
        log.debug("Considering inclusion of objects: {} ({}) and {} ({})", new Object[]{oneObject.getName(), oneObject.getType(), otherObject.getName(), otherObject.getType()});
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        return GlossaryMapper.isGlossary(igcRestClient, cache, oneObject) && otherObject.getType().equals("term") || oneObject.getType().equals("term") && GlossaryMapper.isGlossary(igcRestClient, cache, otherObject);
    }

    private static class Singleton {
        private static final TermAnchorMapper INSTANCE = new TermAnchorMapper();

        private Singleton() {
        }
    }
}

