/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceMapping {
    private static final Logger log = LoggerFactory.getLogger(InstanceMapping.class);
    private boolean searchable = true;
    private Map<String, Object> literalOmrsPropertyMapping = new HashMap<String, Object>();
    private static final Set<String> HEADER_PROPERTIES = InstanceMapping.createHeaderProperties();

    private static Set<String> createHeaderProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add("type");
        set.add("instanceProvenanceType");
        set.add("metadataCollectionId");
        set.add("metadataCollectionName");
        set.add("replicatedBy");
        set.add("instanceLicense");
        set.add("createdBy");
        set.add("updatedBy");
        set.add("maintainedBy");
        set.add("createTime");
        set.add("updateTime");
        set.add("version");
        set.add("mappingProperties");
        set.add("guid");
        set.add("instanceURL");
        return Collections.unmodifiableSet(set);
    }

    public static Set<String> getHeaderProperties() {
        return HEADER_PROPERTIES;
    }

    public InstanceMapping() {
    }

    public InstanceMapping(boolean searchable) {
        this();
        this.searchable = searchable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void addLiteralPropertyMapping(String omrsPropertyName, Object value) {
        this.literalOmrsPropertyMapping.put(omrsPropertyName, value);
    }

    public void removeLiteralPropertyMapping(String omrsPropertyName) {
        if (this.literalOmrsPropertyMapping.containsKey(omrsPropertyName)) {
            this.literalOmrsPropertyMapping.remove(omrsPropertyName);
        }
    }

    public Set<String> getLiteralPropertyMappings() {
        return this.literalOmrsPropertyMapping.keySet();
    }

    public Object getOmrsPropertyLiteralValue(String omrsPropertyName) {
        Object value = null;
        if (this.literalOmrsPropertyMapping.containsKey(omrsPropertyName)) {
            value = this.literalOmrsPropertyMapping.get(omrsPropertyName);
        }
        return value;
    }

    public boolean isOmrsPropertyLiteralMapped(String omrsPropertyName) {
        return this.literalOmrsPropertyMapping.containsKey(omrsPropertyName);
    }

    public abstract Set<String> getMappedOmrsPropertyNames();

    public SearchFilter getAllNoneOrSome(IGCOMRSRepositoryConnector repositoryConnector, SearchProperties matchProperties) {
        SearchFilter filter = SearchFilter.SOME;
        if (matchProperties != null) {
            Set<String> mappedOmrsProperties = this.getMappedOmrsPropertyNames();
            MatchCriteria matchCriteria = matchProperties.getMatchCriteria();
            ArrayList conditions = matchProperties.getConditions();
            if (conditions == null) {
                conditions = new ArrayList();
            }
            boolean allValuesAreUnequal = true;
            for (PropertyCondition condition : conditions) {
                SearchProperties nestedConditions = condition.getNestedConditions();
                if (nestedConditions != null) {
                    filter = this.getAllNoneOrSome(repositoryConnector, nestedConditions);
                    if (matchCriteria.equals((Object)MatchCriteria.NONE) && !filter.equals((Object)SearchFilter.NONE) || matchCriteria.equals((Object)MatchCriteria.ALL) && !filter.equals((Object)SearchFilter.ALL)) {
                        log.debug("Requested search with NONE criteria but non-NONE nested filter, or ALL criteria and non-ALL nested filter: {}", (Object)nestedConditions);
                        filter = SearchFilter.NONE;
                        break;
                    }
                    if (!matchCriteria.equals((Object)MatchCriteria.ANY) || filter.equals((Object)SearchFilter.NONE)) continue;
                    filter = SearchFilter.ALL;
                    break;
                }
                String omrsPropertyName = condition.getProperty();
                if (InstanceMapping.getHeaderProperties().contains(omrsPropertyName) && !this.isKnownInstanceHeaderProperty(repositoryConnector, condition)) {
                    log.debug("Requested search for header property against which search is not supported: {}", (Object)condition);
                    filter = SearchFilter.NONE;
                    break;
                }
                if (!mappedOmrsProperties.contains(omrsPropertyName)) {
                    log.debug("Requested search against a property with no mapping: {}", (Object)condition);
                    filter = SearchFilter.NONE;
                    break;
                }
                if (!this.isOmrsPropertyLiteralMapped(omrsPropertyName)) continue;
                Object literalValue = this.getOmrsPropertyLiteralValue(omrsPropertyName);
                boolean valuesAreEqual = IGCRepositoryHelper.equivalentValues(literalValue, condition.getOperator(), condition.getValue());
                if (valuesAreEqual && !matchCriteria.equals((Object)MatchCriteria.ALL)) {
                    if (matchCriteria.equals((Object)MatchCriteria.NONE)) {
                        log.debug("Requested search with NONE criteria, but found a literal-mapped property that matches: {}", (Object)condition);
                        filter = SearchFilter.NONE;
                    } else {
                        filter = SearchFilter.ALL;
                    }
                    allValuesAreUnequal = false;
                    break;
                }
                if (valuesAreEqual || !matchCriteria.equals((Object)MatchCriteria.ALL)) continue;
                log.debug("Requested search with ALL criteria, but found a literal-mapped property that does not match: {}", (Object)condition);
                filter = SearchFilter.NONE;
                break;
            }
            if (allValuesAreUnequal && matchCriteria.equals((Object)MatchCriteria.NONE)) {
                filter = SearchFilter.ALL;
            }
        }
        return filter;
    }

    private boolean isKnownInstanceHeaderProperty(IGCOMRSRepositoryConnector repositoryConnector, PropertyCondition condition) {
        boolean known;
        String omrsPropertyName = condition.getProperty();
        PropertyComparisonOperator operator = condition.getOperator();
        InstancePropertyValue value = condition.getValue();
        switch (omrsPropertyName) {
            case "metadataCollectionId": {
                String actualMCID = repositoryConnector.getMetadataCollectionId();
                if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                    known = true;
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.EQ)) {
                    known = actualMCID.equals(value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.LIKE)) {
                    known = actualMCID.matches(value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                    known = !actualMCID.equals(value.valueAsString());
                    break;
                }
                known = false;
                break;
            }
            case "metadataCollectionName": {
                String actualMCName = repositoryConnector.getMetadataCollectionName();
                if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                    known = actualMCName != null;
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.EQ)) {
                    if (value == null) {
                        known = actualMCName == null;
                        break;
                    }
                    known = Objects.equals(actualMCName, value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.LIKE)) {
                    if (value == null) {
                        known = actualMCName == null;
                        break;
                    }
                    if (actualMCName == null) {
                        known = false;
                        break;
                    }
                    known = actualMCName.matches(value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                    if (value == null) {
                        known = actualMCName != null;
                        break;
                    }
                    known = !Objects.equals(actualMCName, value.valueAsString());
                    break;
                }
                known = false;
                break;
            }
            case "replicatedBy": 
            case "instanceLicense": 
            case "mappingProperties": {
                known = value == null;
                break;
            }
            case "createdBy": 
            case "updatedBy": 
            case "maintainedBy": 
            case "createTime": 
            case "updateTime": 
            case "version": 
            case "type": {
                known = true;
                break;
            }
            default: {
                known = false;
            }
        }
        return known;
    }

    public static void setupInstanceModDetails(InstanceAuditHeader header, String createdBy, Date createTime, String updatedBy, Date updateTime) {
        TreeSet<String> maintainers = new TreeSet<String>();
        if (createdBy != null) {
            header.setCreatedBy(createdBy);
            header.setCreateTime(createTime);
            maintainers.add(createdBy);
        }
        if (updatedBy != null) {
            header.setUpdatedBy(updatedBy);
            header.setUpdateTime(updateTime);
            maintainers.add(updatedBy);
        }
        if (header.getUpdateTime() != null) {
            header.setVersion(header.getUpdateTime().getTime());
        }
        if (!maintainers.isEmpty()) {
            header.setMaintainedBy(new ArrayList(maintainers));
        }
    }

    public static enum SearchFilter {
        ALL,
        NONE,
        SOME;

    }
}

