/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Identity;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ConfidentialityMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.SpineAttributeMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.SpineObjectMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.ReferenceableMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelatedTermMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.ReplacementTermMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.SynonymMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.TermAnchorMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.TermCategorizationMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.TermHASARelationshipMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.TermISATypeOFRelationshipMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.TranslationMapper;

public class GlossaryTermMapper
extends ReferenceableMapper {
    public static GlossaryTermMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected GlossaryTermMapper() {
        super("term", "Term", "GlossaryTerm");
        this.addSimplePropertyMapping("name", "displayName");
        this.addSimplePropertyMapping("short_description", "summary");
        this.addSimplePropertyMapping("long_description", "description");
        this.addSimplePropertyMapping("example", "examples");
        this.addSimplePropertyMapping("abbreviation", "abbreviation");
        this.addSimplePropertyMapping("usage", "usage");
        this.addRelationshipMapper(TermAnchorMapper.getInstance(null));
        this.addRelationshipMapper(TermCategorizationMapper.getInstance(null));
        this.addRelationshipMapper(SynonymMapper.getInstance(null));
        this.addRelationshipMapper(RelatedTermMapper.getInstance(null));
        this.addRelationshipMapper(ReplacementTermMapper.getInstance(null));
        this.addRelationshipMapper(TranslationMapper.getInstance(null));
        this.addRelationshipMapper(TermHASARelationshipMapper.getInstance(null));
        this.addRelationshipMapper(TermISATypeOFRelationshipMapper.getInstance(null));
        this.addClassificationMapper(ConfidentialityMapper.getInstance(null));
        this.addClassificationMapper(SpineObjectMapper.getInstance(null));
        this.addClassificationMapper(SpineAttributeMapper.getInstance(null));
    }

    @Override
    public boolean isOmrsType(IGCRestClient igcRestClient, ObjectCache cache, Reference igcObject) {
        String assetType = IGCRestConstants.getAssetTypeForSearch((String)igcObject.getType());
        if (assetType.equals("term")) {
            Identity termIdentity = igcObject.getIdentity(igcRestClient, cache);
            Identity ultimateParentIdentity = termIdentity.getUltimateParentIdentity();
            return ultimateParentIdentity != null && !ultimateParentIdentity.getName().equals("Classifications");
        }
        return false;
    }

    @Override
    public IGCSearchConditionSet getIGCSearchCriteria() {
        IGCSearchCondition notClassification = new IGCSearchCondition("category_path.name", "=", "Classifications", Boolean.valueOf(true));
        IGCSearchConditionSet conditions = new IGCSearchConditionSet(notClassification);
        conditions.setMatchAnyCondition(false);
        return conditions;
    }

    private static class Singleton {
        private static final GlossaryTermMapper INSTANCE = new GlossaryTermMapper();

        private Singleton() {
        }
    }
}

