/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.attributes.TermRelationshipStatusMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.CategoryHierarchyLinkMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermCategorizationMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(TermCategorizationMapper.class);

    public static TermCategorizationMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected TermCategorizationMapper() {
        super("category", "term", "terms", "parent_category", "TermCategorization", "categories", "terms");
        this.addAlternativePropertyFromTwo("referencing_categories");
        this.addLiteralPropertyMapping("description", null);
        this.addLiteralPropertyMapping("status", TermRelationshipStatusMapper.getInstance(null).getEnumMappingByIgcValue("Active"));
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference oneObject, Reference otherObject) {
        return CategoryHierarchyLinkMapper.isCategoryRelationship(igcomrsRepositoryConnector, cache, oneObject, otherObject);
    }

    private static class Singleton {
        private static final TermCategorizationMapper INSTANCE = new TermCategorizationMapper();

        private Singleton() {
        }
    }
}

