/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestConstants;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.model.IGCEntityGuid;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMappingInstance {
    private static final Logger log = LoggerFactory.getLogger(EntityMappingInstance.class);
    private EntityMapping mapping;
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private IGCOMRSMetadataCollection igcomrsMetadataCollection;
    private String userId;
    private String igcEntityType;
    private String igcEntityRid;
    private List<String> igcPropertiesToRetrieve;
    private boolean alreadyRetrieved;
    private Reference igcEntity;
    private EntitySummary omrsSummary;
    private EntityDetail omrsDetail;
    private List<Classification> omrsClassifications;
    private List<Relationship> omrsRelationships;

    private EntityMappingInstance(EntityMapping mapping, IGCOMRSRepositoryConnector igcomrsRepositoryConnector) {
        this.mapping = mapping;
        this.igcomrsRepositoryConnector = igcomrsRepositoryConnector;
        try {
            this.igcomrsMetadataCollection = (IGCOMRSMetadataCollection)igcomrsRepositoryConnector.getMetadataCollection();
        }
        catch (RepositoryErrorException e) {
            throw new OMRSRuntimeException(IGCOMRSErrorCode.REST_CLIENT_FAILURE.getMessageDefinition(igcomrsRepositoryConnector.getServerName()), this.getClass().getName(), "EntityMappingInstance", (Throwable)e);
        }
    }

    public EntityMappingInstance(EntityMapping mapping, IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, String igcEntityType, String igcEntityRid, String userId) throws RepositoryErrorException {
        this(mapping, igcomrsRepositoryConnector);
        this.igcEntityType = igcEntityType;
        this.igcEntityRid = igcEntityRid;
        this.userId = userId;
        this.omrsRelationships = new ArrayList<Relationship>();
        this.omrsClassifications = new ArrayList<Classification>();
        this.alreadyRetrieved = false;
        String methodName = "EntityMappingInstance";
        try {
            if (igcomrsRepositoryConnector.getIGCRestClient().hasModificationDetails(igcEntityType)) {
                for (String property : IGCRestConstants.getModificationProperties()) {
                    mapping.addComplexIgcProperty(property);
                }
            }
        }
        catch (IGCException e) {
            EntityMappingInstance.raiseRepositoryErrorException("EntityMappingInstance", (Exception)((Object)e));
        }
        Reference simple = mapping.getBaseIgcAssetFromAlternative(igcEntityType, igcEntityRid, igcomrsRepositoryConnector, cache);
        if (simple != null) {
            this.igcEntityType = simple.getType();
            this.igcEntityRid = simple.getId();
        }
    }

    public EntityMappingInstance(EntityMapping mapping, IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference igcEntity, String userId) throws RepositoryErrorException {
        this(mapping, igcomrsRepositoryConnector);
        this.igcEntity = igcEntity;
        this.igcEntityType = igcEntity.getType();
        this.igcEntityRid = igcEntity.getId();
        this.userId = userId;
        this.omrsRelationships = new ArrayList<Relationship>();
        this.omrsClassifications = new ArrayList<Classification>();
        this.alreadyRetrieved = true;
        Reference simple = mapping.getBaseIgcAssetFromAlternative(this.igcEntityType, this.igcEntityRid, igcomrsRepositoryConnector, cache);
        if (simple != null && !simple.getId().equals(this.igcEntityRid)) {
            this.igcEntityType = simple.getType();
            this.igcEntityRid = simple.getId();
            this.alreadyRetrieved = false;
        }
    }

    public final EntityMapping getMapping() {
        return this.mapping;
    }

    public final IGCOMRSRepositoryConnector getRepositoryConnector() {
        return this.igcomrsRepositoryConnector;
    }

    public final IGCOMRSMetadataCollection getMetadataCollection() {
        return this.igcomrsMetadataCollection;
    }

    public final String getUserId() {
        return this.userId;
    }

    public final String getIgcEntityType() {
        return this.igcEntityType;
    }

    public final String getIgcEntityRid() {
        return this.igcEntityRid;
    }

    public final boolean isIgcEntityAlreadyRetrieved() {
        return this.alreadyRetrieved;
    }

    public final Reference getIgcEntity() {
        return this.igcEntity;
    }

    public final void setPropertiesToRetrieveForIgcEntity(List<String> properties) {
        this.igcPropertiesToRetrieve = properties;
    }

    public final void updateOmrsDetailWithProperties(InstanceProperties instanceProperties) {
        this.omrsDetail.setProperties(instanceProperties);
    }

    public final EntitySummary getOmrsSummary(ObjectCache cache) throws RepositoryErrorException {
        if (this.mapping.isOmrsType(this.igcomrsRepositoryConnector.getIGCRestClient(), cache, this.igcEntity)) {
            return this.omrsSummary;
        }
        return null;
    }

    public final EntityDetail getOmrsDetail(ObjectCache cache) throws RepositoryErrorException {
        if (this.mapping.isOmrsType(this.igcomrsRepositoryConnector.getIGCRestClient(), cache, this.igcEntity)) {
            return this.omrsDetail;
        }
        return null;
    }

    public List<Classification> getOmrsClassifications() {
        return this.omrsClassifications;
    }

    public List<Relationship> getOmrsRelationships() {
        return this.omrsRelationships;
    }

    public final void initializeEntitySummary() throws RepositoryErrorException {
        String methodName = "initializeEntitySummary";
        if (this.omrsSummary == null) {
            try {
                this.omrsSummary = this.igcomrsRepositoryConnector.getRepositoryHelper().getSkeletonEntitySummary(this.igcomrsRepositoryConnector.getRepositoryName(), this.igcomrsRepositoryConnector.getMetadataCollectionId(), this.igcomrsRepositoryConnector.getMetadataCollectionName(), InstanceProvenanceType.LOCAL_COHORT, this.userId, this.mapping.getOmrsTypeDefName());
                IGCEntityGuid igcEntityGuid = this.igcomrsMetadataCollection.getIgcRepositoryHelper().getEntityGuid(this.igcEntityType, this.mapping.getIgcRidPrefix(), this.igcEntityRid);
                this.omrsSummary.setGUID(igcEntityGuid.toString());
                if (!(this.alreadyRetrieved || this.igcEntity != null && this.igcEntity.isFullyRetrieved())) {
                    this.igcEntity = this.igcomrsRepositoryConnector.getIGCRestClient().getAssetWithSubsetOfProperties(this.igcEntityRid, this.igcEntityType, this.igcPropertiesToRetrieve);
                }
            }
            catch (TypeErrorException e) {
                log.error("Unable to get skeleton summary entity, defaulting to basic summary.", (Throwable)e);
            }
            catch (IGCException e) {
                EntityMappingInstance.raiseRepositoryErrorException("initializeEntitySummary", (Exception)((Object)e));
            }
        }
    }

    public final void initializeEntityDetail() throws RepositoryErrorException {
        String methodName = "initializeEntityDetail";
        if (this.omrsDetail == null) {
            try {
                this.omrsDetail = this.igcomrsRepositoryConnector.getRepositoryHelper().getSkeletonEntity(this.igcomrsRepositoryConnector.getRepositoryName(), this.igcomrsRepositoryConnector.getMetadataCollectionId(), this.igcomrsRepositoryConnector.getMetadataCollectionName(), InstanceProvenanceType.LOCAL_COHORT, this.userId, this.mapping.getOmrsTypeDefName());
                this.omrsDetail.setStatus(InstanceStatus.ACTIVE);
                IGCEntityGuid igcEntityGuid = this.igcomrsMetadataCollection.getIgcRepositoryHelper().getEntityGuid(this.igcEntityType, this.mapping.getIgcRidPrefix(), this.igcEntityRid);
                this.omrsDetail.setGUID(igcEntityGuid.toString());
                if (!(this.alreadyRetrieved || this.igcEntity != null && this.igcEntity.isFullyRetrieved())) {
                    try {
                        this.igcEntity = this.igcomrsRepositoryConnector.getIGCRestClient().getAssetWithSubsetOfProperties(this.igcEntityRid, this.igcEntityType, this.igcPropertiesToRetrieve);
                    }
                    catch (IGCException e) {
                        EntityMappingInstance.raiseRepositoryErrorException("initializeEntityDetail", (Exception)((Object)e));
                    }
                }
            }
            catch (TypeErrorException e) {
                log.error("Unable to get skeleton detail entity, defaulting to basic summary.", (Throwable)e);
            }
        }
    }

    public final void initializeIGCReference() throws RepositoryErrorException {
        String methodName = "initializeIGCReference";
        if (this.igcEntity == null || !this.igcEntity.isFullyRetrieved()) {
            IGCRestClient igcRestClient = this.igcomrsRepositoryConnector.getIGCRestClient();
            TreeSet<String> directProperties = new TreeSet<String>();
            List<RelationshipMapping> relationshipMappers = this.mapping.getRelationshipMappers();
            for (RelationshipMapping relationshipMapping : relationshipMappers) {
                directProperties.addAll(relationshipMapping.getDirectRelationshipPropertiesForType(this.igcEntityType));
            }
            try {
                if (igcRestClient.hasModificationDetails(this.igcEntityType)) {
                    directProperties.addAll(IGCRestConstants.getModificationProperties());
                }
                this.igcEntity = this.igcomrsRepositoryConnector.getIGCRestClient().getAssetWithSubsetOfProperties(this.getIgcEntityRid(), this.getIgcEntityType(), new ArrayList(directProperties));
            }
            catch (IGCException e) {
                EntityMappingInstance.raiseRepositoryErrorException("initializeIGCReference", (Exception)((Object)e));
            }
        }
    }

    private static void raiseRepositoryErrorException(String methodName, Exception cause) throws RepositoryErrorException {
        throw new RepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), EntityMappingInstance.class.getName(), methodName, (Throwable)cause);
    }
}

