/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.errors.IGCException;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceMapping {
    private static final Logger log = LoggerFactory.getLogger(InstanceMapping.class);
    private boolean searchable = true;
    private Map<String, Object> literalOmrsPropertyMapping = new HashMap<String, Object>();
    private static final Set<String> HEADER_PROPERTIES = InstanceMapping.createHeaderProperties();

    private static Set<String> createHeaderProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add("type");
        set.add("instanceProvenanceType");
        set.add("metadataCollectionId");
        set.add("metadataCollectionName");
        set.add("replicatedBy");
        set.add("instanceLicense");
        set.add("createdBy");
        set.add("updatedBy");
        set.add("maintainedBy");
        set.add("createTime");
        set.add("updateTime");
        set.add("version");
        set.add("mappingProperties");
        set.add("guid");
        set.add("instanceURL");
        return Collections.unmodifiableSet(set);
    }

    public static Set<String> getHeaderProperties() {
        return HEADER_PROPERTIES;
    }

    public InstanceMapping() {
    }

    public InstanceMapping(boolean searchable) {
        this();
        this.searchable = searchable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void addLiteralPropertyMapping(String omrsPropertyName, Object value) {
        this.literalOmrsPropertyMapping.put(omrsPropertyName, value);
    }

    public void removeLiteralPropertyMapping(String omrsPropertyName) {
        if (this.literalOmrsPropertyMapping.containsKey(omrsPropertyName)) {
            this.literalOmrsPropertyMapping.remove(omrsPropertyName);
        }
    }

    public Set<String> getLiteralPropertyMappings() {
        return this.literalOmrsPropertyMapping.keySet();
    }

    public Object getOmrsPropertyLiteralValue(String omrsPropertyName) {
        Object value = null;
        if (this.literalOmrsPropertyMapping.containsKey(omrsPropertyName)) {
            value = this.literalOmrsPropertyMapping.get(omrsPropertyName);
        }
        return value;
    }

    public boolean isOmrsPropertyLiteralMapped(String omrsPropertyName) {
        return this.literalOmrsPropertyMapping.containsKey(omrsPropertyName);
    }

    public abstract Set<String> getMappedOmrsPropertyNames();

    public SearchFilter getAllNoneOrSome(IGCOMRSRepositoryConnector repositoryConnector, SearchProperties matchProperties) {
        SearchFilter filter = SearchFilter.SOME;
        if (matchProperties != null) {
            Set<String> mappedOmrsProperties = this.getMappedOmrsPropertyNames();
            MatchCriteria matchCriteria = matchProperties.getMatchCriteria();
            ArrayList conditions = matchProperties.getConditions();
            if (conditions == null) {
                conditions = new ArrayList();
            }
            boolean allValuesAreUnequal = true;
            for (PropertyCondition condition : conditions) {
                SearchProperties nestedConditions = condition.getNestedConditions();
                if (nestedConditions != null) {
                    filter = this.getAllNoneOrSome(repositoryConnector, nestedConditions);
                    if (matchCriteria.equals((Object)MatchCriteria.NONE) && !filter.equals((Object)SearchFilter.NONE) || matchCriteria.equals((Object)MatchCriteria.ALL) && !filter.equals((Object)SearchFilter.ALL)) {
                        log.debug("Requested search with NONE criteria but non-NONE nested filter, or ALL criteria and non-ALL nested filter: {}", (Object)nestedConditions);
                        filter = SearchFilter.NONE;
                        break;
                    }
                    if (!matchCriteria.equals((Object)MatchCriteria.ANY) || filter.equals((Object)SearchFilter.NONE)) continue;
                    filter = SearchFilter.ALL;
                    break;
                }
                String omrsPropertyName = condition.getProperty();
                if (InstanceMapping.getHeaderProperties().contains(omrsPropertyName)) {
                    if (this.isKnownInstanceHeaderProperty(repositoryConnector, condition)) continue;
                    log.debug("Requested search for header property against which search is not supported: {}", (Object)condition);
                    filter = SearchFilter.NONE;
                    break;
                }
                if (!mappedOmrsProperties.contains(omrsPropertyName)) {
                    log.debug("Requested search against a property with no mapping: {}", (Object)condition);
                    filter = SearchFilter.NONE;
                    break;
                }
                if (!this.isOmrsPropertyLiteralMapped(omrsPropertyName)) continue;
                Object literalValue = this.getOmrsPropertyLiteralValue(omrsPropertyName);
                boolean valuesAreEqual = IGCRepositoryHelper.equivalentValues(literalValue, condition.getOperator(), condition.getValue());
                if (valuesAreEqual && !matchCriteria.equals((Object)MatchCriteria.ALL)) {
                    if (matchCriteria.equals((Object)MatchCriteria.NONE)) {
                        log.debug("Requested search with NONE criteria, but found a literal-mapped property that matches: {}", (Object)condition);
                        filter = SearchFilter.NONE;
                    } else {
                        filter = SearchFilter.ALL;
                    }
                    allValuesAreUnequal = false;
                    break;
                }
                if (valuesAreEqual || !matchCriteria.equals((Object)MatchCriteria.ALL)) continue;
                log.debug("Requested search with ALL criteria, but found a literal-mapped property that does not match: {}", (Object)condition);
                filter = SearchFilter.NONE;
                break;
            }
            if (allValuesAreUnequal && matchCriteria.equals((Object)MatchCriteria.NONE)) {
                filter = SearchFilter.ALL;
            }
        }
        return filter;
    }

    private boolean isKnownInstanceHeaderProperty(IGCOMRSRepositoryConnector repositoryConnector, PropertyCondition condition) {
        boolean known;
        String omrsPropertyName = condition.getProperty();
        PropertyComparisonOperator operator = condition.getOperator();
        InstancePropertyValue value = condition.getValue();
        switch (omrsPropertyName) {
            case "metadataCollectionId": {
                String actualMCID = repositoryConnector.getMetadataCollectionId();
                if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                    known = true;
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.EQ)) {
                    known = actualMCID.equals(value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.LIKE)) {
                    known = actualMCID.matches(value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                    known = !actualMCID.equals(value.valueAsString());
                    break;
                }
                known = false;
                break;
            }
            case "metadataCollectionName": {
                String actualMCName = repositoryConnector.getMetadataCollectionName();
                if (operator.equals((Object)PropertyComparisonOperator.NOT_NULL)) {
                    known = actualMCName != null;
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.EQ)) {
                    if (value == null) {
                        known = actualMCName == null;
                        break;
                    }
                    known = Objects.equals(actualMCName, value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.LIKE)) {
                    if (value == null) {
                        known = actualMCName == null;
                        break;
                    }
                    if (actualMCName == null) {
                        known = false;
                        break;
                    }
                    known = actualMCName.matches(value.valueAsString());
                    break;
                }
                if (operator.equals((Object)PropertyComparisonOperator.NEQ)) {
                    if (value == null) {
                        known = actualMCName != null;
                        break;
                    }
                    known = !Objects.equals(actualMCName, value.valueAsString());
                    break;
                }
                known = false;
                break;
            }
            case "replicatedBy": 
            case "instanceLicense": 
            case "mappingProperties": {
                known = value == null;
                break;
            }
            case "createdBy": 
            case "updatedBy": 
            case "maintainedBy": 
            case "createTime": 
            case "updateTime": 
            case "version": {
                known = true;
                break;
            }
            default: {
                known = false;
            }
        }
        return known;
    }

    public static void setupInstanceModDetails(InstanceAuditHeader header, String createdBy, Date createTime, String updatedBy, Date updateTime) {
        TreeSet<String> maintainers = new TreeSet<String>();
        if (createdBy != null) {
            header.setCreatedBy(createdBy);
            header.setCreateTime(createTime);
            maintainers.add(createdBy);
        }
        if (updatedBy != null) {
            header.setUpdatedBy(updatedBy);
            header.setUpdateTime(updateTime);
            maintainers.add(updatedBy);
        }
        if (header.getUpdateTime() != null) {
            header.setVersion(header.getUpdateTime().getTime());
        }
        if (!maintainers.isEmpty()) {
            header.setMaintainedBy(new ArrayList(maintainers));
        }
    }

    public static void addHeaderPropertySearchCriteria(IGCSearchConditionSet igcSearchConditionSet, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value, EntityMapping mapping, IGCOMRSRepositoryConnector igcomrsRepositoryConnector) throws FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "addHeaderPropertySearchCriteria";
        String igcType = mapping.getIgcAssetType();
        boolean hasModDetails = false;
        try {
            hasModDetails = igcomrsRepositoryConnector.getIGCRestClient().hasModificationDetails(igcType);
        }
        catch (IGCException e) {
            InstanceMapping.raiseRepositoryErrorException(IGCOMRSErrorCode.UNKNOWN_RUNTIME_ERROR, "addHeaderPropertySearchCriteria", (Exception)((Object)e), new String[0]);
        }
        OMRSRepositoryHelper helper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        switch (omrsPropertyName) {
            case "createdBy": {
                if (hasModDetails) {
                    IGCRepositoryHelper.addIGCSearchCondition(helper, repositoryName, igcSearchConditionSet, "created_by", operator, value);
                    break;
                }
                InstanceMapping.raiseUnsupportedPropertyException("addHeaderPropertySearchCriteria", omrsPropertyName, igcType);
                break;
            }
            case "updatedBy": {
                if (hasModDetails) {
                    IGCRepositoryHelper.addIGCSearchCondition(helper, repositoryName, igcSearchConditionSet, "modified_by", operator, value);
                    break;
                }
                InstanceMapping.raiseUnsupportedPropertyException("addHeaderPropertySearchCriteria", omrsPropertyName, igcType);
                break;
            }
            case "createTime": {
                if (hasModDetails) {
                    IGCRepositoryHelper.addIGCSearchCondition(helper, repositoryName, igcSearchConditionSet, "created_on", operator, value);
                    break;
                }
                InstanceMapping.raiseUnsupportedPropertyException("addHeaderPropertySearchCriteria", omrsPropertyName, igcType);
                break;
            }
            case "updateTime": {
                if (hasModDetails) {
                    IGCRepositoryHelper.addIGCSearchCondition(helper, repositoryName, igcSearchConditionSet, "modified_on", operator, value);
                    break;
                }
                InstanceMapping.raiseUnsupportedPropertyException("addHeaderPropertySearchCriteria", omrsPropertyName, igcType);
                break;
            }
            case "maintainedBy": {
                if (hasModDetails) {
                    IGCSearchConditionSet nested = new IGCSearchConditionSet();
                    nested.setMatchAnyCondition(true);
                    IGCRepositoryHelper.addIGCSearchCondition(helper, repositoryName, nested, "created_by", operator, value);
                    IGCRepositoryHelper.addIGCSearchCondition(helper, repositoryName, nested, "modified_by", operator, value);
                    igcSearchConditionSet.addNestedConditionSet(nested);
                    break;
                }
                InstanceMapping.raiseUnsupportedPropertyException("addHeaderPropertySearchCriteria", omrsPropertyName, igcType);
                break;
            }
            case "version": {
                if (!hasModDetails) break;
                IGCRepositoryHelper.addIGCSearchCondition(helper, repositoryName, igcSearchConditionSet, "modified_on", operator, value);
                break;
            }
        }
    }

    public static InstancePropertyValue getHeaderPropertyValue(EntityDetail ed, String propertyName) {
        InstancePropertyValue ipv;
        switch (propertyName) {
            case "createdBy": {
                ipv = InstanceMapping.convertValueToIPV(ed.getCreatedBy());
                break;
            }
            case "updatedBy": {
                ipv = InstanceMapping.convertValueToIPV(ed.getUpdatedBy());
                break;
            }
            case "createTime": {
                ipv = InstanceMapping.convertValueToIPV(ed.getCreateTime());
                break;
            }
            case "updateTime": {
                ipv = InstanceMapping.convertValueToIPV(ed.getUpdateTime());
                break;
            }
            case "maintainedBy": {
                ipv = InstanceMapping.convertValueToIPV(ed.getMaintainedBy());
                break;
            }
            case "version": {
                ipv = InstanceMapping.convertValueToIPV(ed.getVersion());
                break;
            }
            case "metadataCollectionId": {
                ipv = InstanceMapping.convertValueToIPV(ed.getMetadataCollectionId());
                break;
            }
            case "metadataCollectionName": {
                ipv = InstanceMapping.convertValueToIPV(ed.getMetadataCollectionName());
                break;
            }
            case "replicatedBy": {
                ipv = InstanceMapping.convertValueToIPV(ed.getReplicatedBy());
                break;
            }
            case "instanceLicense": {
                ipv = InstanceMapping.convertValueToIPV(ed.getInstanceLicense());
                break;
            }
            case "mappingProperties": {
                ipv = InstanceMapping.convertValueToIPV(ed.getMappingProperties());
                break;
            }
            case "instanceProvenanceType": {
                ipv = InstanceMapping.convertValueToIPV(ed.getInstanceProvenanceType());
                break;
            }
            case "guid": {
                ipv = InstanceMapping.convertValueToIPV(ed.getGUID());
                break;
            }
            case "instanceURL": {
                ipv = InstanceMapping.convertValueToIPV(ed.getInstanceURL());
                break;
            }
            default: {
                ipv = null;
            }
        }
        return ipv;
    }

    private static InstancePropertyValue convertValueToIPV(Object value) {
        PrimitivePropertyValue ipv = null;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            PrimitivePropertyValue ppv = new PrimitivePropertyValue();
            ppv.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            ppv.setPrimitiveValue(value);
            ipv = ppv;
        } else if (value instanceof Date) {
            PrimitivePropertyValue ppv = new PrimitivePropertyValue();
            ppv.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
            ppv.setPrimitiveValue((Object)((Date)value).getTime());
            ipv = ppv;
        } else if (value instanceof Long) {
            PrimitivePropertyValue ppv = new PrimitivePropertyValue();
            ppv.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
            ppv.setPrimitiveValue(value);
            ipv = ppv;
        } else if (value instanceof List) {
            List asList = (List)value;
            ArrayPropertyValue apv = new ArrayPropertyValue();
            apv.setArrayCount(asList.size());
            int index = 0;
            for (Object arrayValue : asList) {
                InstancePropertyValue innerValue = InstanceMapping.convertValueToIPV(arrayValue);
                apv.setArrayValue(index, innerValue);
                ++index;
            }
            ipv = apv;
        } else if (value instanceof Map) {
            Map asMap = (Map)value;
            MapPropertyValue mpv = new MapPropertyValue();
            for (Map.Entry entry : asMap.entrySet()) {
                Object innerValue = entry.getValue();
                mpv.setMapValue((String)entry.getKey(), InstanceMapping.convertValueToIPV(innerValue));
            }
            ipv = mpv;
        } else if (value instanceof InstanceProvenanceType) {
            InstanceProvenanceType asIPT = (InstanceProvenanceType)value;
            EnumPropertyValue epv = new EnumPropertyValue();
            epv.setOrdinal(asIPT.getOrdinal());
            epv.setSymbolicName(asIPT.getName());
            epv.setDescription(asIPT.getDescription());
            ipv = epv;
        }
        return ipv;
    }

    private static void raiseUnsupportedPropertyException(String methodName, String type, String propertyName) throws FunctionNotSupportedException {
        throw new FunctionNotSupportedException(IGCOMRSErrorCode.UNSUPPORTED_PROPERTY_FOR_TYPE.getMessageDefinition(propertyName, type), InstanceMapping.class.getName(), methodName);
    }

    protected static void raiseRepositoryErrorException(IGCOMRSErrorCode errorCode, String methodName, Exception cause, String ... params) throws RepositoryErrorException {
        if (cause == null) {
            throw new RepositoryErrorException(errorCode.getMessageDefinition(params), InstanceMapping.class.getName(), methodName);
        }
        throw new RepositoryErrorException(errorCode.getMessageDefinition(params), InstanceMapping.class.getName(), methodName, (Throwable)cause);
    }

    public static enum SearchFilter {
        ALL,
        NONE,
        SOME;

    }
}

