/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications;

import java.util.List;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.AssetZoneMembershipMapper_DataFile;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.AssetZoneMembershipMapper_Database;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.AssetZoneMembershipMapper_DeployedDatabaseSchema;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.AssetZoneMembershipMapper_FileFolder;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetZoneMembershipMapper
extends ClassificationMapping {
    private static final Logger log = LoggerFactory.getLogger(AssetZoneMembershipMapper.class);

    public static AssetZoneMembershipMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected AssetZoneMembershipMapper() {
        super("", "", "Asset", "AssetZoneMembership");
        this.addMappedOmrsProperty("zoneMembership");
        this.addSubType(AssetZoneMembershipMapper_Database.getInstance(null));
        this.addSubType(AssetZoneMembershipMapper_DeployedDatabaseSchema.getInstance(null));
        this.addSubType(AssetZoneMembershipMapper_FileFolder.getInstance(null));
        this.addSubType(AssetZoneMembershipMapper_DataFile.getInstance(null));
    }

    protected AssetZoneMembershipMapper(String igcAssetType, String igcRelationshipProperty, String omrsEntityType, String omrsClassificationType) {
        super(igcAssetType, igcRelationshipProperty, omrsEntityType, omrsClassificationType);
    }

    @Override
    public void addMappedOMRSClassifications(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, List<Classification> classifications, ObjectCache cache, Reference fromIgcObject, String userId) {
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        List<String> defaultZones = igcomrsRepositoryConnector.getDefaultZones();
        if (defaultZones != null && !defaultZones.isEmpty()) {
            InstanceProperties classificationProperties = repositoryHelper.addStringArrayPropertyToInstance(igcomrsRepositoryConnector.getRepositoryName(), null, "zoneMembership", defaultZones, "addMappedOMRSClassifications");
            try {
                Classification classification = this.getMappedClassification(igcomrsRepositoryConnector, classificationProperties, fromIgcObject, userId);
                classifications.add(classification);
            }
            catch (RepositoryErrorException e) {
                log.error("Unable to setup default zone membership to: {}", defaultZones, (Object)e);
            }
        }
    }

    private static class Singleton {
        private static final AssetZoneMembershipMapper INSTANCE = new AssetZoneMembershipMapper();

        private Singleton() {
        }
    }
}

