/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities;

import org.odpi.egeria.connectors.ibm.igc.auditlog.IGCOMRSErrorCode;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCRepositoryHelper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.EntityMappingInstance;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.AssetZoneMembershipMapper_DataFile;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.DataStoreMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.AssetSchemaTypeMapper_FileRecord;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.NestedFileMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class DataFileMapper
extends DataStoreMapper {
    public static DataFileMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected DataFileMapper() {
        super("data_file", "Data File", "DataFile");
        this.addComplexOmrsProperty("fileType");
        this.addRelationshipMapper(AssetSchemaTypeMapper_FileRecord.getInstance(null));
        this.addRelationshipMapper(NestedFileMapper.getInstance(null));
        this.addClassificationMapper(AssetZoneMembershipMapper_DataFile.getInstance(null));
    }

    @Override
    protected InstanceProperties complexPropertyMappings(ObjectCache cache, EntityMappingInstance entityMap, InstanceProperties instanceProperties) throws RepositoryErrorException {
        instanceProperties = super.complexPropertyMappings(cache, entityMap, instanceProperties);
        String methodName = "complexPropertyMappings";
        IGCOMRSRepositoryConnector igcomrsRepositoryConnector = entityMap.getRepositoryConnector();
        OMRSRepositoryHelper repositoryHelper = igcomrsRepositoryConnector.getRepositoryHelper();
        String repositoryName = igcomrsRepositoryConnector.getRepositoryName();
        Reference igcEntity = entityMap.getIgcEntity();
        String fileName = igcEntity.getName();
        String extension = "";
        if (fileName.contains(".")) {
            extension = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
        }
        instanceProperties = repositoryHelper.addStringPropertyToInstance(repositoryName, instanceProperties, "fileType", extension, "complexPropertyMappings");
        return instanceProperties;
    }

    @Override
    public void addComplexPropertySearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String igcPropertyName, String omrsPropertyName, PropertyComparisonOperator operator, InstancePropertyValue value) throws FunctionNotSupportedException, RepositoryErrorException {
        super.addComplexPropertySearchCriteria(repositoryHelper, repositoryName, igcRestClient, igcSearchConditionSet, igcPropertyName, omrsPropertyName, operator, value);
        String methodName = "addComplexPropertySearchCriteria";
        if (omrsPropertyName.equals("fileType") && value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE)) {
            String extension = value.valueAsString();
            String searchableExtension = repositoryHelper.getUnqualifiedLiteralString(extension);
            IGCRepositoryHelper.validateStringOperator(operator, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName(), "addComplexPropertySearchCriteria");
            IGCSearchCondition condition = null;
            switch (operator) {
                case IS_NULL: {
                    condition = new IGCSearchCondition("name", "like %{0}%", ".", Boolean.valueOf(true));
                    break;
                }
                case NOT_NULL: {
                    condition = new IGCSearchCondition("name", "like %{0}%", ".");
                    break;
                }
                case EQ: {
                    condition = new IGCSearchCondition("name", "like %{0}", searchableExtension);
                    break;
                }
                case NEQ: {
                    condition = new IGCSearchCondition("name", "like %{0}", searchableExtension, Boolean.valueOf(true));
                    break;
                }
                case LIKE: {
                    if (repositoryHelper.isExactMatchRegex(extension) || repositoryHelper.isEndsWithRegex(extension)) {
                        condition = new IGCSearchCondition("name", "like %{0}", searchableExtension);
                        break;
                    }
                    if (repositoryHelper.isStartsWithRegex(extension) || repositoryHelper.isContainsRegex(extension)) {
                        condition = new IGCSearchCondition("name", "like %{0}%", searchableExtension);
                        break;
                    }
                    throw new FunctionNotSupportedException(IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED.getMessageDefinition(repositoryName, extension), this.getClass().getName(), "addComplexPropertySearchCriteria");
                }
            }
            if (condition != null) {
                igcSearchConditionSet.addCondition(condition);
            }
        }
    }

    @Override
    public void addComplexStringSearchCriteria(OMRSRepositoryHelper repositoryHelper, String repositoryName, IGCRestClient igcRestClient, IGCSearchConditionSet igcSearchConditionSet, String searchCriteria) throws FunctionNotSupportedException {
        String methodName = "addComplexStringSearchCriteria";
        String searchableExtension = repositoryHelper.getUnqualifiedLiteralString(searchCriteria);
        if (repositoryHelper.isExactMatchRegex(searchCriteria) || repositoryHelper.isEndsWithRegex(searchCriteria)) {
            IGCSearchCondition endsWith = new IGCSearchCondition("name", "like %{0}", searchableExtension);
            igcSearchConditionSet.addCondition(endsWith);
        } else if (repositoryHelper.isStartsWithRegex(searchCriteria) || repositoryHelper.isContainsRegex(searchCriteria)) {
            IGCSearchCondition contains = new IGCSearchCondition("name", "like %{0}%", searchableExtension);
            igcSearchConditionSet.addCondition(contains);
        } else {
            throw new FunctionNotSupportedException(IGCOMRSErrorCode.REGEX_NOT_IMPLEMENTED.getMessageDefinition(repositoryName, searchCriteria), this.getClass().getName(), "addComplexStringSearchCriteria");
        }
    }

    private static class Singleton {
        private static final DataFileMapper INSTANCE = new DataFileMapper();

        private Singleton() {
        }
    }
}

