/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships;

import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCRestClient;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.IGCVersionEnum;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.cache.ObjectCache;
import org.odpi.egeria.connectors.ibm.igc.clientlibrary.model.common.Reference;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.entities.GlossaryMapper;
import org.odpi.egeria.connectors.ibm.igc.repositoryconnector.mapping.relationships.RelationshipMapping;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryHierarchyLinkMapper
extends RelationshipMapping {
    private static final Logger log = LoggerFactory.getLogger(CategoryHierarchyLinkMapper.class);

    public static CategoryHierarchyLinkMapper getInstance(IGCVersionEnum version) {
        return Singleton.INSTANCE;
    }

    protected CategoryHierarchyLinkMapper() {
        super("category", "category", "subcategories", "parent_category", "CategoryHierarchyLink", "superCategory", "subcategories");
        this.setContainedType(RelationshipMapping.ContainedType.TWO);
    }

    @Override
    public boolean includeRelationshipForIgcObjects(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference oneObject, Reference otherObject) throws RepositoryErrorException {
        return CategoryHierarchyLinkMapper.isCategoryRelationship(igcomrsRepositoryConnector, cache, oneObject, otherObject);
    }

    public static boolean isCategoryRelationship(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, ObjectCache cache, Reference oneObject, Reference otherObject) throws RepositoryErrorException {
        boolean isClassification;
        boolean isGlossary;
        log.debug("Considering inclusion of objects: {} ({}) and {} ({})", new Object[]{oneObject.getName(), oneObject.getType(), otherObject.getName(), otherObject.getType()});
        IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
        boolean bl = isGlossary = GlossaryMapper.isGlossary(igcRestClient, cache, oneObject) || GlossaryMapper.isGlossary(igcRestClient, cache, otherObject);
        if (isGlossary && log.isDebugEnabled()) {
            log.debug(" ... skipping, Glossary-level category.");
        }
        boolean bl2 = isClassification = ClassificationMapping.isClassification(igcRestClient, cache, oneObject) || ClassificationMapping.isClassification(igcRestClient, cache, otherObject);
        if (isClassification && log.isDebugEnabled()) {
            log.debug(" ... skipping, classification object.");
        }
        return !isGlossary && !isClassification;
    }

    private static class Singleton {
        private static final CategoryHierarchyLinkMapper INSTANCE = new CategoryHierarchyLinkMapper();

        private Singleton() {
        }
    }
}

