/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.caching.auditlog;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum CachingOMRSAuditCode implements AuditLogMessageSet
{
    REPOSITORY_SERVICE_STARTING("OMRS-CACHING-REPOSITORY-0001", OMRSAuditLogRecordSeverity.INFO, "The caching repository proxy is starting a new server instance", "The local server has started up a new instance of the caching repository proxy.", "No action is required. This is part of the normal operation of the service."),
    REPOSITORY_SERVICE_STARTED("OMRS-CACHING-REPOSITORY-0002", OMRSAuditLogRecordSeverity.INFO, "The caching repository proxy has started a new instance for server {0}", "The local server has completed startup of a new instance.", "No action is required. This is part of the normal operation of the service."),
    REPOSITORY_SERVICE_SHUTDOWN("OMRS-CACHING-REPOSITORY-0003", OMRSAuditLogRecordSeverity.INFO, "The caching repository proxy has shutdown its instance for server {0}", "The local server has requested shut down of a caching repository proxy instance.", "No action is required. This is part of the normal operation of the service.");

    private final String logMessageId;
    private final OMRSAuditLogRecordSeverity severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private CachingOMRSAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }
}

