/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.caching.repository;

import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.caching.auditlog.CachingOMRSErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class CachedRepositoryAccessor {
    private String className = this.getClass().getName();
    private String userId = null;
    private String serverName;
    private OMRSMetadataCollection metadataCollection = null;

    public CachedRepositoryAccessor() {
    }

    public CachedRepositoryAccessor(String userId, String serverName, OMRSMetadataCollection metadataCollection) {
        this.userId = userId;
        this.serverName = serverName;
        this.metadataCollection = metadataCollection;
    }

    public List<Relationship> getRelationshipsForEntityFromStore(String entityGUID, String relationshipTypeGUID) throws ConnectorCheckedException {
        String methodName = "getRelationshipsForEntityHelper";
        List relationships = null;
        try {
            relationships = this.metadataCollection.getRelationshipsForEntity(this.userId, entityGUID, relationshipTypeGUID, 0, null, null, null, null, 0);
        }
        catch (InvalidParameterException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (RepositoryErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.REPOSITORY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (TypeErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.TYPE_ERROR_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (PropertyErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.PROPERTY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (PagingErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.PAGING_ERROR_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (FunctionNotSupportedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.FUNCTION_NOT_SUPPORTED_ERROR_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (UserNotAuthorizedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.USER_NOT_AUTHORIZED_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (EntityNotKnownException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.ENTITY_NOT_KNOWN, methodName, (Exception)((Object)e), this.serverName, methodName, entityGUID);
        }
        return relationships;
    }

    public EntityDetail getEntityDetailFromStore(String guid) throws ConnectorCheckedException {
        String methodName = "getEntityDetailFromStore";
        EntityDetail entityDetail = null;
        try {
            entityDetail = this.metadataCollection.getEntityDetail(this.userId, guid);
        }
        catch (InvalidParameterException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (RepositoryErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.REPOSITORY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (UserNotAuthorizedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.USER_NOT_AUTHORIZED_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (EntityNotKnownException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.ENTITY_NOT_KNOWN, methodName, (Exception)((Object)e), this.serverName, methodName, guid);
        }
        catch (EntityProxyOnlyException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.ENTITY_PROXY_ONLY, methodName, (Exception)((Object)e), this.serverName, methodName, guid);
        }
        return entityDetail;
    }

    public Relationship getRelationshipFromStore(String guid) throws ConnectorCheckedException {
        String methodName = " getRelationshipFromStore";
        Relationship relationship = null;
        try {
            relationship = this.metadataCollection.getRelationship(this.userId, guid);
        }
        catch (InvalidParameterException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (RepositoryErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.REPOSITORY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (UserNotAuthorizedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.USER_NOT_AUTHORIZED_EXCEPTION, methodName, (Exception)((Object)e), this.serverName, methodName);
        }
        catch (RelationshipNotKnownException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.RELATIONSHIP_NOT_KNOWN, methodName, (Exception)((Object)e), this.serverName, methodName, guid);
        }
        return relationship;
    }

    public void saveRelationshipReferenceCopyToStore(Relationship relationship) throws ConnectorCheckedException {
        String methodName = "storeRelationshipReferenceCopy";
        try {
            if (relationship.getGUID() == null) {
                this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, null, new String[0]);
            }
            if (relationship.getEntityOneProxy() == null) {
                this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, null, new String[0]);
            }
            if (relationship.getEntityOneProxy().getGUID() == null) {
                this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, null, new String[0]);
            }
            if (relationship.getEntityTwoProxy() == null) {
                this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, null, new String[0]);
            }
            if (relationship.getEntityTwoProxy().getGUID() == null) {
                this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, null, new String[0]);
            }
            this.metadataCollection.saveRelationshipReferenceCopy(this.userId, relationship);
        }
        catch (InvalidParameterException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (RepositoryErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.REPOSITORY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (TypeErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.TYPE_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (EntityNotKnownException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.ENTITY_NOT_KNOWN, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (PropertyErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.PROPERTY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (HomeRelationshipException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.HOME_RELATIONSHIP_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (RelationshipConflictException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.RELATIONSHIP_CONFLICT_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (InvalidRelationshipException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_RELATIONSHIP_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (FunctionNotSupportedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.FUNCTION_NOT_SUPPORTED_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (UserNotAuthorizedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.USER_NOT_AUTHORIZED_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
    }

    public void saveEntityReferenceCopyToStore(EntityDetail entityToAdd) throws ConnectorCheckedException {
        String methodName = "saveEntityReferenceCopy";
        if (entityToAdd.getGUID() == null) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, null, new String[0]);
        }
        try {
            this.metadataCollection.saveEntityReferenceCopy(this.userId, entityToAdd);
        }
        catch (InvalidParameterException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_PARAMETER_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (RepositoryErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.REPOSITORY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (TypeErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.TYPE_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (PropertyErrorException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.PROPERTY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (HomeEntityException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.HOME_ENTITY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (EntityConflictException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.ENTITY_CONFLICT_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (InvalidEntityException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.INVALID_ENTITY_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (FunctionNotSupportedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.FUNCTION_NOT_SUPPORTED_ERROR_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
        catch (UserNotAuthorizedException e) {
            this.raiseConnectorCheckedException(CachingOMRSErrorCode.USER_NOT_AUTHORIZED_EXCEPTION, methodName, (Exception)((Object)e), new String[0]);
        }
    }

    public void raiseConnectorCheckedException(CachingOMRSErrorCode errorCode, String methodName, Exception cause, String ... params) throws ConnectorCheckedException {
        if (cause == null) {
            throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), this.className, methodName);
        }
        throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), this.className, methodName, (Throwable)cause);
    }
}

