/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.caching.repositoryconnector;

import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.caching.auditlog.CachingOMRSAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.caching.auditlog.CachingOMRSErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.caching.repositoryconnector.CachingOMRSMetadataCollection;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class CachingOMRSRepositoryProxyConnector
extends OMRSRepositoryConnector
implements VirtualConnectorExtension {
    private List<Connector> embeddedConnectors = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.auditLog.logMessage("start", CachingOMRSAuditCode.REPOSITORY_SERVICE_STARTING.getMessageDefinition());
        CachingOMRSRepositoryProxyConnector cachingOMRSRepositoryProxyConnector = this;
        synchronized (cachingOMRSRepositoryProxyConnector) {
            if (this.metadataCollection == null) {
                try {
                    this.initializeMetadataCollection();
                }
                catch (RepositoryErrorException e) {
                    this.raiseConnectorCheckedException(CachingOMRSErrorCode.REPOSITORY_ERROR_EXCEPTION, "start", (Exception)((Object)e), new String[0]);
                }
            }
            CachingOMRSMetadataCollection cachingCollection = (CachingOMRSMetadataCollection)this.metadataCollection;
            cachingCollection.getEmbeddedOMRSConnector().start();
        }
        this.auditLog.logMessage("start", CachingOMRSAuditCode.REPOSITORY_SERVICE_STARTED.getMessageDefinition(this.getServerName()));
    }

    public synchronized void disconnect() {
        String methodName = "disconnect";
        this.auditLog.logMessage("disconnect", CachingOMRSAuditCode.REPOSITORY_SERVICE_SHUTDOWN.getMessageDefinition(this.getServerName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMRSMetadataCollection getMetadataCollection() throws RepositoryErrorException {
        CachingOMRSRepositoryProxyConnector cachingOMRSRepositoryProxyConnector = this;
        synchronized (cachingOMRSRepositoryProxyConnector) {
            if (this.metadataCollection == null) {
                this.initializeMetadataCollection();
            }
        }
        return super.getMetadataCollection();
    }

    private void initializeMetadataCollection() throws RepositoryErrorException {
        this.metadataCollection = new CachingOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, this.metadataCollectionId, this.embeddedConnectors);
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    private void raiseConnectorCheckedException(CachingOMRSErrorCode errorCode, String methodName, Exception cause, String ... params) throws ConnectorCheckedException {
        if (cause == null) {
            throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new ConnectorCheckedException(errorCode.getMessageDefinition(params), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)cause);
    }
}

