/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.PostgresSourceDatabase;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.ffdc.AlreadyHandledException;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.ffdc.ExceptionHandler;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.ffdc.PostgresConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.ffdc.PostgresConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.mapper.PostgresMapper;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresColumn;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresDatabase;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresForeignKeyLinks;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresSchema;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresTable;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.database.connector.DatabaseIntegratorConnector;

public class PostgresDatabaseConnector
extends DatabaseIntegratorConnector {
    final int startFrom = 0;
    final int pageSize = 0;

    public void refresh() throws ConnectorCheckedException {
        String methodName = "PostgresConnector.refresh";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresDatabase> postgresDatabases = source.getDabases();
            List<DatabaseElement> egeriaDatabases = this.getContext().getMyDatabases(0, 0);
            egeriaDatabases = this.deleteDatabases(postgresDatabases, egeriaDatabases);
            for (PostgresDatabase postgresDatabase : postgresDatabases) {
                boolean found = false;
                if (egeriaDatabases == null) {
                    if (postgresDatabases.size() <= 0) continue;
                    this.addDatabase(postgresDatabase);
                    continue;
                }
                for (DatabaseElement egeriaDatabase : egeriaDatabases) {
                    String postgresQN;
                    String egeriaQN = egeriaDatabase.getDatabaseProperties().getQualifiedName();
                    if (!egeriaQN.equals(postgresQN = postgresDatabase.getQualifiedName())) continue;
                    found = true;
                    this.updateDatabase(postgresDatabase, egeriaDatabase);
                    break;
                }
                if (found) continue;
                this.addDatabase(postgresDatabase);
            }
        }
        catch (SQLException error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
        catch (InvalidParameterException error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
        catch (UserNotAuthorizedException error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
        catch (ConnectorCheckedException error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw error;
        }
        catch (AlreadyHandledException error) {
            throw new ConnectorCheckedException(PostgresConnectorErrorCode.ALREADY_HANDLED_EXCEPTION.getMessageDefinition(((Object)((Object)error)).getClass().getName(), error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)((Object)error));
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
    }

    private void updateDatabase(PostgresDatabase postgresDatabase, DatabaseElement egeriaDatabase) throws AlreadyHandledException {
        String methodName = "updateDatabase";
        try {
            if (egeriaDatabase != null) {
                String guid = egeriaDatabase.getElementHeader().getGUID();
                if (!postgresDatabase.isEquivalent(egeriaDatabase)) {
                    DatabaseProperties props = PostgresMapper.getDatabaseProperties(postgresDatabase);
                    this.getContext().updateDatabase(guid, props);
                }
                this.updateSchemas(guid, postgresDatabase.getName());
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void updateSchemas(String databaseGUID, String name) throws AlreadyHandledException {
        String methodName = "updateSchemas";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresSchema> postgresSchemas = source.getDatabaseSchema(name);
            List<DatabaseSchemaElement> egeriaSchemas = this.getContext().getSchemasForDatabase(databaseGUID, 0, 0);
            if (egeriaSchemas != null) {
                egeriaSchemas = this.deleteSchemas(postgresSchemas, egeriaSchemas);
            }
            for (PostgresSchema postgresSchema : postgresSchemas) {
                boolean found = false;
                if (egeriaSchemas == null) {
                    if (postgresSchemas.size() <= 0) continue;
                    this.addSchemas(name, databaseGUID);
                    continue;
                }
                for (DatabaseSchemaElement egeriaSchema : egeriaSchemas) {
                    if (!egeriaSchema.getDatabaseSchemaProperties().getQualifiedName().equals(postgresSchema.getQualifiedName())) continue;
                    found = true;
                    this.updateSchema(postgresSchema, egeriaSchema);
                    break;
                }
                if (found) continue;
                this.addSchema(postgresSchema, databaseGUID);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void updateSchema(PostgresSchema postgresSchema, DatabaseSchemaElement egeriaSchema) throws AlreadyHandledException {
        String methodName = "updateSchema";
        try {
            if (!postgresSchema.isEquivalent(egeriaSchema)) {
                DatabaseSchemaProperties props = PostgresMapper.getSchemaProperties(postgresSchema);
                this.getContext().updateDatabaseSchema(egeriaSchema.getElementHeader().getGUID(), props);
            }
            this.updateTables(postgresSchema, egeriaSchema);
            this.updateViews(postgresSchema, egeriaSchema);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void updateTables(PostgresSchema postgresSchema, DatabaseSchemaElement egeriaSchema) throws AlreadyHandledException {
        String methodName = "updateTables";
        String schemaGuid = egeriaSchema.getElementHeader().getGUID();
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresTable> postgresTables = source.getTables(postgresSchema.getSchema_name());
            List<DatabaseTableElement> egeriaTables = this.getContext().getTablesForDatabaseSchema(schemaGuid, 0, 0);
            egeriaTables = this.deleteTables(postgresTables, egeriaTables);
            for (PostgresTable postgresTable : postgresTables) {
                boolean found = false;
                if (egeriaTables == null) {
                    if (postgresTables.size() <= 0) continue;
                    this.addTable(postgresTable, schemaGuid);
                    continue;
                }
                for (DatabaseTableElement egeriaTable : egeriaTables) {
                    if (!egeriaTable.getDatabaseTableProperties().getQualifiedName().equals(postgresTable.getQualifiedName())) continue;
                    found = true;
                    this.updateTable(postgresTable, egeriaTable);
                    break;
                }
                if (found) continue;
                this.addTable(postgresTable, schemaGuid);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTables", error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition("updateTables", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition("updateTables"));
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTables", (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateTables", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateTables"));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTables", (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateTables", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateTables"));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTables", (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition("updateTables", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(((Object)((Object)error)).getClass().getName()));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTables", (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateTables", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateTables"));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTables", error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition("updateTables", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition("updateTables"));
        }
    }

    private void updateTable(PostgresTable postgresTable, DatabaseTableElement egeriaTable) throws AlreadyHandledException {
        String methodName = "updateTable";
        try {
            if (postgresTable.isEquivalent(egeriaTable)) {
                DatabaseTableProperties props = PostgresMapper.getTableProperties(postgresTable);
                this.getContext().updateDatabaseTable(egeriaTable.getElementHeader().getGUID(), props);
            }
            this.updateTableColumns(postgresTable, egeriaTable);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(((Object)((Object)error)).getClass().getName()));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void updateViews(PostgresSchema postgresSchema, DatabaseSchemaElement egeriaSchema) throws AlreadyHandledException {
        String methodName = "updateViews";
        String schemaGuid = egeriaSchema.getElementHeader().getGUID();
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresTable> postgresViews = source.getViews(postgresSchema.getSchema_name());
            List<DatabaseViewElement> egeriaViews = this.getContext().getViewsForDatabaseSchema(schemaGuid, 0, 0);
            egeriaViews = this.deleteViews(postgresViews, egeriaViews);
            for (PostgresTable postgresView : postgresViews) {
                boolean found = false;
                if (egeriaViews == null) {
                    if (postgresViews.size() <= 0) continue;
                    this.addView(postgresView, schemaGuid);
                    continue;
                }
                for (DatabaseViewElement egeriaView : egeriaViews) {
                    if (!egeriaView.getDatabaseViewProperties().getQualifiedName().equals(postgresView.getQualifiedName())) continue;
                    found = true;
                    this.updateView(postgresView, egeriaView);
                    break;
                }
                if (found) continue;
                this.addView(postgresView, schemaGuid);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViews", error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition("updateViews", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition("updateViews"));
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViews", (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateViews", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateViews"));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViews", (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateViews", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateViews"));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViews", (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition("updateViews", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition("updateViews"));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViews", (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateViews", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateViews"));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViews", error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition("updateViews", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition("updateViews"));
        }
    }

    private void updateView(PostgresTable postgresTable, DatabaseViewElement egeriaView) throws AlreadyHandledException {
        String methodName = "updateView";
        try {
            if (!postgresTable.isEquivalent(egeriaView)) {
                DatabaseViewProperties props = PostgresMapper.getViewProperties(postgresTable);
                this.getContext().updateDatabaseView(egeriaView.getElementHeader().getGUID(), props);
            }
            this.updateViewColumns(postgresTable, egeriaView);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(((Object)((Object)error)).getClass().getName()));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void updateTableColumns(PostgresTable postgresTable, DatabaseTableElement egeriaTable) throws AlreadyHandledException {
        String methodName = "updateTableColumns";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        String tableGuid = egeriaTable.getElementHeader().getGUID();
        try {
            List<PostgresColumn> postgresColumns = source.getColumns(postgresTable.getTable_name());
            List<DatabaseColumnElement> egeriaColumns = this.getContext().getColumnsForDatabaseTable(tableGuid, 0, 0);
            List<String> primarykeys = source.getPrimaryKeyColumnNamesForTable(postgresTable.getTable_name());
            if (egeriaColumns != null && postgresColumns.size() > 0) {
                egeriaColumns = this.deleteTableColumns(postgresColumns, egeriaColumns);
            }
            for (PostgresColumn postgresColumn : postgresColumns) {
                boolean found = false;
                if (egeriaColumns == null) {
                    if (postgresColumns.size() <= 0) continue;
                    this.addColumn(postgresColumn, tableGuid);
                    continue;
                }
                for (DatabaseColumnElement egeriaColumn : egeriaColumns) {
                    if (egeriaColumn.getDatabaseColumnProperties().getQualifiedName().equals(postgresColumn.getQualifiedName())) {
                        found = true;
                        break;
                    }
                    if (primarykeys.contains(egeriaColumn.getDatabaseColumnProperties().getDisplayName())) {
                        DatabasePrimaryKeyProperties props = new DatabasePrimaryKeyProperties();
                        this.getContext().setPrimaryKeyOnColumn(egeriaColumn.getElementHeader().getGUID(), props);
                        continue;
                    }
                    if (egeriaColumn.getPrimaryKeyProperties() == null) continue;
                    this.getContext().removePrimaryKeyFromColumn(egeriaColumn.getElementHeader().getGUID());
                }
                if (found) continue;
                this.addColumn(postgresColumn, tableGuid);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTableColumns", error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition("updateTableColumns", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition("updateTableColumns"));
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTableColumns", (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateTableColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateTableColumns"));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTableColumns", (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateTableColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateTableColumns"));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTableColumns", (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition("updateTableColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition("updateTableColumns"));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTableColumns", (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateTableColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateTableColumns"));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateTableColumns", error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition("updateTableColumns", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition("updateTableColumns"));
        }
    }

    private void updateViewColumns(PostgresTable postgresTable, DatabaseViewElement egeriaTable) throws AlreadyHandledException {
        String methodName = "updateViewColumns";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        String guid = egeriaTable.getElementHeader().getGUID();
        try {
            List<PostgresColumn> postgresColumns = source.getColumns(postgresTable.getTable_name());
            List<DatabaseColumnElement> egeriaColumns = this.getContext().getColumnsForDatabaseTable(egeriaTable.getElementHeader().getGUID(), 0, 0);
            if (egeriaColumns != null) {
                egeriaColumns = this.deleteViewColumns(postgresColumns, egeriaColumns);
            }
            for (PostgresColumn postgresColumn : postgresColumns) {
                boolean found = false;
                if (egeriaColumns == null) {
                    if (postgresColumns.size() <= 0) continue;
                    this.addColumn(postgresColumn, guid);
                    continue;
                }
                for (DatabaseColumnElement egeriaColumn : egeriaColumns) {
                    if (!egeriaColumn.getDatabaseColumnProperties().getQualifiedName().equals(postgresColumn.getQualifiedName())) continue;
                    found = true;
                    this.updateColumn(postgresColumn, egeriaColumn);
                    break;
                }
                if (found) continue;
                this.addColumn(postgresColumn, guid);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViewColumns", error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition("updateViewColumns", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition("updateViewColumns", error.getClass().getName(), error.getMessage()));
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViewColumns", (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateViewColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition("updateViewColumns"));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViewColumns", (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateViewColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition("updateViewColumns"));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViewColumns", (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition("updateViewColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition("updateViewColumns"));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViewColumns", (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateViewColumns", ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition("updateViewColumns"));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), "updateViewColumns", error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition("updateViewColumns", error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition("updateViewColumns"));
        }
    }

    private void updateColumn(PostgresColumn postgresCol, DatabaseColumnElement egeriaCol) throws AlreadyHandledException {
        String methodName = "updateColumn";
        try {
            if (!postgresCol.isEquivalent(egeriaCol)) {
                DatabaseColumnProperties props = PostgresMapper.getColumnProperties(postgresCol);
                this.getContext().updateDatabaseColumn(egeriaCol.getElementHeader().getGUID(), props);
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addDatabase(PostgresDatabase db) throws AlreadyHandledException {
        String methodName = "addDatabase";
        try {
            DatabaseProperties dbProps = PostgresMapper.getDatabaseProperties(db);
            String guid = this.getContext().createDatabase(dbProps);
            this.addSchemas(db.getName(), guid);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addSchemas(String dbName, String dbGUID) throws AlreadyHandledException {
        String methodName = "addSchemas";
        try {
            PostgresSourceDatabase sourceDB = new PostgresSourceDatabase(this.connectionProperties);
            List<PostgresSchema> schemas = sourceDB.getDatabaseSchema(dbName);
            for (PostgresSchema sch : schemas) {
                this.addSchema(sch, dbGUID);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName));
        }
    }

    private void addSchema(PostgresSchema sch, String dbGuidd) throws AlreadyHandledException {
        String methodName = "addSchema";
        try {
            DatabaseSchemaProperties schemaProps = PostgresMapper.getSchemaProperties(sch);
            String schemaGUID = this.getContext().createDatabaseSchema(dbGuidd, schemaProps);
            this.addTables(sch.getSchema_name(), schemaGUID);
            this.addViews(sch.getSchema_name(), schemaGUID);
            this.addForeignKeys(sch);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addTables(String schemaName, String schemaGUID) throws AlreadyHandledException {
        String methodName = "addTables";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresTable> tables = source.getTables(schemaName);
            for (PostgresTable table : tables) {
                this.addTable(table, schemaGUID);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addTable(PostgresTable table, String schemaGUID) throws AlreadyHandledException {
        String methodName = "addTable";
        try {
            DatabaseTableProperties props = PostgresMapper.getTableProperties(table);
            String tableGUID = this.getContext().createDatabaseTable(schemaGUID, props);
            this.addColumns(table.getTable_name(), tableGUID);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addView(PostgresTable view, String schemaGUID) throws AlreadyHandledException {
        String methodName = "addView";
        try {
            DatabaseViewProperties props = PostgresMapper.getViewProperties(view);
            String tableGUID = this.getContext().createDatabaseView(schemaGUID, props);
            this.addColumns(view.getTable_name(), tableGUID);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addForeignKeys(PostgresSchema schema) throws AlreadyHandledException {
        String methodName = "addForeignKeys";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresTable> tables = source.getTables(schema.getSchema_name());
            for (PostgresTable table : tables) {
                List<PostgresForeignKeyLinks> foreignKeys = source.getForeginKeyLinksForTable(table.getTable_name());
                ArrayList<String> importedGuids = new ArrayList<String>();
                ArrayList<String> exportedGuids = new ArrayList<String>();
                for (PostgresForeignKeyLinks link : foreignKeys) {
                    List exportedEntities;
                    List importedEntities = this.getContext().findDatabaseColumns(link.getImportedColumnQualifiedName(), 0, 0);
                    if (importedEntities != null) {
                        for (DatabaseColumnElement col : importedEntities) {
                            importedGuids.add(col.getReferencedColumnGUID());
                        }
                    }
                    if ((exportedEntities = this.getContext().findDatabaseColumns(link.getExportedColumnQualifiedName(), 0, 0)) != null) {
                        for (DatabaseColumnElement col : exportedEntities) {
                            exportedGuids.add(col.getReferencedColumnGUID());
                        }
                    }
                    for (String str : importedGuids) {
                        DatabaseForeignKeyProperties linkProps = new DatabaseForeignKeyProperties();
                        for (String s : exportedGuids) {
                            this.getContext().addForeignKeyRelationship(str, s, linkProps);
                        }
                    }
                }
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName));
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addViews(String schemaName, String schemaGUID) throws AlreadyHandledException {
        String methodName = "addViews";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresTable> views = source.getViews(schemaName);
            for (PostgresTable view : views) {
                this.addView(view, schemaGUID);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addColumns(String tableName, String tableGUID) throws AlreadyHandledException {
        String methodName = "addColumns";
        PostgresSourceDatabase source = new PostgresSourceDatabase(this.connectionProperties);
        try {
            List<PostgresColumn> cols = source.getColumns(tableName);
            for (PostgresColumn col : cols) {
                this.addColumn(col, tableGUID);
            }
        }
        catch (SQLException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.ERROR_READING_POSTGRES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.ERROR_READING_FROM_POSTGRES.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private void addColumn(PostgresColumn col, String guid) throws AlreadyHandledException {
        String methodName = "addColumn";
        try {
            DatabaseColumnProperties colProps = PostgresMapper.getColumnProperties(col);
            this.getContext().createDatabaseColumn(guid, colProps);
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
    }

    private List<DatabaseElement> deleteDatabases(List<PostgresDatabase> postgresDatabases, List<DatabaseElement> egeriaDatabases) throws AlreadyHandledException {
        String methodName = "deleteDatabases";
        try {
            if (egeriaDatabases != null) {
                Iterator<DatabaseElement> itr = egeriaDatabases.iterator();
                while (itr.hasNext()) {
                    boolean found = false;
                    DatabaseElement egeriaDatabase = itr.next();
                    String knownName = egeriaDatabase.getDatabaseProperties().getQualifiedName();
                    for (PostgresDatabase postgresDatabase : postgresDatabases) {
                        String sourceName = postgresDatabase.getQualifiedName();
                        if (!sourceName.equals(knownName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getContext().removeDatabase(egeriaDatabase.getElementHeader().getGUID(), knownName);
                    itr.remove();
                }
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
        return egeriaDatabases;
    }

    private List<DatabaseSchemaElement> deleteSchemas(List<PostgresSchema> postgresSchemas, List<DatabaseSchemaElement> egeriaSchemas) throws AlreadyHandledException {
        String methodName = "deleteSchemas";
        try {
            if (egeriaSchemas != null) {
                Iterator<DatabaseSchemaElement> itr = egeriaSchemas.iterator();
                while (itr.hasNext()) {
                    boolean found = false;
                    DatabaseSchemaElement egeriaSchema = itr.next();
                    String knownName = egeriaSchema.getDatabaseSchemaProperties().getQualifiedName();
                    for (PostgresSchema postgresSchema : postgresSchemas) {
                        String sourceName = postgresSchema.getQualifiedName();
                        if (!sourceName.equals(knownName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getContext().removeDatabaseSchema(egeriaSchema.getElementHeader().getGUID(), knownName);
                    itr.remove();
                }
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
        return egeriaSchemas;
    }

    private List<DatabaseTableElement> deleteTables(List<PostgresTable> postgresTables, List<DatabaseTableElement> egeriaTables) throws AlreadyHandledException {
        String methodName = "deleteTables";
        try {
            if (egeriaTables != null) {
                Iterator<DatabaseTableElement> itr = egeriaTables.iterator();
                while (itr.hasNext()) {
                    boolean found = false;
                    DatabaseTableElement egeriaTable = itr.next();
                    String knownName = egeriaTable.getDatabaseTableProperties().getQualifiedName();
                    for (PostgresTable postgresTable : postgresTables) {
                        String sourceName = postgresTable.getQualifiedName();
                        if (!sourceName.equals(knownName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getContext().removeDatabaseTable(egeriaTable.getElementHeader().getGUID(), knownName);
                    itr.remove();
                }
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
        return egeriaTables;
    }

    private List<DatabaseViewElement> deleteViews(List<PostgresTable> postgresViews, List<DatabaseViewElement> egeriaViews) throws AlreadyHandledException {
        String methodName = "deleteViews";
        try {
            if (egeriaViews != null) {
                Iterator<DatabaseViewElement> itr = egeriaViews.iterator();
                while (itr.hasNext()) {
                    boolean found = false;
                    DatabaseViewElement egeriaView = itr.next();
                    String knownName = egeriaView.getDatabaseViewProperties().getQualifiedName();
                    for (PostgresTable postgresView : postgresViews) {
                        String sourceName = postgresView.getQualifiedName();
                        if (!sourceName.equals(knownName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getContext().removeDatabaseView(egeriaView.getElementHeader().getGUID(), knownName);
                    itr.remove();
                }
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
        return egeriaViews;
    }

    private List<DatabaseColumnElement> deleteTableColumns(List<PostgresColumn> postgresColumns, List<DatabaseColumnElement> egeriaColumns) throws AlreadyHandledException {
        String methodName = "deleteTableColumns";
        try {
            if (egeriaColumns != null) {
                Iterator<DatabaseColumnElement> itr = egeriaColumns.iterator();
                while (itr.hasNext()) {
                    boolean found = false;
                    DatabaseColumnElement egeriaColumn = itr.next();
                    String knownName = egeriaColumn.getDatabaseColumnProperties().getQualifiedName();
                    for (PostgresColumn postgresColumn : postgresColumns) {
                        String sourceName = postgresColumn.getQualifiedName();
                        if (!sourceName.equals(knownName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getContext().removeDatabaseView(egeriaColumn.getElementHeader().getGUID(), knownName);
                    itr.remove();
                }
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
        return egeriaColumns;
    }

    private List<DatabaseColumnElement> deleteViewColumns(List<PostgresColumn> postgresColumns, List<DatabaseColumnElement> egeriaColumns) throws AlreadyHandledException {
        String methodName = "deleteViewColumns";
        try {
            if (egeriaColumns != null) {
                Iterator<DatabaseColumnElement> itr = egeriaColumns.iterator();
                while (itr.hasNext()) {
                    boolean found = false;
                    DatabaseColumnElement egeriaColumn = itr.next();
                    String knownName = egeriaColumn.getDatabaseColumnProperties().getQualifiedName();
                    for (PostgresColumn postgresColumn : postgresColumns) {
                        String sourceName = postgresColumn.getQualifiedName();
                        if (!sourceName.equals(knownName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.getContext().removeDatabaseView(egeriaColumn.getElementHeader().getGUID(), knownName);
                    itr.remove();
                }
            }
        }
        catch (InvalidParameterException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.INVALID_PARAMETER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (PropertyServerException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.PROPERTY_SERVER_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (UserNotAuthorizedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.USER_NOT_AUTHORIZED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (ConnectorCheckedException error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, (Exception)((Object)error), PostgresConnectorAuditCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName, ((Object)((Object)error)).getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.CONNECTOR_CHECKED_EXCEPTION.getMessageDefinition(methodName));
        }
        catch (Exception error) {
            ExceptionHandler.handleException(this.auditLog, ((Object)((Object)this)).getClass().getName(), methodName, error, PostgresConnectorAuditCode.UNEXPECTED_ERROR.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()), PostgresConnectorErrorCode.UNEXPECTED_ERROR.getMessageDefinition(methodName));
        }
        return egeriaColumns;
    }
}

