/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.postgres;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresColumn;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresDatabase;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresForeignKeyLinks;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresSchema;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresTable;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;

public class PostgresSourceDatabase {
    String instance = null;
    Properties postgresProps = new Properties();

    public PostgresSourceDatabase(ConnectionProperties egeriaProps) {
        Map objProps = egeriaProps.getConfigurationProperties();
        for (Map.Entry obj : objProps.entrySet()) {
            if (!(obj.getValue() instanceof String)) continue;
            this.postgresProps.put(obj.getKey(), String.valueOf(obj.getValue()));
        }
        this.postgresProps.setProperty("user", egeriaProps.getUserId());
        this.postgresProps.setProperty("password", egeriaProps.getClearPassword());
    }

    private String getDatabaseInstance() throws SQLException {
        if (this.instance != null) {
            return this.instance;
        }
        String sql = "SELECT CURRENT_USER usr ,inet_server_addr() host, inet_server_port() port;";
        try (Connection connection = DriverManager.getConnection(this.postgresProps.getProperty("url"), this.postgresProps);
             PreparedStatement ps = connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                this.instance = rs.getString("usr") + "@" + rs.getString("host") + "@" + rs.getString("port");
            }
        }
        return this.instance;
    }

    public List<PostgresDatabase> getDabases() throws SQLException {
        ArrayList<PostgresDatabase> databaseNames = new ArrayList<PostgresDatabase>();
        String sql = "SELECT VERSION(), * FROM pg_database WHERE datistemplate = false;";
        try (Connection connection = DriverManager.getConnection(this.postgresProps.getProperty("url"), this.postgresProps);
             PreparedStatement ps = connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                databaseNames.add(new PostgresDatabase(rs.getString("datname"), rs.getString("encoding"), rs.getString("datcollate"), rs.getString("datctype"), rs.getString("version")));
            }
        }
        return databaseNames;
    }

    public List<PostgresSchema> getDatabaseSchema(String databaseName) throws SQLException {
        String sql = "SELECT *  FROM information_schema.schemata where catalog_name = '%s' ;";
        sql = String.format(sql, databaseName);
        ArrayList<PostgresSchema> schemas = new ArrayList<PostgresSchema>();
        try (Connection conn = DriverManager.getConnection(this.postgresProps.getProperty("url"), this.postgresProps);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                PostgresSchema attributes = new PostgresSchema(rs.getString("catalog_name"), rs.getString("schema_name"), rs.getString("schema_owner"), rs.getString("default_character_set_catalog"), rs.getString("default_character_set_schema"), rs.getString("default_character_set_name"), rs.getString("sql_path"));
                if (attributes.getSchema_name().equals("public")) {
                    if (!this.isSchemaInUse("public")) continue;
                    schemas.add(attributes);
                    continue;
                }
                schemas.add(attributes);
            }
        }
        return schemas;
    }

    private boolean isSchemaInUse(String schema) throws SQLException {
        boolean result = false;
        String sql = "SELECT count(table_schema) AS rowcount FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '%s' ;";
        sql = String.format(sql, schema);
        try (Connection conn = DriverManager.getConnection(this.postgresProps.getProperty("url"), this.postgresProps);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            rs.next();
            if (rs.getInt("rowcount") == 0) {
                result = true;
            }
        }
        return result;
    }

    private List<PostgresTable> getTables(String schemaName, String type) throws SQLException {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '%s' AND table_type = '%s';";
        sql = String.format(sql, schemaName, type);
        ArrayList<PostgresTable> attributes = new ArrayList<PostgresTable>();
        try (Connection conn = DriverManager.getConnection(this.postgresProps.getProperty("url"), this.postgresProps);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                PostgresTable attr = new PostgresTable(rs.getString("table_catalog"), rs.getString("table_schema"), rs.getString("table_name"), rs.getString("table_type"), rs.getString("self_referencing_column_name"), rs.getString("reference_generation"), rs.getString("user_defined_type_catalog"), rs.getString("user_defined_type_schema"), rs.getString("user_defined_type_name"), rs.getString("user_defined_type_name"), rs.getString("is_insertable_into"), rs.getString("commit_action"));
                attributes.add(attr);
            }
        }
        return attributes;
    }

    List<PostgresColumn> getColumns(String tableName) throws SQLException {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '%s';";
        sql = String.format(sql, tableName);
        ArrayList<PostgresColumn> cols = new ArrayList<PostgresColumn>();
        try (Connection conn = DriverManager.getConnection(this.postgresProps.getProperty("url"), this.postgresProps);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                PostgresColumn attr = new PostgresColumn(rs.getString("table_catalog"), rs.getString("table_schema"), rs.getString("table_name"), rs.getString("column_name"), rs.getString("ordinal_position"), rs.getString("column_default"), rs.getString("is_nullable"), rs.getString("data_type"), rs.getString("character_maximum_length"), rs.getString("character_octet_length"), rs.getString("numeric_precision"), rs.getString("numeric_precision_radix"), rs.getString("numeric_scale"), rs.getString("datetime_precision"), rs.getString("interval_type"), rs.getString("interval_precision"), rs.getString("character_set_catalog"), rs.getString("character_set_schema"), rs.getString("character_set_name"), rs.getString("collation_catalog"), rs.getString("collation_schema"), rs.getString("collation_name"), rs.getString("domain_catalog"), rs.getString("domain_schema"), rs.getString("domain_name"), rs.getString("udt_catalog"), rs.getString("udt_schema"), rs.getString("udt_name"), rs.getString("scope_catalog"), rs.getString("scope_schema"), rs.getString("scope_name"), rs.getString("maximum_cardinality"), rs.getString("dtd_identifier"), rs.getString("is_self_referencing"), rs.getString("is_identity"), rs.getString("identity_generation"), rs.getString("identity_start"), rs.getString("identity_increment"), rs.getString("identity_maximum"), rs.getString("identity_minimum"), rs.getString("identity_cycle"), rs.getString("is_generated"), rs.getString("generation_expression"), rs.getString("is_updatable"));
                cols.add(attr);
            }
        }
        return cols;
    }

    public List<PostgresTable> getViews(String schemaName) throws SQLException {
        return this.getTables(schemaName, "VIEW");
    }

    public List<PostgresTable> getTables(String schemaName) throws SQLException {
        return this.getTables(schemaName, "BASE TABLE");
    }

    public List<String> getPrimaryKeyColumnNamesForTable(String tableName) throws SQLException {
        return this.getKeyNamesForTable(tableName, "PRIMARY KEY");
    }

    public List<String> getForeignKeyColumnNamesForTable(String tableName) throws SQLException {
        return this.getKeyNamesForTable(tableName, "FOREIGN KEY");
    }

    private List<String> getKeyNamesForTable(String tableName, String type) throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        String sql = "SELECT c.column_name AS name FROM information_schema.table_constraints tc JOIN information_schema.constraint_column_usage AS ccu USING (constraint_schema, constraint_name) JOIN information_schema.columns AS c ON c.table_schema = tc.constraint_schema AND tc.table_name = c.table_name AND ccu.column_name = c.column_name WHERE constraint_type = '%s' and tc.table_name = '%s';";
        sql = String.format(sql, type, tableName);
        try (Connection conn = DriverManager.getConnection(this.postgresProps.getProperty("url"), this.postgresProps);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                String name = rs.getString("name");
                names.add(name);
            }
        }
        return names;
    }

    /*
     * Exception decompiling
     */
    public List<PostgresForeignKeyLinks> getForeginKeyLinksForTable(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

