/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.postgres.properties;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;

public class PostgresSchema {
    private final String catalog_name;
    private final String schema_name;
    private final String schema_owner;
    private final String default_character_set_catalog;
    private final String default_character_set_schema;
    private final String default_character_set_name;
    private final String sql_path;

    public String getCatalog_name() {
        return this.catalog_name;
    }

    public String getSchema_name() {
        return this.schema_name;
    }

    public String getSchema_owner() {
        return this.schema_owner;
    }

    public String getDefault_character_set_catalog() {
        return this.default_character_set_catalog;
    }

    public String getDefault_character_set_schema() {
        return this.default_character_set_schema;
    }

    public String getDefault_character_set_name() {
        return this.default_character_set_name;
    }

    public String getSql_path() {
        return this.sql_path;
    }

    public PostgresSchema(String catalog_name, String schema_name, String schema_owner, String default_character_set_catalog, String default_character_set_schema, String default_character_set_name, String sql_path) {
        this.catalog_name = catalog_name;
        this.schema_name = schema_name;
        this.schema_owner = schema_owner;
        this.default_character_set_catalog = default_character_set_catalog;
        this.default_character_set_schema = default_character_set_schema;
        this.default_character_set_name = default_character_set_name;
        this.sql_path = sql_path;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("catalog_name", this.getCatalog_name());
        props.put("schema_name", this.getSchema_name());
        props.put("schema_owner", this.getSchema_owner());
        props.put("default_character_set_catalog", this.getDefault_character_set_catalog());
        props.put("default_character_set_schema", this.getDefault_character_set_schema());
        props.put("default_character_set_name", this.getDefault_character_set_name());
        props.put("sql_path", this.getSql_path());
        return props;
    }

    public String getQualifiedName() {
        return this.getSchema_owner() + "::" + this.catalog_name + "::" + this.schema_name;
    }

    public boolean isEquivalent(DatabaseSchemaElement element) {
        boolean result = false;
        Map props = element.getDatabaseSchemaProperties().getAdditionalProperties();
        if (props.equals(this.getProperties())) {
            result = true;
        }
        return result;
    }
}

