/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.postgres.mapper;

import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresColumn;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresDatabase;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresSchema;
import org.odpi.openmetadata.adapters.connectors.integration.postgres.properties.PostgresTable;

public class PostgresMapper {
    public static DatabaseProperties getDatabaseProperties(PostgresDatabase db) {
        DatabaseProperties dbProps = new DatabaseProperties();
        dbProps.setDisplayName(db.getQualifiedName());
        dbProps.setQualifiedName(db.getQualifiedName());
        dbProps.setDatabaseType("postgres");
        dbProps.setDatabaseVersion(db.getVersion());
        dbProps.setEncodingType(db.getEncoding());
        dbProps.setEncodingLanguage(db.getCtype());
        dbProps.setAdditionalProperties(db.getProperties());
        return dbProps;
    }

    public static DatabaseSchemaProperties getSchemaProperties(PostgresSchema sch) {
        DatabaseSchemaProperties schemaProps = new DatabaseSchemaProperties();
        schemaProps.setDisplayName(sch.getQualifiedName());
        schemaProps.setQualifiedName(sch.getQualifiedName());
        schemaProps.setAdditionalProperties(sch.getProperties());
        return schemaProps;
    }

    public static DatabaseTableProperties getTableProperties(PostgresTable table) {
        DatabaseTableProperties tableProps = new DatabaseTableProperties();
        tableProps.setDisplayName(table.getTable_name());
        tableProps.setQualifiedName(table.getQualifiedName());
        tableProps.setAdditionalProperties(table.getProperties());
        return tableProps;
    }

    public static DatabaseViewProperties getViewProperties(PostgresTable table) {
        DatabaseViewProperties tableProps = new DatabaseViewProperties();
        tableProps.setDisplayName(table.getTable_name());
        tableProps.setQualifiedName(table.getQualifiedName());
        tableProps.setAdditionalProperties(table.getProperties());
        return tableProps;
    }

    public static DatabaseColumnProperties getColumnProperties(PostgresColumn col) {
        DatabaseColumnProperties colProps = new DatabaseColumnProperties();
        colProps.setDisplayName(col.getColumn_name());
        colProps.setQualifiedName(col.getQualifiedName());
        colProps.setDataType(col.getData_type());
        if (col.getMaximum_cardinality() != null) {
            try {
                colProps.setMaxCardinality(Integer.valueOf(col.getMaximum_cardinality()).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        colProps.setAdditionalProperties(col.getProperties());
        return colProps;
    }
}

