/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.migration.model;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.MapEntry;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.Constants;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.migration.model.UpgradePersistence;
import xtdb.api.HistoryOptions;
import xtdb.api.ICursor;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public class Upgrade2To3
extends UpgradePersistence {
    static final String OLD_NS = "uniqueProperties";
    static final String NEW_NS = "entityProperties";

    public Upgrade2To3(IXtdb xtdbAPI, int batchSize) {
        super(xtdbAPI, 2L, 3L, batchSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void migrateMetadata() throws Exception {
        HistoryOptions options = HistoryOptions.create((HistoryOptions.SortOrder)HistoryOptions.SortOrder.DESC);
        IXtdbDatasource db = this.xtdbAPI.db();
        try (ICursor searchCursor = db.openQuery((Object)this.getAllEntityProxiesQuery(), new Object[0]);){
            while (searchCursor.hasNext()) {
                List next = (List)searchCursor.next();
                String docId = (String)next.get(0);
                ICursor historyCursor = db.openEntityHistory((Object)docId, options);
                try {
                    while (historyCursor.hasNext()) {
                        Map version = (Map)historyCursor.next();
                        Object oValid = version.get(Constants.XTDB_VALID_TIME);
                        Object oTxn = version.get(Constants.XTDB_TX_TIME);
                        if (!(oValid instanceof Date) || !(oTxn instanceof Date)) continue;
                        Date valid = (Date)oValid;
                        Date txn = (Date)oTxn;
                        XtdbDocument doc = this.xtdbAPI.db(valid, txn).entity((Object)docId);
                        XtdbDocument upgraded = this.migrateEntityProxy(doc);
                        this.putToBatch(upgraded, valid, null);
                    }
                }
                finally {
                    if (historyCursor == null) continue;
                    historyCursor.close();
                }
            }
            return;
        }
    }

    private XtdbDocument migrateEntityProxy(XtdbDocument doc) {
        IPersistentMap map = doc.toMap();
        for (MapEntry entry : map) {
            Object oldKey = entry.getKey();
            String oldKeyName = oldKey.toString().substring(1);
            if (!oldKeyName.startsWith(OLD_NS)) continue;
            String newKeyName = oldKeyName.replace(OLD_NS, NEW_NS);
            doc = doc.minus(oldKeyName).plus(newKeyName, entry.getValue());
        }
        return doc;
    }

    private IPersistentMap getAllEntityProxiesQuery() {
        Symbol docVar = Symbol.intern((String)"ep");
        PersistentArrayMap query = PersistentArrayMap.EMPTY;
        PersistentVector conditions = PersistentVector.create((Object[])new Object[]{docVar, Keyword.intern((String)EntityProxyMapping.ENTITY_PROXY_ONLY_MARKER), true});
        query = query.assoc((Object)Keyword.intern((String)"find"), (Object)PersistentVector.create((Object[])new Object[]{docVar}));
        query = query.assoc((Object)Keyword.intern((String)"where"), (Object)PersistentVector.create((Object[])new Object[]{conditions}));
        return query;
    }
}

