/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.migration.model;

import java.util.Date;
import org.odpi.egeria.connectors.juxt.xtdb.model.PersistenceLayer;
import xtdb.api.IXtdb;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public abstract class UpgradePersistence {
    protected final IXtdb xtdbAPI;
    private final long fromVersion;
    private final long toVersion;
    private final int batchSize;
    private Transaction.Builder tx;
    private int txSize;

    protected UpgradePersistence(IXtdb xtdbAPI, long from, long to, int batchSize) {
        this.xtdbAPI = xtdbAPI;
        this.fromVersion = from;
        this.toVersion = to;
        this.batchSize = batchSize;
        this.setNewTransactionQueue();
    }

    public long getFromVersion() {
        return this.fromVersion;
    }

    public long getToVersion() {
        return this.toVersion;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public final void migrate() throws Exception {
        this.migrateMetadata();
        this.markUpdatedVersion();
    }

    public abstract void migrateMetadata() throws Exception;

    protected void putToBatch(XtdbDocument doc, Date valid, Date txn) {
        if (doc != null) {
            this.tx.put(doc, valid, txn);
            ++this.txSize;
            if (this.txSize == this.batchSize) {
                this.submitBatch();
                this.setNewTransactionQueue();
            }
        }
    }

    private void submitBatch() {
        this.xtdbAPI.submitTx(this.tx.build());
    }

    private void setNewTransactionQueue() {
        this.tx = Transaction.builder();
        this.txSize = 0;
    }

    private void markUpdatedVersion() {
        PersistenceLayer.setVersion((IXtdb)this.xtdbAPI, (long)this.toVersion);
    }
}

