/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.migration;

import java.io.File;
import org.odpi.egeria.connectors.juxt.xtdb.migration.model.Upgrade2To3;
import org.odpi.egeria.connectors.juxt.xtdb.migration.model.UpgradeInitialTo2;
import org.odpi.egeria.connectors.juxt.xtdb.model.PersistenceLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;

public class Migrator {
    public static final int DEFAULT_BATCH_SIZE = 500;
    private static final Logger log = LoggerFactory.getLogger(Migrator.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            log.error("No configuration file path provided. The path to a JSON configuration file for the node must be provided.");
            System.exit(1);
        }
        String configFile = args[0];
        File config = new File(configFile);
        int batchSize = 500;
        if (args.length == 2) {
            try {
                batchSize = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                log.warn("Unable to parse batch size '{}' as an integer -- falling back to default batch size.", (Object)args[1]);
            }
        }
        log.info("Starting a XTDB node using configuration: {}", (Object)configFile);
        try (IXtdb xtdbAPI = IXtdb.startNode((File)config);){
            log.info("... checking if migration is needed ({})", (Object)xtdbAPI);
            if (PersistenceLayer.isLatestVersion((IXtdb)xtdbAPI)) {
                log.info("This node is already at the latest version of the persistence layer ({}) -- no migration needed.", (Object)3L);
            } else {
                while (!PersistenceLayer.isLatestVersion((IXtdb)xtdbAPI)) {
                    long currentVersion = PersistenceLayer.getVersion((IXtdb)xtdbAPI);
                    log.info("The node is at version {}, while latest is {} -- migrating...", (Object)currentVersion, (Object)3L);
                    if (currentVersion == -1L) {
                        UpgradeInitialTo2 upgradeInitialTo2 = new UpgradeInitialTo2(xtdbAPI, batchSize);
                        upgradeInitialTo2.migrate();
                        continue;
                    }
                    if (currentVersion != 2L) continue;
                    Upgrade2To3 upgrade2To3 = new Upgrade2To3(xtdbAPI, batchSize);
                    upgrade2To3.migrate();
                }
            }
        }
        catch (Exception e) {
            log.error("Fatal error!", (Throwable)e);
        }
        log.info("Work complete -- exiting.");
    }
}

