/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.migration.model;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.Constants;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.migration.model.UpgradePersistence;
import xtdb.api.HistoryOptions;
import xtdb.api.ICursor;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public class UpgradeInitialTo2
extends UpgradePersistence {
    static final String TYPE_DEF_GUID = "type.guid";
    static final String SUPERTYPE_DEF_GUIDS = "type.supers";
    static final String TYPE_DEF_GUIDS = "type.guids";
    static final String ENTITY_ONE_PROXY = "entityOneProxy";
    static final String ENTITY_TWO_PROXY = "entityTwoProxy";
    static final String ENTITY_PROXIES = "entityProxies";

    public UpgradeInitialTo2(IXtdb xtdbAPI, int batchSize) {
        super(xtdbAPI, -1L, 2L, batchSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void migrateMetadata() throws Exception {
        HistoryOptions options = HistoryOptions.create((HistoryOptions.SortOrder)HistoryOptions.SortOrder.DESC);
        IXtdbDatasource db = this.xtdbAPI.db();
        try (ICursor searchCursor = db.openQuery((Object)this.getAllInstancesQuery(), new Object[0]);){
            while (searchCursor.hasNext()) {
                List next = (List)searchCursor.next();
                String docId = (String)next.get(0);
                ICursor historyCursor = db.openEntityHistory((Object)docId, options);
                try {
                    while (historyCursor.hasNext()) {
                        Map version = (Map)historyCursor.next();
                        Object oValid = version.get(Constants.XTDB_VALID_TIME);
                        Object oTxn = version.get(Constants.XTDB_TX_TIME);
                        if (!(oValid instanceof Date) || !(oTxn instanceof Date)) continue;
                        Date valid = (Date)oValid;
                        Date txn = (Date)oTxn;
                        XtdbDocument doc = this.xtdbAPI.db(valid, txn).entity((Object)docId);
                        XtdbDocument upgraded = this.migrateInstanceAuditHeader(doc);
                        if (this.isRelationship(upgraded)) {
                            upgraded = this.migrateRelationship(upgraded);
                        }
                        this.putToBatch(upgraded, valid, null);
                    }
                }
                finally {
                    if (historyCursor == null) continue;
                    historyCursor.close();
                }
            }
            return;
        }
    }

    private XtdbDocument migrateInstanceAuditHeader(XtdbDocument doc) {
        Object typeDefGuid = doc.get(TYPE_DEF_GUID);
        Object superTypeDefGuids = doc.get(SUPERTYPE_DEF_GUIDS);
        ArrayList<Object> types = new ArrayList<Object>();
        if (typeDefGuid != null) {
            types.add(typeDefGuid);
        }
        if (superTypeDefGuids instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)superTypeDefGuids;
            for (int i = 0; i < v.length(); ++i) {
                Object supertype = v.nth(i);
                if (supertype == null) continue;
                types.add(supertype);
            }
        }
        HashSet<String> remove = new HashSet<String>();
        remove.add(TYPE_DEF_GUID);
        remove.add(SUPERTYPE_DEF_GUIDS);
        return doc.minusAll(remove).plus(TYPE_DEF_GUIDS, (Object)PersistentVector.create(types));
    }

    private XtdbDocument migrateRelationship(XtdbDocument doc) {
        Object proxyOne = doc.get(ENTITY_ONE_PROXY);
        Object proxyTwo = doc.get(ENTITY_TWO_PROXY);
        ArrayList<Object> proxies = new ArrayList<Object>();
        if (proxyOne != null && proxyTwo != null) {
            proxies.add(proxyOne);
            proxies.add(proxyTwo);
        }
        HashSet<String> remove = new HashSet<String>();
        remove.add(ENTITY_ONE_PROXY);
        remove.add(ENTITY_TWO_PROXY);
        return doc.minusAll(remove).plus(ENTITY_PROXIES, (Object)PersistentVector.create(proxies));
    }

    private IPersistentMap getAllInstancesQuery() {
        Symbol docVar = Symbol.intern((String)"d");
        PersistentArrayMap query = PersistentArrayMap.EMPTY;
        PersistentVector conditions = PersistentVector.create((Object[])new Object[]{docVar, Keyword.intern((String)InstanceAuditHeaderMapping.METADATA_COLLECTION_ID), Symbol.intern((String)"_")});
        query = query.assoc((Object)Keyword.intern((String)"find"), (Object)PersistentVector.create((Object[])new Object[]{docVar}));
        query = query.assoc((Object)Keyword.intern((String)"where"), (Object)PersistentVector.create((Object[])new Object[]{conditions}));
        return query;
    }

    private boolean isRelationship(XtdbDocument doc) {
        return doc != null && ((String)doc.getId()).startsWith("r_");
    }
}

