/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class InstancePropertiesMapping {
    private InstancePropertiesMapping() {
    }

    public static InstanceProperties getFromDoc(XtdbOMRSRepositoryConnector xtdbConnector, InstanceType type, XtdbDocument xtdbDoc) {
        List validProperties = type.getValidInstanceProperties();
        String namespace = TypeDefCache.getPropertyNamespaceForType(type.getTypeDefGUID());
        if (validProperties != null && !validProperties.isEmpty()) {
            TreeMap<String, InstancePropertyValue> values = new TreeMap<String, InstancePropertyValue>();
            for (String propertyName : validProperties) {
                InstancePropertyValue value = InstancePropertyValueMapping.getInstancePropertyValueFromDoc(xtdbConnector, xtdbDoc, namespace, propertyName);
                if (value == null) continue;
                values.put(propertyName, value);
            }
            InstanceProperties ip = new InstanceProperties();
            ip.setInstanceProperties(values);
            return ip;
        }
        return null;
    }

    public static InstanceProperties getFromMap(InstanceType type, IPersistentMap doc) throws IOException {
        List validProperties = type.getValidInstanceProperties();
        String namespace = TypeDefCache.getPropertyNamespaceForType(type.getTypeDefGUID());
        if (validProperties != null && !validProperties.isEmpty()) {
            TreeMap<String, InstancePropertyValue> values = new TreeMap<String, InstancePropertyValue>();
            for (String propertyName : validProperties) {
                InstancePropertyValue value = InstancePropertyValueMapping.getInstancePropertyValueFromMap(doc, namespace, propertyName);
                if (value == null) continue;
                values.put(propertyName, value);
            }
            InstanceProperties ip = new InstanceProperties();
            ip.setInstanceProperties(values);
            return ip;
        }
        return null;
    }

    public static void addToDoc(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument.Builder builder, InstanceType type, InstanceProperties properties) {
        HashMap propertyMap;
        if (properties != null) {
            propertyMap = properties.getInstanceProperties();
            if (propertyMap != null) {
                for (Map.Entry entry : propertyMap.entrySet()) {
                    InstancePropertyValueMapping.addInstancePropertyValueToDoc(xtdbConnector, type, builder, (String)entry.getKey(), (InstancePropertyValue)entry.getValue());
                }
            } else {
                propertyMap = new HashMap();
            }
        } else {
            propertyMap = new HashMap();
        }
        List allProperties = type.getValidInstanceProperties();
        if (allProperties != null) {
            for (String propertyName : allProperties) {
                if (propertyMap.containsKey(propertyName)) continue;
                InstancePropertyValueMapping.addInstancePropertyValueToDoc(xtdbConnector, type, builder, propertyName, null);
            }
        }
    }

    public static IPersistentMap addToMap(IPersistentMap doc, String typeDefGUID, InstanceProperties properties) throws InvalidParameterException, IOException {
        Map<String, PropertyKeywords> propertyKeywordMap = TypeDefCache.getAllPropertyKeywordsForTypeDef(typeDefGUID);
        if (properties != null) {
            PropertyKeywords propertyKeywords;
            HashMap propertyMap = properties.getInstanceProperties();
            if (propertyMap != null) {
                for (Map.Entry entry : propertyMap.entrySet()) {
                    propertyKeywords = propertyKeywordMap.get(entry.getKey());
                    doc = InstancePropertyValueMapping.addInstancePropertyValueToDoc(doc, propertyKeywords, (InstancePropertyValue)entry.getValue());
                }
            } else {
                propertyMap = new HashMap();
            }
            for (String propertyName : propertyKeywordMap.keySet()) {
                if (propertyMap.containsKey(propertyName)) continue;
                propertyKeywords = propertyKeywordMap.get(propertyName);
                doc = InstancePropertyValueMapping.addInstancePropertyValueToDoc(doc, propertyKeywords, null);
            }
        }
        return doc;
    }
}

