/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.AbstractMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ArrayPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EnumPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.MapPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.PrimitivePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.StructPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public abstract class InstancePropertyValueMapping
extends AbstractMapping {
    protected InstancePropertyValueMapping() {
        super(null);
    }

    public static Object getValueForComparison(XtdbOMRSRepositoryConnector xtdbConnector, InstancePropertyValue ipv) {
        Map<String, Object> value = null;
        if (ipv != null) {
            InstancePropertyCategory category = ipv.getInstancePropertyCategory();
            switch (category) {
                case PRIMITIVE: {
                    value = PrimitivePropertyValueMapping.getPrimitiveValueForComparison((PrimitivePropertyValue)ipv);
                    break;
                }
                case ENUM: {
                    value = EnumPropertyValueMapping.getEnumPropertyValueForComparison((EnumPropertyValue)ipv);
                    break;
                }
                case ARRAY: {
                    value = ArrayPropertyValueMapping.getArrayPropertyValueForComparison(xtdbConnector, (ArrayPropertyValue)ipv);
                    break;
                }
                case MAP: {
                    value = MapPropertyValueMapping.getMapPropertyValueForComparison(xtdbConnector, (MapPropertyValue)ipv);
                    break;
                }
                case STRUCT: {
                    value = StructPropertyValueMapping.getStructPropertyValueForComparison(xtdbConnector, (StructPropertyValue)ipv);
                    break;
                }
                default: {
                    xtdbConnector.logProblem(InstancePropertyValueMapping.class.getName(), "getValueForComparison", XtdbOMRSAuditCode.UNMAPPED_TYPE, null, "InstancePropertyCategory::" + category.name());
                }
            }
        }
        return value;
    }

    public static Object getValueForComparison(InstancePropertyValue ipv) throws InvalidParameterException {
        String methodName = "getValueForComparison";
        Map<String, Object> value = null;
        if (ipv != null) {
            InstancePropertyCategory category = ipv.getInstancePropertyCategory();
            switch (category) {
                case PRIMITIVE: {
                    value = PrimitivePropertyValueMapping.getPrimitiveValueForComparison((PrimitivePropertyValue)ipv);
                    break;
                }
                case ENUM: {
                    value = EnumPropertyValueMapping.getEnumPropertyValueForComparison((EnumPropertyValue)ipv);
                    break;
                }
                case ARRAY: {
                    value = ArrayPropertyValueMapping.getArrayPropertyValueForComparison((ArrayPropertyValue)ipv);
                    break;
                }
                case MAP: {
                    value = MapPropertyValueMapping.getMapPropertyValueForComparison((MapPropertyValue)ipv);
                    break;
                }
                case STRUCT: {
                    value = StructPropertyValueMapping.getStructPropertyValueForComparison((StructPropertyValue)ipv);
                    break;
                }
                default: {
                    throw new InvalidParameterException(XtdbOMRSErrorCode.UNMAPPABLE_PROPERTY.getMessageDefinition(ipv.getTypeName()), InstancePropertyValueMapping.class.getName(), "getValueForComparison", "getValueForComparison");
                }
            }
        }
        return value;
    }

    static InstancePropertyValue getInstancePropertyValueFromDoc(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument xtdbDoc, String namespace, String propertyName) {
        IPersistentMap embeddedValue;
        Object objValue = xtdbDoc.get(PropertyKeywords.getSerializedPropertyKeyword(namespace, propertyName));
        IPersistentMap iPersistentMap = embeddedValue = objValue instanceof IPersistentMap ? (IPersistentMap)objValue : null;
        if (embeddedValue != null) {
            return InstancePropertyValueMapping.getInstancePropertyValue(xtdbConnector, namespace, propertyName, embeddedValue);
        }
        return null;
    }

    static InstancePropertyValue getInstancePropertyValueFromMap(IPersistentMap doc, String namespace, String propertyName) throws IOException {
        IPersistentMap embeddedValue;
        Object objValue = doc.valAt((Object)Keyword.intern((String)PropertyKeywords.getSerializedPropertyKeyword(namespace, propertyName)));
        IPersistentMap iPersistentMap = embeddedValue = objValue instanceof IPersistentMap ? (IPersistentMap)objValue : null;
        if (embeddedValue != null) {
            return InstancePropertyValueMapping.getInstancePropertyValue(embeddedValue);
        }
        return null;
    }

    static void addInstancePropertyValueToDoc(XtdbOMRSRepositoryConnector xtdbConnector, InstanceType instanceType, XtdbDocument.Builder builder, String propertyName, InstancePropertyValue value) {
        String methodName = "addInstancePropertyValueToDoc";
        PropertyKeywords keywords = TypeDefCache.getPropertyKeywords(instanceType.getTypeDefGUID(), propertyName);
        if (keywords != null) {
            builder.put(keywords.getEmbeddedPath(), (Object)InstancePropertyValueMapping.getEmbeddedSerializedForm(xtdbConnector, instanceType.getTypeDefName(), propertyName, value));
            if (value != null) {
                InstancePropertyCategory category = value.getInstancePropertyCategory();
                switch (category) {
                    case PRIMITIVE: {
                        PrimitivePropertyValueMapping.addPrimitivePropertyValueToDoc(builder, keywords, (PrimitivePropertyValue)value);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValueMapping.addEnumPropertyValueToDoc(builder, keywords, (EnumPropertyValue)value);
                        break;
                    }
                    case ARRAY: {
                        ArrayPropertyValueMapping.addArrayPropertyValueToDoc(xtdbConnector, builder, keywords, (ArrayPropertyValue)value);
                        break;
                    }
                    case MAP: {
                        MapPropertyValueMapping.addMapPropertyValueToDoc(xtdbConnector, builder, keywords, (MapPropertyValue)value);
                        break;
                    }
                    case STRUCT: {
                        StructPropertyValueMapping.addStructPropertyValueToDoc(xtdbConnector, builder, keywords, (StructPropertyValue)value);
                        break;
                    }
                    default: {
                        xtdbConnector.logProblem(InstancePropertyValueMapping.class.getName(), "addInstancePropertyValueToDoc", XtdbOMRSAuditCode.UNMAPPED_TYPE, null, "InstancePropertyValueCategory::" + category.name());
                        break;
                    }
                }
            } else {
                builder.put(keywords.getSearchablePath(), null);
            }
        } else {
            xtdbConnector.logProblem(InstancePropertyValueMapping.class.getName(), "addInstancePropertyValueToDoc", XtdbOMRSAuditCode.UNMAPPED_PROPERTY, null, propertyName, instanceType.getTypeDefName());
        }
    }

    public static IPersistentMap addInstancePropertyValueToDoc(IPersistentMap doc, PropertyKeywords propertyKeywords, InstancePropertyValue value) throws InvalidParameterException, IOException {
        String methodName = "addInstancePropertyValueToDoc";
        doc = doc.assoc((Object)propertyKeywords.getEmbeddedKeyword(), (Object)InstancePropertyValueMapping.getEmbeddedSerializedForm(value));
        Keyword searchablePropertyKeyword = propertyKeywords.getSearchableKeyword();
        if (value != null) {
            InstancePropertyCategory category = value.getInstancePropertyCategory();
            switch (category) {
                case PRIMITIVE: {
                    doc = PrimitivePropertyValueMapping.addPrimitivePropertyValueToDoc(doc, searchablePropertyKeyword, (PrimitivePropertyValue)value);
                    break;
                }
                case ENUM: {
                    doc = EnumPropertyValueMapping.addEnumPropertyValueToDoc(doc, searchablePropertyKeyword, (EnumPropertyValue)value);
                    break;
                }
                case ARRAY: {
                    doc = ArrayPropertyValueMapping.addArrayPropertyValueToDoc(doc, searchablePropertyKeyword, (ArrayPropertyValue)value);
                    break;
                }
                case MAP: {
                    doc = MapPropertyValueMapping.addMapPropertyValueToDoc(doc, searchablePropertyKeyword, (MapPropertyValue)value);
                    break;
                }
                case STRUCT: {
                    doc = StructPropertyValueMapping.addStructPropertyValueToDoc(doc, searchablePropertyKeyword, (StructPropertyValue)value);
                    break;
                }
                default: {
                    throw new InvalidParameterException(XtdbOMRSErrorCode.UNMAPPABLE_PROPERTY.getMessageDefinition(value.getTypeName()), InstancePropertyValueMapping.class.getName(), "addInstancePropertyValueToDoc", propertyKeywords.getPropertyName());
                }
            }
        } else {
            doc = doc.assoc((Object)searchablePropertyKeyword, null);
        }
        return doc;
    }

    private static InstancePropertyValue getInstancePropertyValue(XtdbOMRSRepositoryConnector xtdbConnector, String namespace, String property, IPersistentMap jsonValue) {
        return (InstancePropertyValue)InstancePropertyValueMapping.getDeserializedValue(xtdbConnector, namespace, property, jsonValue, mapper.getTypeFactory().constructType(InstancePropertyValue.class));
    }

    private static InstancePropertyValue getInstancePropertyValue(IPersistentMap jsonValue) throws IOException {
        return (InstancePropertyValue)InstancePropertyValueMapping.getDeserializedValue(jsonValue, mapper.getTypeFactory().constructType(InstancePropertyValue.class));
    }

    private static Set<String> getNamesForProperty(XtdbOMRSRepositoryConnector xtdbConnector, String propertyName, String namespace, Set<String> limitToTypes, InstancePropertyValue value) {
        Set<String> validTypesForProperty = TypeDefCache.getAllTypeDefsForProperty(propertyName);
        TreeSet<String> qualifiedNames = new TreeSet<String>();
        if (validTypesForProperty != null) {
            for (String typeNameWithProperty : validTypesForProperty) {
                String searchableKeyword = PropertyKeywords.getSearchableValueKeyword(namespace, typeNameWithProperty, propertyName);
                if (qualifiedNames.contains(searchableKeyword)) continue;
                for (String limitToType : limitToTypes) {
                    if (!TypeDefCache.isTypeOf(limitToType, typeNameWithProperty) || !InstancePropertyValueMapping.propertyDefMatchesValueType(xtdbConnector, typeNameWithProperty, propertyName, value)) continue;
                    qualifiedNames.add(searchableKeyword);
                }
            }
        }
        return qualifiedNames;
    }

    public static Set<Keyword> getKeywordsForProperty(XtdbOMRSRepositoryConnector xtdbConnector, String propertyName, String namespace, Set<String> limitToTypes, InstancePropertyValue value) {
        TreeSet<Keyword> keywords = new TreeSet<Keyword>();
        Set<String> strings = InstancePropertyValueMapping.getNamesForProperty(xtdbConnector, propertyName, namespace, limitToTypes, value);
        for (String string : strings) {
            keywords.add(Keyword.intern((String)string));
        }
        return keywords;
    }

    private static boolean propertyDefMatchesValueType(XtdbOMRSRepositoryConnector xtdbConnector, String typeDefName, String propertyName, InstancePropertyValue value) {
        if (value == null) {
            return true;
        }
        TypeDef typeDef = TypeDefCache.getTypeDefByName(typeDefName);
        if (typeDef == null) {
            return false;
        }
        List typeDefProperties = typeDef.getPropertiesDefinition();
        block10: for (TypeDefAttribute typeDefProperty : typeDefProperties) {
            if (!typeDefProperty.getAttributeName().equals(propertyName)) continue;
            AttributeTypeDef atd = typeDefProperty.getAttributeType();
            switch (atd.getCategory()) {
                case PRIMITIVE: {
                    PrimitiveDef pd = (PrimitiveDef)atd;
                    PrimitiveDefCategory pdc = pd.getPrimitiveDefCategory();
                    return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ARRAY) || value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.PRIMITIVE) && ((PrimitivePropertyValue)value).getPrimitiveDefCategory().equals((Object)pdc);
                }
                case ENUM_DEF: {
                    return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ARRAY) || value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ENUM);
                }
                case COLLECTION: {
                    CollectionDef cd = (CollectionDef)atd;
                    switch (cd.getCollectionDefCategory()) {
                        case OM_COLLECTION_ARRAY: {
                            return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.ARRAY);
                        }
                        case OM_COLLECTION_MAP: {
                            return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.MAP);
                        }
                        case OM_COLLECTION_STRUCT: {
                            return value.getInstancePropertyCategory().equals((Object)InstancePropertyCategory.STRUCT);
                        }
                    }
                    xtdbConnector.logProblem(InstancePropertyValueMapping.class.getName(), "propertyDefMatchesValueType", XtdbOMRSAuditCode.UNMAPPED_TYPE, null, "CollectionDefCategory::" + cd.getCollectionDefCategory());
                    continue block10;
                }
            }
            xtdbConnector.logProblem(InstancePropertyValueMapping.class.getName(), "propertyDefMatchesValueType", XtdbOMRSAuditCode.UNMAPPED_TYPE, null, "AttributeTypeDefCategory::" + atd.getCategory());
        }
        return false;
    }
}

