/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import java.io.IOException;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetEntity;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public class RelationshipMapping
extends InstanceHeaderMapping {
    public static final String INSTANCE_REF_PREFIX = "r";
    public static final String RELATIONSHIP_PROPERTIES_NS = "relationshipProperties";
    private static final String N_ENTITY_PROXIES = "entityProxies";
    public static final String ENTITY_PROXIES = RelationshipMapping.getKeyword("entityProxies");
    private IXtdbDatasource db;

    public RelationshipMapping(XtdbOMRSRepositoryConnector xtdbConnector, Relationship relationship) {
        super(xtdbConnector, (InstanceHeader)relationship);
    }

    public RelationshipMapping(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument xtdbDoc, IXtdbDatasource db) {
        super(xtdbConnector, xtdbDoc);
        this.db = db;
    }

    public Relationship toEgeria() {
        if (this.instanceHeader == null && this.xtdbDoc != null) {
            this.instanceHeader = new Relationship();
            this.fromDoc();
        }
        if (this.instanceHeader != null) {
            return (Relationship)this.instanceHeader;
        }
        return null;
    }

    @Override
    protected XtdbDocument.Builder toDoc() {
        XtdbDocument.Builder builder = super.toDoc();
        Relationship relationship = (Relationship)this.instanceHeader;
        EntityProxy one = relationship.getEntityOneProxy();
        EntityProxy two = relationship.getEntityTwoProxy();
        builder.put(ENTITY_PROXIES, (Object)PersistentVector.create((Object[])new Object[]{EntityProxyMapping.getReference(one.getGUID()), EntityProxyMapping.getReference(two.getGUID())}));
        InstancePropertiesMapping.addToDoc(this.xtdbConnector, builder, relationship.getType(), relationship.getProperties());
        return builder;
    }

    public static IPersistentMap toMap(Relationship relationship) throws InvalidParameterException, IOException {
        EntityProxy one = relationship.getEntityOneProxy();
        EntityProxy two = relationship.getEntityTwoProxy();
        IPersistentMap doc = InstanceHeaderMapping.toMap((InstanceHeader)relationship);
        doc = doc.assoc((Object)Keyword.intern((String)ENTITY_PROXIES), (Object)PersistentVector.create((Object[])new Object[]{EntityProxyMapping.getReference(one.getGUID()), EntityProxyMapping.getReference(two.getGUID())}));
        return InstancePropertiesMapping.addToMap(doc, relationship.getType().getTypeDefGUID(), relationship.getProperties());
    }

    @Override
    protected void fromDoc() {
        IPersistentVector v;
        super.fromDoc();
        Object proxies = this.xtdbDoc.get(ENTITY_PROXIES);
        if (proxies instanceof IPersistentVector && (v = (IPersistentVector)proxies).length() == 2) {
            String oneRef = (String)v.nth(0);
            String twoRef = (String)v.nth(1);
            EntityProxy one = this.getEntityProxyFromRef(oneRef);
            EntityProxy two = this.getEntityProxyFromRef(twoRef);
            if (one != null && two != null) {
                ((Relationship)this.instanceHeader).setEntityOneProxy(one);
                ((Relationship)this.instanceHeader).setEntityTwoProxy(two);
            } else {
                this.xtdbConnector.logProblem(this.getClass().getName(), "fromDoc", XtdbOMRSAuditCode.FAILED_RETRIEVAL, null, "relationship", this.instanceHeader.getGUID(), "one or both of the entity proxies were not found -- 1:" + oneRef + ", 2:" + twoRef);
                this.instanceHeader = null;
                return;
            }
        }
        InstanceProperties ip = InstancePropertiesMapping.getFromDoc(this.xtdbConnector, this.instanceHeader.getType(), this.xtdbDoc);
        ((Relationship)this.instanceHeader).setProperties(ip);
    }

    private EntityProxy getEntityProxyFromRef(String ref) {
        return GetEntity.proxyByRef(this.xtdbConnector, this.db, ref);
    }

    public static String getReference(String guid) {
        return RelationshipMapping.getReference(INSTANCE_REF_PREFIX, guid);
    }
}

