/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.model.search;

import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.model.search.ConditionBuilder;
import org.odpi.egeria.connectors.juxt.xtdb.model.search.XtdbQuery;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextConditionBuilder {
    private static final Logger log = LoggerFactory.getLogger(TextConditionBuilder.class);
    public static final Symbol ELIDE = Symbol.intern((String)"_");
    public static final Symbol VALUE = Symbol.intern((String)"v");
    public static final Symbol ATTRIBUTE = Symbol.intern((String)"a");
    protected static final Symbol WILDCARD_TEXT_SEARCH_CI = Symbol.intern((String)"wildcard-text-search-ci");
    protected static final Symbol WILDCARD_TEXT_SEARCH_CS = Symbol.intern((String)"wildcard-text-search-cs");
    protected static final Symbol TEXT_SEARCH_CI = Symbol.intern((String)"text-search-ci");
    protected static final Symbol TEXT_SEARCH_CS = Symbol.intern((String)"text-search-cs");
    protected static final Symbol STARTS_WITH = Symbol.intern((String)"clojure.string/starts-with?");
    protected static final Symbol CONTAINS = Symbol.intern((String)"clojure.string/includes?");
    protected static final Symbol ENDS_WITH = Symbol.intern((String)"clojure.string/ends-with?");
    protected static final Symbol STR_OPERATOR = Symbol.intern((String)"str");
    private static final Pattern ESCAPE_SPACES = Pattern.compile("(\\s)");

    private TextConditionBuilder() {
    }

    public static List<IPersistentCollection> buildWildcardTextCondition(String regexCriteria, XtdbOMRSRepositoryConnector xtdbConnector, Set<String> typesToInclude, String namespace, boolean luceneEnabled, boolean luceneRegexes) {
        String methodName = "addWildcardTextCondition";
        log.info("Falling back to a non-Lucene wildcard text condition (likely to be slow!): {}", (Object)regexCriteria);
        OMRSRepositoryHelper repositoryHelper = xtdbConnector.getRepositoryHelper();
        String repositoryName = xtdbConnector.getRepositoryName();
        PrimitivePropertyValue string = new PrimitivePropertyValue();
        string.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        string.setPrimitiveValue((Object)regexCriteria);
        HashSet<Keyword> stringProperties = new HashSet<Keyword>();
        for (String typeDefName : typesToInclude) {
            TypeDef typeDef = repositoryHelper.getTypeDefByName(repositoryName, typeDefName);
            if (typeDef == null) continue;
            List properties = repositoryHelper.getAllPropertiesForTypeDef(repositoryName, typeDef, "addWildcardTextCondition");
            for (TypeDefAttribute property : properties) {
                Set<Keyword> propertyRefs = InstancePropertyValueMapping.getKeywordsForProperty(xtdbConnector, property.getAttributeName(), namespace, typesToInclude, (InstancePropertyValue)string);
                stringProperties.addAll(propertyRefs);
            }
        }
        ArrayList<IPersistentCollection> conditions = new ArrayList<IPersistentCollection>();
        ArrayList<Object> or = new ArrayList<Object>();
        if (stringProperties.size() > 1) {
            or.add(ConditionBuilder.OR_OPERATOR);
            for (Keyword propertyRef : stringProperties) {
                ArrayList<Object> and = new ArrayList<Object>();
                and.add(ConditionBuilder.AND_OPERATOR);
                Symbol variable = Symbol.intern((String)"v");
                List<IPersistentCollection> propertyConditions = ConditionBuilder.buildConditionForPropertyRef(propertyRef, PropertyComparisonOperator.LIKE, (InstancePropertyValue)string, variable, xtdbConnector, luceneEnabled, luceneRegexes);
                and.addAll(propertyConditions);
                or.add(PersistentList.create(and));
            }
            conditions.add((IPersistentCollection)PersistentList.create(or));
        } else {
            for (Keyword propertyRef : stringProperties) {
                Symbol variable = Symbol.intern((String)"v");
                List<IPersistentCollection> propertyConditions = ConditionBuilder.buildConditionForPropertyRef(propertyRef, PropertyComparisonOperator.LIKE, (InstancePropertyValue)string, variable, xtdbConnector, luceneEnabled, luceneRegexes);
                conditions.addAll(propertyConditions);
            }
        }
        return conditions;
    }

    public static List<IPersistentCollection> buildWildcardLuceneCondition(String regexCriteria, XtdbOMRSRepositoryConnector xtdbConnector, Set<String> typesToInclude, String namespace, boolean luceneRegexes) {
        OMRSRepositoryHelper repositoryHelper = xtdbConnector.getRepositoryHelper();
        List<Object> conditions = null;
        if (regexCriteria != null && regexCriteria.length() > 0) {
            String searchString = TextConditionBuilder.getLuceneComparisonString(regexCriteria, repositoryHelper, luceneRegexes);
            if (searchString == null) {
                conditions = TextConditionBuilder.buildWildcardTextCondition(regexCriteria, xtdbConnector, typesToInclude, namespace, true, luceneRegexes);
            } else {
                conditions = new ArrayList<IPersistentVector>();
                conditions.add(TextConditionBuilder.getLuceneWildcardClause(searchString, repositoryHelper.isCaseInsensitiveRegex(regexCriteria)));
            }
        }
        return conditions;
    }

    static List<IPersistentCollection> buildLuceneOptimizedConditions(String simpleName, PropertyComparisonOperator comparator, InstancePropertyValue value, XtdbOMRSRepositoryConnector xtdbConnector, boolean luceneRegexes) {
        ArrayList<IPersistentCollection> allConditionsForProperty = new ArrayList<IPersistentCollection>();
        String methodName = "buildLuceneOptimizedConditions";
        OMRSRepositoryHelper repositoryHelper = xtdbConnector.getRepositoryHelper();
        String regexSearchString = value.valueAsString();
        String searchString = null;
        switch (comparator) {
            case EQ: 
            case NEQ: {
                searchString = TextConditionBuilder.escapeLucenePhrase(regexSearchString);
                break;
            }
            case LIKE: {
                searchString = TextConditionBuilder.getLuceneComparisonString(regexSearchString, repositoryHelper, luceneRegexes);
                break;
            }
            default: {
                xtdbConnector.logProblem(TextConditionBuilder.class.getName(), "buildLuceneOptimizedConditions", XtdbOMRSAuditCode.INVALID_STRING_COMPARISON, null, simpleName, comparator.name());
            }
        }
        if (searchString != null) {
            ArrayList<Object> intermediateConditions = new ArrayList<Object>();
            Symbol attribute = Symbol.intern((String)simpleName);
            IPersistentVector luceneClause = TextConditionBuilder.getLuceneWildcardClause(searchString, repositoryHelper.isCaseInsensitiveRegex(regexSearchString), attribute);
            intermediateConditions.add(luceneClause);
            Symbol nonNullStringVar = Symbol.intern((String)("sv_" + simpleName));
            ArrayList<Symbol> forceString = new ArrayList<Symbol>();
            forceString.add(STR_OPERATOR);
            forceString.add(attribute);
            PersistentVector enforceNonNullStringValue = PersistentVector.create((Object[])new Object[]{PersistentList.create(forceString), nonNullStringVar});
            intermediateConditions.add(enforceNonNullStringValue);
            ArrayList<Object> predicateComparison = new ArrayList<Object>();
            predicateComparison.add(ENDS_WITH);
            predicateComparison.add(nonNullStringVar);
            predicateComparison.add(PropertyKeywords.getEndsWithPropertyNameForMatching(simpleName));
            intermediateConditions.add(PersistentVector.create((Object[])new Object[]{PersistentList.create(predicateComparison)}));
            if (comparator.equals((Object)PropertyComparisonOperator.NEQ)) {
                ArrayList<Object> not = new ArrayList<Object>();
                not.add(ConditionBuilder.NOT_OPERATOR);
                not.addAll(intermediateConditions);
                intermediateConditions = new ArrayList();
                intermediateConditions.add(PersistentList.create(not));
            }
            allConditionsForProperty.addAll(intermediateConditions);
        }
        return allConditionsForProperty;
    }

    static List<IPersistentCollection> buildRegexConditions(Keyword propertyRef, InstancePropertyValue value, Symbol variable, XtdbOMRSRepositoryConnector xtdbConnector, boolean luceneEnabled, boolean luceneRegexes) {
        String methodName = "buildRegexConditions";
        ArrayList<IPersistentCollection> propertyConditions = new ArrayList<IPersistentCollection>();
        ArrayList<PersistentVector> clauseConditions = new ArrayList<PersistentVector>();
        Object compareTo = InstancePropertyValueMapping.getValueForComparison(xtdbConnector, value);
        OMRSRepositoryHelper repositoryHelper = xtdbConnector.getRepositoryHelper();
        if (compareTo instanceof String) {
            String searchString;
            String regexSearchString = (String)compareTo;
            if (repositoryHelper.isExactMatchRegex(regexSearchString, false)) {
                String unqualifiedLiteralString = repositoryHelper.getUnqualifiedLiteralString(regexSearchString);
                propertyConditions.add(TextConditionBuilder.getEqualsConditions(propertyRef, unqualifiedLiteralString));
                return propertyConditions;
            }
            if (luceneEnabled && (searchString = TextConditionBuilder.getLuceneComparisonString(regexSearchString, repositoryHelper, luceneRegexes)) != null) {
                propertyConditions.add((IPersistentCollection)TextConditionBuilder.getLuceneTermClause(propertyRef, searchString, repositoryHelper.isCaseInsensitiveRegex(regexSearchString)));
                return propertyConditions;
            }
            PersistentVector propertyToVariable = PersistentVector.create((Object[])new Object[]{XtdbQuery.DOC_ID, propertyRef, variable});
            Symbol nonNullStringVar = Symbol.intern((String)"sv");
            ArrayList<Symbol> forceString = new ArrayList<Symbol>();
            forceString.add(STR_OPERATOR);
            forceString.add(variable);
            PersistentVector enforceNonNullStringValue = PersistentVector.create((Object[])new Object[]{PersistentList.create(forceString), nonNullStringVar});
            clauseConditions.add(enforceNonNullStringValue);
            List<Object> predicateComparison = TextConditionBuilder.getRegexCondition(regexSearchString, nonNullStringVar, repositoryHelper);
            clauseConditions.add(PersistentVector.create((Object[])new Object[]{PersistentList.create(predicateComparison)}));
            propertyConditions.add((IPersistentCollection)propertyToVariable);
            propertyConditions.addAll(clauseConditions);
        } else {
            xtdbConnector.logProblem(TextConditionBuilder.class.getName(), "buildRegexConditions", XtdbOMRSAuditCode.NO_REGEX, null, value == null ? "<null>" : value.toString());
        }
        return propertyConditions;
    }

    private static List<Object> getRegexCondition(String regexSearchString, Symbol variable, OMRSRepositoryHelper repositoryHelper) {
        ArrayList<Object> predicateComparison = new ArrayList<Object>();
        if (repositoryHelper.isStartsWithRegex(regexSearchString, false)) {
            predicateComparison.add(STARTS_WITH);
            predicateComparison.add(variable);
            predicateComparison.add(repositoryHelper.getUnqualifiedLiteralString(regexSearchString));
        } else if (repositoryHelper.isContainsRegex(regexSearchString, false)) {
            predicateComparison.add(CONTAINS);
            predicateComparison.add(variable);
            predicateComparison.add(repositoryHelper.getUnqualifiedLiteralString(regexSearchString));
        } else if (repositoryHelper.isEndsWithRegex(regexSearchString, false)) {
            predicateComparison.add(ENDS_WITH);
            predicateComparison.add(variable);
            predicateComparison.add(repositoryHelper.getUnqualifiedLiteralString(regexSearchString));
        } else {
            Pattern regex = Pattern.compile(regexSearchString);
            predicateComparison.add(ConditionBuilder.REGEX_OPERATOR);
            predicateComparison.add(regex);
            predicateComparison.add(variable);
        }
        return predicateComparison;
    }

    private static String getLuceneComparisonString(String regexCriteria, OMRSRepositoryHelper repositoryHelper, boolean luceneRegexes) {
        if (repositoryHelper.isExactMatchRegex((String)regexCriteria) || repositoryHelper.isStartsWithRegex((String)regexCriteria) || repositoryHelper.isContainsRegex((String)regexCriteria) || repositoryHelper.isEndsWithRegex((String)regexCriteria)) {
            Object searchString = TextConditionBuilder.escapeLucenePhrase(repositoryHelper.getUnqualifiedLiteralString((String)regexCriteria));
            if (repositoryHelper.isStartsWithRegex((String)regexCriteria)) {
                searchString = (String)searchString + "*";
            } else if (repositoryHelper.isEndsWithRegex((String)regexCriteria)) {
                searchString = "*" + (String)searchString;
            } else if (repositoryHelper.isContainsRegex((String)regexCriteria)) {
                searchString = "*" + (String)searchString + "*";
            }
            return searchString;
        }
        if (luceneRegexes) {
            if (!((String)regexCriteria).startsWith("/") || !((String)regexCriteria).endsWith("/")) {
                regexCriteria = "/" + (String)regexCriteria + "/";
            }
            return regexCriteria;
        }
        return null;
    }

    private static IPersistentVector getLuceneTermClause(Keyword propertyRef, String searchString, boolean isCaseInsensitive) {
        ArrayList<Object> luceneCriteria = new ArrayList<Object>();
        if (isCaseInsensitive) {
            luceneCriteria.add(TEXT_SEARCH_CI);
        } else {
            luceneCriteria.add(TEXT_SEARCH_CS);
        }
        luceneCriteria.add(propertyRef);
        luceneCriteria.add(searchString);
        PersistentVector deStructured = PersistentVector.create((Object[])new Object[]{PersistentVector.create((Object[])new Object[]{XtdbQuery.DOC_ID, ELIDE})});
        ArrayList<Object> luceneQuery = new ArrayList<Object>();
        luceneQuery.add(PersistentList.create(luceneCriteria));
        luceneQuery.add(deStructured);
        return PersistentVector.create(luceneQuery);
    }

    private static IPersistentVector getLuceneWildcardClause(String searchString, boolean isCaseInsensitive) {
        return TextConditionBuilder.getLuceneWildcardClause(searchString, isCaseInsensitive, ATTRIBUTE);
    }

    private static IPersistentVector getLuceneWildcardClause(String searchString, boolean isCaseInsensitive, Symbol attribute) {
        ArrayList<Object> luceneCriteria = new ArrayList<Object>();
        if (isCaseInsensitive) {
            luceneCriteria.add(WILDCARD_TEXT_SEARCH_CI);
        } else {
            luceneCriteria.add(WILDCARD_TEXT_SEARCH_CS);
        }
        luceneCriteria.add(searchString);
        PersistentVector deStructured = PersistentVector.create((Object[])new Object[]{PersistentVector.create((Object[])new Object[]{XtdbQuery.DOC_ID, VALUE, attribute, ELIDE})});
        ArrayList<Object> luceneQuery = new ArrayList<Object>();
        luceneQuery.add(PersistentList.create(luceneCriteria));
        luceneQuery.add(deStructured);
        return PersistentVector.create(luceneQuery);
    }

    private static String escapeLucenePhrase(String phrase) {
        if (phrase != null) {
            String escaped = QueryParserBase.escape((String)phrase);
            return ESCAPE_SPACES.matcher(escaped).replaceAll("\\\\$1");
        }
        return null;
    }

    private static IPersistentCollection getEqualsConditions(Keyword propertyRef, String value) {
        return PersistentVector.create((Object[])new Object[]{XtdbQuery.DOC_ID, propertyRef, value});
    }
}

