/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.model.search;

import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EnumPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.xtdb.model.search.ConditionBuilder;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;

public class XtdbQuery {
    public static final Symbol DOC_ID = Symbol.intern((String)"e");
    public static final Symbol CREATE_TIME = Symbol.intern((String)"ct");
    public static final Symbol UPDATE_TIME = Symbol.intern((String)"ut");
    public static final Symbol SORT_PROPERTY = Symbol.intern((String)"sp");
    public static final Keyword SORT_ASCENDING = Keyword.intern((String)"asc");
    public static final Keyword SORT_DESCENDING = Keyword.intern((String)"desc");
    private IPersistentMap query = PersistentArrayMap.EMPTY;
    private final List<Symbol> findElements = new ArrayList<Symbol>();
    protected final List<IPersistentCollection> conditions;
    protected final List<IPersistentCollection> rules;
    private final List<IPersistentVector> sequencing;

    public XtdbQuery() {
        this.findElements.add(DOC_ID);
        this.conditions = new ArrayList<IPersistentCollection>();
        this.rules = new ArrayList<IPersistentCollection>();
        this.sequencing = new ArrayList<IPersistentVector>();
    }

    public void addRelationshipEndpointConditions(String reference) {
        this.conditions.add((IPersistentCollection)this.getReferenceCondition(Keyword.intern((String)RelationshipMapping.ENTITY_PROXIES), reference));
    }

    protected PersistentVector getReferenceCondition(Keyword property, String reference) {
        return PersistentVector.create((Object[])new Object[]{DOC_ID, property, reference});
    }

    public void addTypeCondition(TypeDefCategory category, String typeGuid, List<String> subtypeLimits) {
        this.conditions.addAll(this.getTypeCondition(DOC_ID, category, typeGuid, subtypeLimits));
        if (category.equals((Object)TypeDefCategory.ENTITY_DEF)) {
            this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, Keyword.intern((String)EntityProxyMapping.ENTITY_PROXY_ONLY_MARKER), false}));
        }
    }

    protected List<IPersistentCollection> getTypeCondition(Symbol variable, TypeDefCategory category, String typeGuid, List<String> subtypeLimits) {
        ArrayList<IPersistentCollection> typeConditions = new ArrayList<IPersistentCollection>();
        if (subtypeLimits != null && !subtypeLimits.isEmpty()) {
            if (subtypeLimits.size() == 1) {
                typeConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{variable, Keyword.intern((String)InstanceAuditHeaderMapping.TYPE_DEF_GUIDS), subtypeLimits.get(0)}));
            } else {
                Symbol setVar = Symbol.intern((String)"tf");
                Symbol typeVar = Symbol.intern((String)"types");
                typeConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{variable, Keyword.intern((String)InstanceAuditHeaderMapping.TYPE_DEF_GUIDS), typeVar}));
                ArrayList<Object> set = new ArrayList<Object>();
                set.add(ConditionBuilder.SET_OPERATOR);
                set.addAll(subtypeLimits);
                typeConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(set), setVar}));
                ArrayList<Symbol> contains = new ArrayList<Symbol>();
                contains.add(Symbol.intern((String)"contains?"));
                contains.add(setVar);
                contains.add(typeVar);
                typeConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(contains)}));
            }
        } else if (typeGuid != null) {
            typeConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{variable, Keyword.intern((String)InstanceAuditHeaderMapping.TYPE_DEF_GUIDS), typeGuid}));
        } else {
            typeConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{variable, Keyword.intern((String)InstanceAuditHeaderMapping.TYPE_DEF_CATEGORY), category.getOrdinal()}));
        }
        return typeConditions;
    }

    public void addConditions(List<IPersistentCollection> xtdbConditions) {
        if (xtdbConditions != null) {
            this.conditions.addAll(xtdbConditions);
        }
    }

    public void addPropertyConditions(SearchProperties searchProperties, String namespace, Set<String> typeNames, XtdbOMRSRepositoryConnector xtdbConnector, boolean luceneEnabled, boolean luceneRegexes) {
        List<IPersistentCollection> xtdbConditions = ConditionBuilder.buildPropertyConditions(searchProperties, namespace, false, typeNames, xtdbConnector, luceneEnabled, luceneRegexes);
        this.addConditions(xtdbConditions);
    }

    public void addClassificationConditions(SearchClassifications searchClassifications, Set<String> typeNames, XtdbOMRSRepositoryConnector xtdbConnector, boolean luceneEnabled, boolean luceneRegexes) {
        List<IPersistentCollection> xtdbConditions = this.getClassificationConditions(searchClassifications, typeNames, xtdbConnector, luceneEnabled, luceneRegexes);
        this.addConditions(xtdbConditions);
    }

    protected List<IPersistentCollection> getClassificationConditions(SearchClassifications searchClassifications, Set<String> typeNames, XtdbOMRSRepositoryConnector xtdbConnector, boolean luceneEnabled, boolean luceneRegexes) {
        if (searchClassifications != null) {
            String namespace = "classifications";
            List classificationConditions = searchClassifications.getConditions();
            MatchCriteria matchCriteria = searchClassifications.getMatchCriteria();
            if (classificationConditions != null && !classificationConditions.isEmpty()) {
                ArrayList<IPersistentCollection> allConditions = new ArrayList<IPersistentCollection>();
                for (ClassificationCondition condition : classificationConditions) {
                    String classificationName = condition.getName();
                    allConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, Keyword.intern((String)namespace), classificationName}));
                    String qualifiedNamespace = ClassificationMapping.getNamespaceForClassification(namespace, classificationName);
                    List<IPersistentCollection> matchConditions = ConditionBuilder.buildPropertyConditions(condition.getMatchProperties(), qualifiedNamespace, matchCriteria.equals((Object)MatchCriteria.ANY), typeNames, xtdbConnector, luceneEnabled, luceneRegexes);
                    if (matchConditions == null) continue;
                    allConditions.addAll(matchConditions);
                }
                return allConditions;
            }
        }
        return null;
    }

    public void addStatusLimiters(List<InstanceStatus> limitResultsByStatus, Symbol toLimit) {
        if (limitResultsByStatus != null && !limitResultsByStatus.isEmpty()) {
            List<IPersistentCollection> statusConditions = this.getStatusLimiters(toLimit, limitResultsByStatus);
            if (statusConditions != null && !statusConditions.isEmpty()) {
                this.conditions.addAll(statusConditions);
            }
        } else {
            Integer deleted = EnumPropertyValueMapping.getOrdinalForInstanceStatus(InstanceStatus.DELETED);
            Symbol variable = Symbol.intern((String)(toLimit.toString() + "_" + InstanceAuditHeaderMapping.CURRENT_STATUS));
            Keyword propertyRef = Keyword.intern((String)InstanceAuditHeaderMapping.CURRENT_STATUS);
            this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{toLimit, propertyRef, variable}));
            ArrayList<Object> predicateComparison = new ArrayList<Object>();
            predicateComparison.add(ConditionBuilder.NEQ_OPERATOR);
            predicateComparison.add(variable);
            predicateComparison.add(deleted);
            this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(predicateComparison)}));
        }
    }

    protected List<IPersistentCollection> getStatusLimiters(Symbol variable, List<InstanceStatus> limitResultsByStatus) {
        ArrayList<IPersistentCollection> statusConditions = new ArrayList<IPersistentCollection>();
        ArrayList<Integer> ordinals = new ArrayList<Integer>();
        for (InstanceStatus limitByStatus : limitResultsByStatus) {
            Integer ordinal = EnumPropertyValueMapping.getOrdinalForInstanceStatus(limitByStatus);
            if (ordinal == null) continue;
            ordinals.add(ordinal);
        }
        if (!ordinals.isEmpty()) {
            if (ordinals.size() == 1) {
                statusConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{variable, Keyword.intern((String)InstanceAuditHeaderMapping.CURRENT_STATUS), ordinals.get(0)}));
            } else {
                Symbol setVar = Symbol.intern((String)"sf");
                Symbol statusVar = Symbol.intern((String)"status");
                statusConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{variable, Keyword.intern((String)InstanceAuditHeaderMapping.CURRENT_STATUS), statusVar}));
                ArrayList<Object> set = new ArrayList<Object>();
                set.add(ConditionBuilder.SET_OPERATOR);
                set.addAll(ordinals);
                statusConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(set), setVar}));
                ArrayList<Symbol> contains = new ArrayList<Symbol>();
                contains.add(Symbol.intern((String)"contains?"));
                contains.add(setVar);
                contains.add(statusVar);
                statusConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(contains)}));
            }
        }
        return statusConditions;
    }

    public void addSequencing(SequencingOrder sequencingOrder, String sequencingProperty, String namespace, Set<String> typeNames, XtdbOMRSRepositoryConnector xtdbConnector) {
        String methodName = "addSequencing";
        Set<Keyword> qualifiedSortProperties = null;
        if (sequencingProperty != null) {
            qualifiedSortProperties = InstancePropertyValueMapping.getKeywordsForProperty(xtdbConnector, sequencingProperty, namespace, typeNames, null);
        }
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.GUID;
        }
        switch (sequencingOrder) {
            case LAST_UPDATE_OLDEST: {
                this.addFindElement(UPDATE_TIME);
                this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, Keyword.intern((String)InstanceAuditHeaderMapping.UPDATE_TIME), UPDATE_TIME}));
                this.sequencing.add((IPersistentVector)PersistentVector.create((Object[])new Object[]{UPDATE_TIME, SORT_ASCENDING}));
                break;
            }
            case LAST_UPDATE_RECENT: {
                this.addFindElement(UPDATE_TIME);
                this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, Keyword.intern((String)InstanceAuditHeaderMapping.UPDATE_TIME), UPDATE_TIME}));
                this.sequencing.add((IPersistentVector)PersistentVector.create((Object[])new Object[]{UPDATE_TIME, SORT_DESCENDING}));
                break;
            }
            case CREATION_DATE_OLDEST: {
                this.addFindElement(CREATE_TIME);
                this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, Keyword.intern((String)InstanceAuditHeaderMapping.CREATE_TIME), CREATE_TIME}));
                this.sequencing.add((IPersistentVector)PersistentVector.create((Object[])new Object[]{CREATE_TIME, SORT_ASCENDING}));
                break;
            }
            case CREATION_DATE_RECENT: {
                this.addFindElement(CREATE_TIME);
                this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, Keyword.intern((String)InstanceAuditHeaderMapping.CREATE_TIME), CREATE_TIME}));
                this.sequencing.add((IPersistentVector)PersistentVector.create((Object[])new Object[]{CREATE_TIME, SORT_DESCENDING}));
                break;
            }
            case PROPERTY_ASCENDING: {
                if (qualifiedSortProperties == null || qualifiedSortProperties.isEmpty()) {
                    xtdbConnector.logProblem(this.getClass().getName(), "addSequencing", XtdbOMRSAuditCode.NO_SORT_PROPERTY, null, sequencingProperty, typeNames == null ? "<null>" : typeNames.toString());
                    break;
                }
                this.addPropertyBasedSorting(qualifiedSortProperties, SORT_ASCENDING);
                break;
            }
            case PROPERTY_DESCENDING: {
                if (qualifiedSortProperties == null || qualifiedSortProperties.isEmpty()) {
                    xtdbConnector.logProblem(this.getClass().getName(), "addSequencing", XtdbOMRSAuditCode.NO_SORT_PROPERTY, null, sequencingProperty, typeNames == null ? "<null>" : typeNames.toString());
                    break;
                }
                this.addPropertyBasedSorting(qualifiedSortProperties, SORT_DESCENDING);
                break;
            }
            default: {
                this.sequencing.add((IPersistentVector)PersistentVector.create((Object[])new Object[]{DOC_ID, SORT_ASCENDING}));
            }
        }
    }

    protected void addPropertyBasedSorting(Set<Keyword> qualifiedSortProperties, Keyword order) {
        this.addFindElement(SORT_PROPERTY);
        if (qualifiedSortProperties.size() == 1) {
            for (Keyword propertyRef : qualifiedSortProperties) {
                this.conditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, propertyRef, SORT_PROPERTY}));
            }
        } else {
            ArrayList<Object> orJoinConditions = new ArrayList<Object>();
            orJoinConditions.add(ConditionBuilder.OR_JOIN);
            orJoinConditions.add(PersistentVector.create((Object[])new Object[]{SORT_PROPERTY}));
            for (Keyword propertyRef : qualifiedSortProperties) {
                orJoinConditions.add(PersistentVector.create((Object[])new Object[]{DOC_ID, propertyRef, SORT_PROPERTY}));
            }
            this.conditions.add((IPersistentCollection)PersistentList.create(orJoinConditions));
        }
        this.sequencing.add((IPersistentVector)PersistentVector.create((Object[])new Object[]{SORT_PROPERTY, order}));
    }

    public IPersistentMap getQuery() {
        this.query = this.query.assoc((Object)Keyword.intern((String)"find"), (Object)PersistentVector.create(this.findElements));
        this.query = this.query.assoc((Object)Keyword.intern((String)"where"), (Object)PersistentVector.create(this.conditions));
        if (this.rules != null && !this.rules.isEmpty()) {
            this.query = this.query.assoc((Object)Keyword.intern((String)"rules"), (Object)PersistentVector.create(this.rules));
        }
        if (this.sequencing != null && !this.sequencing.isEmpty()) {
            this.query = this.query.assoc((Object)Keyword.intern((String)"order-by"), (Object)PersistentVector.create(this.sequencing));
        }
        return this.query;
    }

    protected void addFindElement(Symbol element) {
        if (!this.findElements.contains(element)) {
            this.findElements.add(element);
        }
    }
}

