/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.readops;

import clojure.lang.IPersistentMap;
import java.util.Collection;
import java.util.List;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.xtdb.model.search.XtdbQuery;
import org.odpi.egeria.connectors.juxt.xtdb.readops.AbstractRelationshipSearchOperation;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdbDatasource;

public class GetRelationshipsForEntity
extends AbstractRelationshipSearchOperation {
    private static final Logger log = LoggerFactory.getLogger(GetRelationshipsForEntity.class);
    private final String entityGUID;

    public GetRelationshipsForEntity(XtdbOMRSRepositoryConnector xtdb, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, IXtdbDatasource existingDB, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) {
        super(xtdb, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, existingDB, sequencingProperty, sequencingOrder, pageSize, userId);
        this.entityGUID = entityGUID;
    }

    @Override
    protected Collection<List<?>> runQuery(IXtdbDatasource db) throws TypeErrorException {
        XtdbQuery query = new XtdbQuery();
        query.addRelationshipEndpointConditions(EntitySummaryMapping.getReference(this.entityGUID));
        this.updateQuery(query, TypeDefCategory.RELATIONSHIP_DEF, this.typeGUID, null, null, this.limitResultsByStatus, null, this.sequencingProperty, this.sequencingOrder, null, this.userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        Collection results = db.query((Object)q, new Object[0]);
        return this.deduplicateAndPage(results, this.fromElement, this.pageSize);
    }
}

