/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import java.util.Date;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class ClassifyEntity
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(ClassifyEntity.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"classifyEntity");
    private static final String CLASS_NAME = ClassifyEntity.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user cname ext-guid ext-name corigin corigin-guid properties mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + ClassifyEntity.class.getCanonicalName() + ". tx-id existing user eid mid cname ext-guid ext-name corigin corigin-guid properties))" + ClassifyEntity.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public ClassifyEntity(Long txId, PersistentHashMap existing, String userId, String entityGUID, String metadataCollectionId, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws Exception {
        try {
            Classification newClassification;
            if (existing == null) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.nonProxyEntity((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.entityFromStore(entityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceType((IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            InstanceType entityType = InstanceAuditHeaderMapping.getTypeFromInstance((IPersistentMap)existing, null);
            TxnValidations.classification(classificationName, entityType.getTypeDefName(), CLASS_NAME, METHOD_NAME);
            String entityTypeDefGUID = ClassifyEntity.getTypeDefGUID((IPersistentMap)existing);
            TypeDef entityTypeDef = TypeDefCache.getTypeDef(entityTypeDefGUID);
            String entityTypeDefName = entityTypeDef.getName();
            try {
                TxnValidations.classificationProperties(classificationName, properties, CLASS_NAME, METHOD_NAME);
                if (externalSourceGUID == null) {
                    newClassification = ClassifyEntity.getNewClassification(metadataCollectionId, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityTypeDefName, classificationOrigin == null ? ClassificationOrigin.ASSIGNED : classificationOrigin, classificationOriginGUID, properties);
                } else {
                    newClassification = ClassifyEntity.getNewClassification(externalSourceGUID, externalSourceName, InstanceProvenanceType.EXTERNAL_SOURCE, userId, classificationName, entityTypeDefName, classificationOrigin == null ? ClassificationOrigin.ASSIGNED : classificationOrigin, classificationOriginGUID, properties);
                    newClassification.setMetadataCollectionName(externalSourceName);
                    newClassification.setReplicatedBy(metadataCollectionId);
                }
            }
            catch (TypeErrorException e) {
                throw new ClassificationErrorException(XtdbOMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(classificationName, entityTypeDefName), CLASS_NAME, METHOD_NAME, (Throwable)e);
            }
            this.xtdbDoc = ClassificationMapping.addToMap((IPersistentMap)existing, newClassification);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XtdbOMRSRepositoryConnector xtdb, String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws EntityNotKnownException, InvalidParameterException, ClassificationErrorException, PropertyErrorException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, classificationName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, properties, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingEntity(docId, results, METHOD_NAME);
        }
        catch (ClassificationErrorException | EntityNotKnownException | InvalidParameterException | PropertyErrorException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), ClassifyEntity.class.getName(), METHOD_NAME, (Throwable)e);
        }
    }

    private static Classification getNewClassification(String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String classificationTypeName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws TypeErrorException {
        String methodName = "getNewClassification";
        if (TypeDefCache.isValidClassificationForEntity(classificationTypeName, entityTypeName)) {
            Classification classification = new Classification();
            classification.setHeaderVersion(1L);
            classification.setInstanceProvenanceType(provenanceType);
            classification.setMetadataCollectionId(metadataCollectionId);
            classification.setMetadataCollectionName(metadataCollectionName);
            classification.setName(classificationTypeName);
            classification.setCreateTime(new Date());
            classification.setCreatedBy(userName);
            classification.setVersion(1L);
            classification.setType(TypeDefCache.getInstanceType(TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName));
            classification.setStatus(TypeDefCache.getInitialStatus(classificationTypeName));
            classification.setClassificationOrigin(classificationOrigin);
            classification.setClassificationOriginGUID(classificationOriginGUID);
            classification.setProperties(properties);
            return classification;
        }
        throw new TypeErrorException(XtdbOMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(classificationTypeName, entityTypeName), ClassifyEntity.class.getName(), "getNewClassification");
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        ClassifyEntity.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

