/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class DeclassifyEntity
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(DeclassifyEntity.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"declassifyEntity");
    private static final String CLASS_NAME = DeclassifyEntity.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid cname]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + DeclassifyEntity.class.getCanonicalName() + ". tx-id existing eid cname))" + DeclassifyEntity.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public DeclassifyEntity(Long txId, PersistentHashMap existing, String entityGUID, String classificationName) throws Exception {
        try {
            if (existing == null) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.nonProxyEntity((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.requiredProperty(entityGUID, "classificationName", classificationName, CLASS_NAME, METHOD_NAME);
            TxnValidations.entityFromStore(entityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = ClassificationMapping.removeFromMap((IPersistentMap)existing, classificationName);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XtdbOMRSRepositoryConnector xtdb, String entityGUID, String classificationName) throws EntityNotKnownException, InvalidParameterException, ClassificationErrorException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, classificationName});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingEntity(docId, results, METHOD_NAME);
        }
        catch (ClassificationErrorException | EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), DeclassifyEntity.class.getName(), METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        DeclassifyEntity.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

