/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Tuple;
import java.io.IOException;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.Constants;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EnumPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.Keywords;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public abstract class ReIdentifyInstance
extends AbstractTransactionFunction {
    protected static IPersistentVector reIdentifyInstance(String userId, IPersistentMap existing, String instanceGUID, String newInstanceGUID) {
        IPersistentMap deleted = ReIdentifyInstance.incrementVersion(userId, existing);
        deleted = deleted.assoc((Object)Keywords.STATUS_ON_DELETE, deleted.valAt((Object)Keywords.CURRENT_STATUS)).assoc((Object)Keywords.CURRENT_STATUS, (Object)EnumPropertyValueMapping.getOrdinalForInstanceStatus(InstanceStatus.DELETED));
        IPersistentMap updated = ReIdentifyInstance.incrementVersion(userId, existing);
        updated = updated.assoc((Object)Constants.XTDB_PK, (Object)newInstanceGUID).assoc((Object)Keywords.RE_IDENTIFIED_FROM_GUID, (Object)instanceGUID);
        return Tuple.create((Object)deleted, (Object)updated);
    }

    protected static void validate(IPersistentMap existing, String instanceGUID, String metadataCollectionId, String className, String methodName) throws InvalidParameterException, RepositoryErrorException, IOException {
        TxnValidations.instanceCanBeUpdated(existing, instanceGUID, metadataCollectionId, className, methodName);
    }
}

