/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.Keywords;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;

public abstract class UpdateInstanceStatus
extends AbstractTransactionFunction {
    protected static IPersistentMap updateInstanceStatus(String userId, IPersistentMap existing, int instanceStatus) {
        IPersistentMap doc = UpdateInstanceStatus.incrementVersion(userId, existing);
        return doc.assoc((Object)Keywords.CURRENT_STATUS, (Object)instanceStatus);
    }

    protected static void validate(IPersistentMap existing, String instanceGUID, String metadataCollectionId, Integer instanceStatus, String className, String methodName) throws InvalidParameterException, RepositoryErrorException, IOException, StatusNotSupportedException {
        TxnValidations.instanceIsNotDeleted(existing, instanceGUID, className, methodName);
        TxnValidations.instanceCanBeUpdated(existing, instanceGUID, metadataCollectionId, className, methodName);
        TxnValidations.instanceType(existing, className, methodName);
        TxnValidations.requiredProperty(instanceGUID, Keywords.CURRENT_STATUS.getName(), instanceStatus, className, methodName);
        TypeDef typeDef = UpdateInstanceStatus.getTypeDefForInstance(existing);
        TxnValidations.instanceStatus(instanceStatus, typeDef, className, methodName);
    }
}

