/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.readops;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.readops.AbstractGraphOperation;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetEntity;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;

public class GetLinkingEntities
extends AbstractGraphOperation {
    private static final Logger log = LoggerFactory.getLogger(GetLinkingEntities.class);
    private final String endEntityGUID;

    public GetLinkingEntities(XtdbOMRSRepositoryConnector xtdb, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) {
        super(xtdb, startEntityGUID, limitResultsByStatus, asOfTime);
        this.endEntityGUID = endEntityGUID;
    }

    public InstanceGraph execute() throws EntityNotKnownException, RepositoryErrorException {
        InstanceGraph instanceGraph;
        String methodName = "getLinkingEntities";
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            HashSet<String> entityGUIDsVisited = new HashSet<String>();
            HashSet<String> relationshipGUIDsVisited = new HashSet<String>();
            EntitySummary startingEntity = GetEntity.summaryByGuid(this.xtdb, db, this.startEntityGUID);
            if (startingEntity == null) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(this.startEntityGUID), this.getClass().getName(), "getLinkingEntities");
            }
            entityGUIDsVisited.add(this.startEntityGUID);
            HashSet<String> traversedGuids = new HashSet<String>();
            traversedGuids.add(this.startEntityGUID);
            Set<List<?>> successfulTraversals = this.traverseToEnd(db, this.startEntityGUID, this.endEntityGUID, this.limitResultsByStatus, traversedGuids, 1);
            instanceGraph = this.resultsToGraph(db, successfulTraversals, entityGUIDsVisited, relationshipGUIDsVisited, true);
            if (instanceGraph != null && instanceGraph.getEntities() != null && instanceGraph.getEntities().size() == 1) {
                instanceGraph = null;
            }
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getLinkingEntities", (Throwable)e);
        }
        return instanceGraph;
    }

    private Set<List<?>> traverseToEnd(IXtdbDatasource db, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Set<String> entityGUIDsVisited, int currentDepth) throws RepositoryTimeoutException {
        String methodName = "traverseToEnd";
        LinkedHashSet consolidated = new LinkedHashSet();
        if (currentDepth < 40) {
            try {
                Collection<List<?>> nextLevel = this.findDirectNeighbors(db, startEntityGUID, null, null, limitResultsByStatus, null);
                log.debug("Found traversal results: {}", nextLevel);
                String startRef = EntitySummaryMapping.getReference(startEntityGUID);
                String endRef = EntitySummaryMapping.getReference(endEntityGUID);
                if (nextLevel != null && !nextLevel.isEmpty()) {
                    for (List<?> candidateTuple : nextLevel) {
                        String nextStartGuid;
                        String candidateEntityRef = this.getEntityRefFromGraphTuple(candidateTuple);
                        if (endRef.equals(candidateEntityRef)) {
                            consolidated.add(candidateTuple);
                            continue;
                        }
                        if (startRef.equals(candidateEntityRef) || entityGUIDsVisited.contains(nextStartGuid = InstanceHeaderMapping.trimGuidFromReference(candidateEntityRef))) continue;
                        entityGUIDsVisited.add(nextStartGuid);
                        Set<List<?>> nextTraversal = this.traverseToEnd(db, nextStartGuid, endEntityGUID, limitResultsByStatus, entityGUIDsVisited, currentDepth + 1);
                        if (nextTraversal.isEmpty()) continue;
                        consolidated.add(candidateTuple);
                        consolidated.addAll(nextTraversal);
                    }
                }
            }
            catch (TimeoutException e) {
                throw new RepositoryTimeoutException(XtdbOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.xtdb.getRepositoryName()), this.getClass().getName(), "traverseToEnd", (Throwable)e);
            }
        }
        return consolidated;
    }
}

