/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.readops.FindEntities;
import org.odpi.egeria.connectors.juxt.xtdb.readops.FindEntitiesByPropertyValue;
import org.odpi.egeria.connectors.juxt.xtdb.readops.FindRelationships;
import org.odpi.egeria.connectors.juxt.xtdb.readops.FindRelationshipsByPropertyValue;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetEntity;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetEntityHistory;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetEntityNeighborhood;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetLinkingEntities;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetRelatedEntities;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetRelationshipHistory;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetRelationshipsForEntity;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AddEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AddEntityProxy;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AddRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ClassifyEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.DeclassifyEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.DeleteEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.DeleteRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.PurgeClassificationReferenceCopy;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.PurgeEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.PurgeRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReHomeEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReHomeRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReIdentifyEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReIdentifyRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReTypeEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReTypeRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.RestoreEntity;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.RestoreRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.SaveClassificationReferenceCopy;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.SaveEntityReferenceCopy;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.SaveRelationshipReferenceCopy;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UndoEntityUpdate;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UndoRelationshipUpdate;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UpdateEntityClassification;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UpdateEntityProperties;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UpdateEntityStatus;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UpdateRelationshipProperties;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UpdateRelationshipStatus;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSDynamicTypeMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;

public class XtdbOMRSMetadataCollection
extends OMRSDynamicTypeMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(XtdbOMRSMetadataCollection.class);
    private final XtdbOMRSRepositoryConnector xtdbRepositoryConnector;

    public XtdbOMRSMetadataCollection(XtdbOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId, AuditLog auditLog) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        log.debug("Constructing XtdbOMRSMetadataCollection with name: {}", (Object)repositoryName);
        parentConnector.setRepositoryName(repositoryName);
        this.xtdbRepositoryConnector = parentConnector;
        this.setAuditLog(auditLog);
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        super.addTypeDef(userId, newTypeDef);
        try {
            TypeDefCache.addTypeDef(newTypeDef);
        }
        catch (InvalidParameterException e) {
            throw new InvalidTypeDefException(XtdbOMRSErrorCode.INVALID_TYPEDEF.getMessageDefinition(newTypeDef.getName()), ((Object)((Object)this)).getClass().getName(), "addTypeDef", (Throwable)e);
        }
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        super.addAttributeTypeDef(userId, newAttributeTypeDef);
        TypeDefCache.addAttributeTypeDef(newAttributeTypeDef);
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException {
        String methodName = "updateTypeDef";
        TypeDef updated = super.updateTypeDef(userId, typeDefPatch);
        try {
            TypeDefCache.addTypeDef(updated);
        }
        catch (InvalidParameterException e) {
            throw new PatchErrorException(XtdbOMRSErrorCode.INVALID_TYPEDEF.getMessageDefinition(updated.getName()), ((Object)((Object)this)).getClass().getName(), "updateTypeDef", (Throwable)e);
        }
        return updated;
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, UserNotAuthorizedException {
        super.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        TypeDefCache.removeTypeDef(obsoleteTypeDefGUID);
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, UserNotAuthorizedException {
        super.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        TypeDefCache.removeAttributeTypeDef(obsoleteTypeDefGUID);
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        TypeDef updated = super.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName);
        TypeDefCache.addTypeDef(updated);
        TypeDefCache.removeTypeDef(originalTypeDefGUID);
        return updated;
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        AttributeTypeDef updated = super.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName);
        TypeDefCache.addAttributeTypeDef(updated);
        TypeDefCache.removeAttributeTypeDef(originalAttributeTypeDefGUID);
        return updated;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isEntityKnown";
        this.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        try {
            EntityDetail entity = new GetEntity(this.xtdbRepositoryConnector, guid, null).asDetail();
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "isEntityKnown");
            return entity;
        }
        catch (EntityNotKnownException e) {
            log.info("Entity with GUID {} does not exist in the repository.", (Object)guid);
        }
        catch (EntityProxyOnlyException e) {
            log.info("Entity with GUID {} exists, but is only a proxy in the repository.", (Object)guid);
        }
        return null;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        EntitySummary summary = new GetEntity(this.xtdbRepositoryConnector, guid, null).asSummary();
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, summary, "getEntitySummary");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)summary, "getEntitySummary");
        return summary;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException {
        return this.getEntityDetail(userId, guid, null);
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        EntityDetail entity = new GetEntity(this.xtdbRepositoryConnector, guid, asOfTime).asDetail();
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getEntityDetail");
        return entity;
    }

    public List<EntityDetail> getEntityDetailHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getEntityDetailHistory";
        super.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getEntityDetailHistory");
        return new GetEntityHistory(this.xtdbRepositoryConnector, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder).execute();
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PagingErrorException, UserNotAuthorizedException {
        List<Relationship> entityRelationships;
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        IXtdb xtdbAPI = this.xtdbRepositoryConnector.getXtdbAPI();
        try (IXtdbDatasource db = asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(asOfTime);){
            EntitySummary entity = GetEntity.summaryByGuid(this.xtdbRepositoryConnector, db, entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "getRelationshipsForEntity");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getRelationshipsForEntity");
            entityRelationships = new GetRelationshipsForEntity(this.xtdbRepositoryConnector, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, db, sequencingProperty, sequencingOrder, pageSize, userId).getResults();
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
        return entityRelationships == null || entityRelationships.isEmpty() ? null : entityRelationships;
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchProperties searchProperties = this.repositoryHelper.getSearchPropertiesFromInstanceProperties(this.repositoryName, matchProperties, matchCriteria);
        SearchClassifications searchClassifications = this.repositoryHelper.getSearchClassificationsFromList(limitResultsByClassification);
        return this.findEntities(userId, entityTypeGUID, null, searchProperties, fromEntityElement, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PagingErrorException {
        this.findEntitiesParameterValidation(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return new FindEntities(this.xtdbRepositoryConnector, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId).getResults();
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchProperties searchProperties = this.repositoryHelper.getSearchPropertiesFromInstanceProperties(this.repositoryName, matchClassificationProperties, matchCriteria);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition condition = new ClassificationCondition();
        condition.setName(classificationName);
        condition.setMatchProperties(searchProperties);
        classificationConditions.add(condition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findEntities(userId, entityTypeGUID, null, null, fromEntityElement, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchClassifications searchClassifications = this.repositoryHelper.getSearchClassificationsFromList(limitResultsByClassification);
        return new FindEntitiesByPropertyValue(this.xtdbRepositoryConnector, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId).getResults();
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        return new GetRelationship(this.xtdbRepositoryConnector, guid, null).execute();
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getRelationship";
        this.getInstanceParameterValidation(userId, guid, "getRelationship");
        return this.getAndValidateRelationship(guid, null);
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getRelationship";
        this.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        return this.getAndValidateRelationship(guid, asOfTime);
    }

    private Relationship getAndValidateRelationship(String guid, Date asOfTime) throws RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getAndValidateRelationship";
        Relationship relationship = new GetRelationship(this.xtdbRepositoryConnector, guid, asOfTime).execute();
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getAndValidateRelationship");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)relationship, "getAndValidateRelationship");
        return relationship;
    }

    public List<Relationship> getRelationshipHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "getRelationshipHistory";
        super.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getRelationshipHistory");
        return new GetRelationshipHistory(this.xtdbRepositoryConnector, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder).execute();
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PagingErrorException {
        super.findRelationshipsParameterValidation(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return new FindRelationships(this.xtdbRepositoryConnector, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId).getResults();
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        SearchProperties searchProperties = this.repositoryHelper.getSearchPropertiesFromInstanceProperties(this.repositoryName, matchProperties, matchCriteria);
        return this.findRelationships(userId, relationshipTypeGUID, null, searchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return new FindRelationshipsByPropertyValue(this.xtdbRepositoryConnector, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId).getResults();
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        this.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        if (startEntityGUID.equals(endEntityGUID)) {
            try {
                InstanceGraph one = new InstanceGraph();
                ArrayList<EntityDetail> list = new ArrayList<EntityDetail>();
                EntityDetail entity = new GetEntity(this.xtdbRepositoryConnector, startEntityGUID, asOfTime).asDetail();
                list.add(entity);
                one.setEntities(list);
                return one;
            }
            catch (EntityProxyOnlyException e) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(startEntityGUID, this.repositoryName), ((Object)((Object)this)).getClass().getName(), "getLinkingEntities", (Throwable)e);
            }
        }
        return new GetLinkingEntities(this.xtdbRepositoryConnector, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime).execute();
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, EntityNotKnownException, RepositoryErrorException, TypeErrorException {
        String methodName = "getEntityNeighborhood";
        String entityTypeGUIDParameterName = "entityTypeGUIDs";
        String relationshipTypeGUIDParameterName = "relationshipTypeGUIDs";
        String limitedResultsByClassificationParameterName = "limitResultsByClassification";
        String asOfTimeParameter = "asOfTime";
        this.validateRepositoryConnector("getEntityNeighborhood");
        this.parentConnector.validateRepositoryIsActive("getEntityNeighborhood");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getEntityNeighborhood");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getEntityNeighborhood");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getEntityNeighborhood");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "entityTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (relationshipTypeGUIDs != null) {
            for (String guid : relationshipTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "relationshipTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (limitResultsByClassification != null) {
            for (String classificationName : limitResultsByClassification) {
                this.repositoryValidator.validateClassificationName(this.repositoryName, "limitResultsByClassification", classificationName, "getEntityNeighborhood");
            }
        }
        return new GetEntityNeighborhood(this.xtdbRepositoryConnector, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level).execute();
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        InstanceGraph adjacent;
        this.getRelatedEntitiesParameterValidation(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        String methodName = "getRelatedEntities";
        String limitedResultsByClassificationParameterName = "limitResultsByClassification";
        this.validateRepositoryConnector("getRelatedEntities");
        this.parentConnector.validateRepositoryIsActive("getRelatedEntities");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getRelatedEntities");
        if (limitResultsByClassification != null) {
            for (String classificationName : limitResultsByClassification) {
                this.repositoryValidator.validateClassificationName(this.repositoryName, "limitResultsByClassification", classificationName, "getRelatedEntities");
            }
        }
        if ((adjacent = new GetRelatedEntities(this.xtdbRepositoryConnector, startEntityGUID, entityTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime).execute()) != null) {
            return this.repositoryHelper.formatEntityResults(adjacent.getEntities(), fromEntityElement, sequencingProperty, sequencingOrder, pageSize);
        }
        return null;
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException {
        String methodName = "addEntity";
        TypeDef typeDef = super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, typeDef.getName(), initialProperties, initialClassifications);
        newEntity.setMetadataCollectionName(this.metadataCollectionName);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        return this.addEntity(newEntity);
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        TypeDef typeDef = super.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, typeDef.getName(), initialProperties, initialClassifications);
        newEntity.setMetadataCollectionName(externalSourceName);
        newEntity.setReplicatedBy(this.metadataCollectionId);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        return this.addEntity(newEntity);
    }

    private EntityDetail addEntity(EntityDetail entity) throws RepositoryErrorException {
        return AddEntity.transact(this.xtdbRepositoryConnector, entity);
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException {
        super.addEntityProxyParameterValidation(userId, entityProxy);
        AddEntityProxy.transact(this.xtdbRepositoryConnector, entityProxy);
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException {
        this.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        return UpdateEntityStatus.transact(this.xtdbRepositoryConnector, userId, entityGUID, newStatus);
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException {
        this.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        return UpdateEntityProperties.transact(this.xtdbRepositoryConnector, userId, entityGUID, properties);
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        super.manageInstanceParameterValidation(userId, entityGUID, "entityGUID", "undoEntityUpdate");
        return UndoEntityUpdate.transact(this.xtdbRepositoryConnector, userId, entityGUID);
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        super.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        return DeleteEntity.transact(this.xtdbRepositoryConnector, userId, obsoleteEntityGUID);
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException {
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        PurgeEntity.transactWithValidation(this.xtdbRepositoryConnector, deletedEntityGUID);
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException {
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        return RestoreEntity.transact(this.xtdbRepositoryConnector, userId, deletedEntityGUID);
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException {
        return this.classifyEntity(userId, entityGUID, classificationName, null, null, null, null, classificationProperties);
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException {
        String methodName = "classifyEntity";
        this.validateRepositoryConnector("classifyEntity");
        this.parentConnector.validateRepositoryIsActive("classifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity");
        return ClassifyEntity.transact(this.xtdbRepositoryConnector, userId, entityGUID, classificationName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, classificationProperties);
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException {
        super.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity");
        return DeclassifyEntity.transact(this.xtdbRepositoryConnector, entityGUID, classificationName);
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException {
        super.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        return UpdateEntityClassification.transact(this.xtdbRepositoryConnector, userId, entityGUID, classificationName, properties);
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, typeDef.getName(), initialProperties);
        if (initialStatus != null) {
            relationship.setStatus(initialStatus);
        }
        return this.addRelationship(relationship, entityOneGUID, entityTwoGUID);
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException {
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, typeDef.getName(), initialProperties);
        relationship.setMetadataCollectionName(externalSourceName);
        relationship.setReplicatedBy(this.metadataCollectionId);
        if (initialStatus != null) {
            relationship.setStatus(initialStatus);
        }
        return this.addRelationship(relationship, entityOneGUID, entityTwoGUID);
    }

    private Relationship addRelationship(Relationship relationship, String entityOneGUID, String entityTwoGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        return AddRelationship.transact(this.xtdbRepositoryConnector, relationship, entityOneGUID, entityTwoGUID);
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException {
        this.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        return UpdateRelationshipStatus.transact(this.xtdbRepositoryConnector, userId, relationshipGUID, newStatus);
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException {
        this.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        return UpdateRelationshipProperties.transact(this.xtdbRepositoryConnector, userId, relationshipGUID, properties);
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        this.manageInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", "undoRelationshipUpdate");
        return UndoRelationshipUpdate.transact(this.xtdbRepositoryConnector, userId, relationshipGUID);
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        return DeleteRelationship.transact(this.xtdbRepositoryConnector, userId, obsoleteRelationshipGUID);
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException {
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        PurgeRelationship.transactWithValidation(this.xtdbRepositoryConnector, deletedRelationshipGUID);
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException {
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        return RestoreRelationship.transact(this.xtdbRepositoryConnector, userId, deletedRelationshipGUID);
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, entityGUID, "entityGUID", newEntityGUID, "newEntityGUID", "reIdentifyEntity");
        return ReIdentifyEntity.transact(this.xtdbRepositoryConnector, userId, entityGUID, newEntityGUID);
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException {
        super.reTypeInstanceParameterValidation(userId, entityGUID, "entityGUID", TypeDefCategory.ENTITY_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeEntity");
        return ReTypeEntity.transact(this.xtdbRepositoryConnector, userId, entityGUID, newTypeDefSummary);
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        super.reHomeInstanceParameterValidation(userId, entityGUID, "entityGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeEntity");
        return ReHomeEntity.transact(this.xtdbRepositoryConnector, userId, entityGUID, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, relationshipGUID, "relationshipGUID", newRelationshipGUID, "newRelationshipGUID", "reIdentifyRelationship");
        return ReIdentifyRelationship.transact(this.xtdbRepositoryConnector, userId, relationshipGUID, newRelationshipGUID);
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException {
        super.reTypeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", TypeDefCategory.RELATIONSHIP_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeRelationship");
        return ReTypeRelationship.transact(this.xtdbRepositoryConnector, userId, relationshipGUID, newTypeDefSummary);
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException {
        String methodName = "reHomeRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        this.validateRepositoryConnector("reHomeRelationship");
        this.parentConnector.validateRepositoryIsActive("reHomeRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reHomeRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "reHomeRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "newHomeMetadataCollectionId", newHomeMetadataCollectionId, "reHomeRelationship");
        return ReHomeRelationship.transact(this.xtdbRepositoryConnector, userId, relationshipGUID, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, EntityConflictException, HomeEntityException {
        String methodName = "saveEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.validateRepositoryConnector("saveEntityReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveEntityReferenceCopy");
        this.repositoryValidator.validateReferenceInstanceHeader(this.repositoryName, this.metadataCollectionId, "entity", (InstanceHeader)entity, "saveEntityReferenceCopy");
        SaveEntityReferenceCopy.transact(this.xtdbRepositoryConnector, entity);
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException {
        String methodName = "getHomeClassifications";
        this.validateRepositoryConnector("getHomeClassifications");
        this.parentConnector.validateRepositoryIsActive("getHomeClassifications");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getHomeClassifications");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getHomeClassifications");
        EntitySummary retrievedEntity = new GetEntity(this.xtdbRepositoryConnector, entityGUID, null).asSummary();
        ArrayList<Classification> homeClassifications = new ArrayList<Classification>();
        if (retrievedEntity != null) {
            List retrievedClassifications = retrievedEntity.getClassifications();
            if (retrievedClassifications != null) {
                for (Classification retrievedClassification : retrievedClassifications) {
                    if (retrievedClassification == null || !this.metadataCollectionId.equals(retrievedClassification.getMetadataCollectionId())) continue;
                    homeClassifications.add(retrievedClassification);
                }
            }
        } else {
            super.reportEntityNotKnown(entityGUID, "getHomeClassifications");
        }
        return homeClassifications.isEmpty() ? null : homeClassifications;
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        this.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeEntityReferenceCopy");
        PurgeEntity.transactWithoutValidation(this.xtdbRepositoryConnector, entityGUID);
    }

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, PropertyErrorException {
        SaveClassificationReferenceCopy.transact(this.xtdbRepositoryConnector, entity, classification);
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws EntityConflictException, RepositoryErrorException {
        PurgeClassificationReferenceCopy.transact(this.xtdbRepositoryConnector, entity, classification);
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, RelationshipConflictException, HomeRelationshipException, UserNotAuthorizedException {
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "saveRelationshipReferenceCopy");
        SaveRelationshipReferenceCopy.transact(this.xtdbRepositoryConnector, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        this.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeRelationshipReferenceCopy");
        PurgeRelationship.transactWithoutValidation(this.xtdbRepositoryConnector, relationshipGUID);
    }

    protected EntityProxy getEntityProxy(String userId, String entityGUID, String methodName) throws EntityNotKnownException, RepositoryErrorException {
        EntityProxy proxy = new GetEntity(this.xtdbRepositoryConnector, entityGUID, null).asProxy();
        if (proxy == null) {
            this.reportEntityNotKnown(entityGUID, methodName);
        }
        return proxy;
    }
}

