/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import java.util.ArrayList;
import java.util.Date;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.Constants;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.Keywords;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public abstract class AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(AbstractTransactionFunction.class);

    protected static String getTxnTimeCalculation(String docVar) {
        StringBuilder sb = new StringBuilder();
        sb.append(" txt-classification (").append(Keywords.LAST_CLASSIFICATION_CHANGE).append(" ").append(docVar).append(")");
        sb.append(" txt-update (").append(Keywords.UPDATE_TIME).append(" ").append(docVar).append(")");
        sb.append(" txt-tmp (if (< 0 (compare txt-classification txt-update)) txt-classification txt-update)");
        sb.append(" txt (if (some? txt-tmp) txt-tmp ").append("(").append(Keywords.CREATE_TIME).append(" ").append(docVar).append("))");
        return sb.toString();
    }

    protected static void createTransactionFunction(Transaction.Builder tx, Keyword name, String fn) {
        log.debug("Creating transaction function: {}", (Object)fn);
        XtdbDocument function = XtdbDocument.createFunction((Object)name, (String)fn);
        tx.put(function);
    }

    protected static IPersistentMap incrementVersion(String userId, IPersistentMap instance) {
        return AbstractTransactionFunction.incrementVersion(userId, instance, null);
    }

    protected static IPersistentMap incrementVersion(String userId, IPersistentMap instance, String classificationName) {
        Keyword UPDATE_TIME;
        Keyword UPDATED_BY;
        Keyword MAINTAINED_BY;
        Keyword VERSION;
        if (classificationName != null) {
            String namespace = ClassificationMapping.getNamespaceForClassification(classificationName);
            VERSION = Keyword.intern((String)namespace, (String)Keywords.VERSION.getName());
            MAINTAINED_BY = Keyword.intern((String)namespace, (String)Keywords.MAINTAINED_BY.getName());
            UPDATED_BY = Keyword.intern((String)namespace, (String)Keywords.UPDATED_BY.getName());
            UPDATE_TIME = Keyword.intern((String)namespace, (String)Keywords.UPDATE_TIME.getName());
        } else {
            VERSION = Keywords.VERSION;
            MAINTAINED_BY = Keywords.MAINTAINED_BY;
            UPDATED_BY = Keywords.UPDATED_BY;
            UPDATE_TIME = Keywords.UPDATE_TIME;
        }
        Long currentVersion = (Long)instance.valAt((Object)VERSION);
        ArrayList<String> maintainers = (ArrayList<String>)instance.valAt((Object)MAINTAINED_BY);
        IPersistentMap modified = instance.assoc((Object)UPDATED_BY, (Object)userId).assoc((Object)UPDATE_TIME, (Object)new Date()).assoc((Object)VERSION, (Object)(currentVersion + 1L));
        if (maintainers == null) {
            maintainers = new ArrayList<String>();
        }
        if (!maintainers.contains(userId)) {
            maintainers.add(userId);
            modified = modified.assoc((Object)MAINTAINED_BY, (Object)PersistentVector.create(maintainers));
        }
        return modified;
    }

    public static String getTypeDefGUID(IPersistentMap instance) {
        return (String)((IPersistentVector)instance.valAt((Object)Keywords.TYPE_DEF_GUIDS)).nth(0);
    }

    public static TypeDef getTypeDefForInstance(IPersistentMap instance) {
        return TypeDefCache.getTypeDef(AbstractTransactionFunction.getTypeDefGUID(instance));
    }

    public static String getGUID(IPersistentMap instance) {
        return (String)instance.valAt((Object)Constants.XTDB_PK);
    }

    public static String getMetadataCollectionId(IPersistentMap instance) {
        return (String)instance.valAt((Object)Keywords.METADATA_COLLECTION_ID);
    }

    public static Integer getInstanceProvenanceType(IPersistentMap instance) {
        return (Integer)instance.valAt((Object)Keywords.INSTANCE_PROVENANCE_TYPE);
    }
}

