/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.PurgeRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class PurgeEntity
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(PurgeEntity.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"purgeEntity");
    private static final String CLASS_NAME = PurgeEntity.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String RELN_QUERY = "{:find [(quote r)] :where [[(quote r) :" + RelationshipMapping.ENTITY_PROXIES + " eid]         [(quote r) :" + InstanceAuditHeaderMapping.TYPE_DEF_CATEGORY + " " + TypeDefCategory.RELATIONSHIP_DEF.getOrdinal() + "]]}";
    private static final String FN = "(fn [ctx eid force]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          relationships (xtdb.api/q db " + RELN_QUERY + ")          existing (xtdb.api/entity db eid)          deleted (.doc (" + PurgeEntity.class.getCanonicalName() + ". tx-id existing eid force))]         (conj (vec (for [[rid] relationships]                     [:xtdb.api/fn " + PurgeRelationship.FUNCTION_NAME + " rid true]))               [:xtdb.api/evict eid])))";
    private final IPersistentMap xtdbDoc;

    public PurgeEntity(Long txId, PersistentHashMap existing, String deletedEntityGUID, boolean force) throws Exception {
        try {
            if (existing == null) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(deletedEntityGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.nonProxyEntity((IPersistentMap)existing, deletedEntityGUID, CLASS_NAME, METHOD_NAME);
            if (!force) {
                TxnValidations.entityFromStore(deletedEntityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
                try {
                    TxnValidations.instanceIsDeleted((IPersistentMap)existing, deletedEntityGUID, CLASS_NAME, METHOD_NAME);
                }
                catch (InvalidParameterException e) {
                    throw new EntityNotDeletedException(XtdbOMRSErrorCode.INSTANCE_NOT_DELETED.getMessageDefinition(deletedEntityGUID), CLASS_NAME, METHOD_NAME);
                }
            }
            this.xtdbDoc = existing;
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static void transactWithValidation(XtdbOMRSRepositoryConnector xtdb, String entityGUID) throws EntityNotKnownException, EntityNotDeletedException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, false});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (EntityNotDeletedException | EntityNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public static void transactWithoutValidation(XtdbOMRSRepositoryConnector xtdb, String entityGUID) throws EntityNotKnownException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, true});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (EntityNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being purged: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        PurgeEntity.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

