/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import xtdb.api.XtdbDocument;

public class EntityProxyMapping
extends EntitySummaryMapping {
    private static final String ENTITY_PROXY = "EntityProxy";
    public static final String ENTITY_PROXY_ONLY_MARKER = EntityProxyMapping.getKeyword("e", "proxy");

    public EntityProxyMapping(XtdbOMRSRepositoryConnector xtdbConnector, EntityProxy entityProxy) {
        super(xtdbConnector, (EntitySummary)entityProxy);
    }

    public EntityProxyMapping(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument xtdbDoc) {
        super(xtdbConnector, xtdbDoc);
    }

    public EntityProxy toEgeria() {
        if (this.instanceHeader == null && this.xtdbDoc != null) {
            this.instanceHeader = new EntityProxy();
            this.fromDoc();
        }
        if (this.instanceHeader != null) {
            return (EntityProxy)this.instanceHeader;
        }
        return null;
    }

    @Override
    protected XtdbDocument.Builder toDoc() {
        XtdbDocument.Builder builder = super.toDoc();
        builder.put(ENTITY_PROXY_ONLY_MARKER, (Object)true);
        InstancePropertiesMapping.addToDoc(this.xtdbConnector, builder, this.instanceHeader.getType(), ((EntityProxy)this.instanceHeader).getUniqueProperties());
        return builder;
    }

    @Override
    protected void fromDoc() {
        super.fromDoc();
        InstanceProperties uniqueProperties = InstancePropertiesMapping.getFromDoc(this.xtdbConnector, this.instanceHeader.getType(), this.xtdbDoc);
        ((EntityProxy)this.instanceHeader).setUniqueProperties(uniqueProperties);
    }

    public static EntityProxy fromMap(IPersistentMap doc) throws IOException, InvalidParameterException {
        if (doc == null) {
            return null;
        }
        if (EntityProxyMapping.isOnlyAProxy(doc)) {
            EntityProxy ep = new EntityProxy();
            EntitySummaryMapping.fromMap((EntitySummary)ep, doc);
            InstanceType entityType = EntityProxyMapping.getTypeFromInstance(doc, null);
            InstanceProperties uniqueProperties = InstancePropertiesMapping.getFromMap(entityType, doc);
            ep.setUniqueProperties(uniqueProperties);
            return ep;
        }
        EntityDetail ed = EntityDetailMapping.fromMap(doc);
        return EntityProxyMapping.getNewEntityProxy(ed);
    }

    public static EntityProxy getFromDoc(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument doc) {
        String methodName = "getFromDoc";
        if (doc == null) {
            return null;
        }
        if (EntityProxyMapping.isOnlyAProxy(doc)) {
            EntityProxyMapping epm = new EntityProxyMapping(xtdbConnector, doc);
            return epm.toEgeria();
        }
        EntityDetailMapping edm = new EntityDetailMapping(xtdbConnector, doc);
        try {
            return xtdbConnector.getRepositoryHelper().getNewEntityProxy(xtdbConnector.getRepositoryName(), edm.toEgeria());
        }
        catch (RepositoryErrorException e) {
            xtdbConnector.logProblem(EntityProxyMapping.class.getName(), "getFromDoc", XtdbOMRSAuditCode.FAILED_RETRIEVAL, e, ENTITY_PROXY, doc.getId().toString(), ((Object)((Object)e)).getClass().getName());
            return null;
        }
    }

    public static String getReference(String guid) {
        return EntitySummaryMapping.getReference(guid);
    }

    public static boolean isOnlyAProxy(XtdbDocument doc) {
        Boolean only = (Boolean)doc.get(ENTITY_PROXY_ONLY_MARKER);
        return only != null && only != false;
    }

    public static boolean isOnlyAProxy(IPersistentMap doc) {
        Boolean only = (Boolean)doc.valAt((Object)Keyword.intern((String)ENTITY_PROXY_ONLY_MARKER));
        return only != null && only != false;
    }

    private static EntityProxy getNewEntityProxy(EntityDetail entity) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            String typeDefGUID = type.getTypeDefGUID();
            EntityProxy entityProxy = new EntityProxy((EntitySummary)entity);
            InstanceProperties entityProperties = entity.getProperties();
            if (entityProperties != null) {
                Map<String, PropertyKeywords> properties = TypeDefCache.getAllPropertyKeywordsForTypeDef(typeDefGUID);
                InstanceProperties uniqueAttributes = new InstanceProperties();
                uniqueAttributes.setEffectiveFromTime(entityProperties.getEffectiveFromTime());
                uniqueAttributes.setEffectiveToTime(entityProperties.getEffectiveToTime());
                List propertiesDefinition = properties.values().stream().map(PropertyKeywords::getAttribute).collect(Collectors.toList());
                for (TypeDefAttribute typeDefAttribute : propertiesDefinition) {
                    InstancePropertyValue propertyValue;
                    if (typeDefAttribute == null) continue;
                    String propertyName = typeDefAttribute.getAttributeName();
                    if (!typeDefAttribute.isUnique() || propertyName == null || (propertyValue = entityProperties.getPropertyValue(propertyName)) == null) continue;
                    uniqueAttributes.setProperty(propertyName, propertyValue);
                }
                if (uniqueAttributes.getPropertyCount() > 0 || uniqueAttributes.getEffectiveFromTime() != null || uniqueAttributes.getEffectiveToTime() != null) {
                    entityProxy.setUniqueProperties(uniqueAttributes);
                }
            }
            return entityProxy;
        }
        return null;
    }
}

