/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class StructPropertyValueMapping
extends InstancePropertyValueMapping {
    public static void addStructPropertyValueToDoc(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument.Builder builder, PropertyKeywords keywords, StructPropertyValue value) {
        builder.put(keywords.getSearchablePath(), StructPropertyValueMapping.getStructPropertyValueForComparison(xtdbConnector, value));
    }

    public static IPersistentMap addStructPropertyValueToDoc(IPersistentMap doc, Keyword propertyKeyword, StructPropertyValue value) throws InvalidParameterException {
        return doc.assoc((Object)propertyKeyword, StructPropertyValueMapping.getStructPropertyValueForComparison(value));
    }

    public static Map<String, Object> getStructPropertyValueForComparison(XtdbOMRSRepositoryConnector xtdbConnector, StructPropertyValue spv) {
        InstanceProperties values = spv.getAttributes();
        if (values != null && values.getInstanceProperties() != null) {
            TreeMap<String, Object> results = new TreeMap<String, Object>();
            for (Map.Entry entry : values.getInstanceProperties().entrySet()) {
                String key = (String)entry.getKey();
                InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                Object toCompare = StructPropertyValueMapping.getValueForComparison(xtdbConnector, value);
                if (toCompare == null) continue;
                results.put(key, toCompare);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public static Map<String, Object> getStructPropertyValueForComparison(StructPropertyValue spv) throws InvalidParameterException {
        InstanceProperties values = spv.getAttributes();
        if (values != null && values.getInstanceProperties() != null) {
            TreeMap<String, Object> results = new TreeMap<String, Object>();
            for (Map.Entry entry : values.getInstanceProperties().entrySet()) {
                String key = (String)entry.getKey();
                InstancePropertyValue value = (InstancePropertyValue)entry.getValue();
                Object toCompare = StructPropertyValueMapping.getValueForComparison(value);
                if (toCompare == null) continue;
                results.put(key, toCompare);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }
}

