/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.Keyword;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class AddEntityProxy
extends AbstractTransactionFunction {
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"addEntityProxy");
    private static final String CLASS_NAME = AddEntityProxy.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid proxy]     (let [db (xtdb.api/db ctx)          existing (xtdb.api/entity db eid)          proxy-only (get existing :" + EntityProxyMapping.ENTITY_PROXY_ONLY_MARKER + ")          create (if (some? proxy-only) proxy-only true)" + AddEntityProxy.getTxnTimeCalculation("proxy") + "]         (when create [[:xtdb.api/put proxy txt]])))";

    private AddEntityProxy() {
    }

    public static void transact(XtdbOMRSRepositoryConnector xtdb, EntityProxy entity) throws RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entity.getGUID());
        EntityProxyMapping epm = new EntityProxyMapping(xtdb, entity);
        XtdbDocument proxyDoc = epm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, proxyDoc.toMap()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public static void create(Transaction.Builder tx) {
        AddEntityProxy.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

