/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import java.util.Date;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.Keywords;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UpdateEntityClassification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public abstract class UpdateInstanceProperties
extends AbstractTransactionFunction {
    protected static IPersistentMap updateInstanceProperties(String userId, IPersistentMap existing, InstanceProperties properties) throws InvalidParameterException, IOException, ClassificationErrorException {
        return UpdateInstanceProperties.updateInstanceProperties(userId, existing, properties, null);
    }

    protected static IPersistentMap updateInstanceProperties(String userId, IPersistentMap existing, InstanceProperties properties, String classificationName) throws InvalidParameterException, IOException, ClassificationErrorException {
        String typeDefGUID;
        String methodName = "updateInstanceProperties";
        IPersistentMap doc = UpdateInstanceProperties.incrementVersion(userId, existing, classificationName);
        if (classificationName == null) {
            typeDefGUID = UpdateInstanceProperties.getTypeDefGUID(existing);
        } else {
            TypeDef classificationTypeDef = TypeDefCache.getTypeDefByName(classificationName);
            if (classificationTypeDef == null) {
                throw new ClassificationErrorException(XtdbOMRSErrorCode.INVALID_TYPEDEF.getMessageDefinition(classificationName), TxnValidations.class.getName(), "updateInstanceProperties");
            }
            typeDefGUID = classificationTypeDef.getGUID();
            ClassificationMapping.validateHasClassification(existing, classificationName, UpdateEntityClassification.CLASS_NAME, UpdateEntityClassification.METHOD_NAME);
            doc = doc.assoc((Object)Keywords.LAST_CLASSIFICATION_CHANGE, (Object)new Date());
        }
        return InstancePropertiesMapping.addToMap(doc, typeDefGUID, properties);
    }

    protected static void validate(IPersistentMap existing, String instanceGUID, String metadataCollectionId, InstanceProperties properties, String className, String methodName) throws InvalidParameterException, RepositoryErrorException, IOException, PropertyErrorException {
        TxnValidations.instanceIsNotDeleted(existing, instanceGUID, className, methodName);
        TxnValidations.instanceCanBeUpdated(existing, instanceGUID, metadataCollectionId, className, methodName);
        TxnValidations.instanceType(existing, className, methodName);
        TypeDef typeDef = UpdateInstanceProperties.getTypeDefForInstance(existing);
        TxnValidations.propertiesForType(typeDef, properties, className, methodName);
    }
}

