/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class EntityDetailMapping
extends EntitySummaryMapping {
    public static final String ENTITY_PROPERTIES_NS = "entityProperties";

    public EntityDetailMapping(XtdbOMRSRepositoryConnector xtdbConnector, EntityDetail entityDetail) {
        super(xtdbConnector, (EntitySummary)entityDetail);
    }

    public EntityDetailMapping(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument xtdbDoc) {
        super(xtdbConnector, xtdbDoc);
    }

    public EntityDetail toEgeria() {
        if (this.instanceHeader == null && this.xtdbDoc != null) {
            this.instanceHeader = new EntityDetail();
            this.fromDoc();
        }
        if (this.instanceHeader != null) {
            return (EntityDetail)this.instanceHeader;
        }
        return null;
    }

    @Override
    protected XtdbDocument.Builder toDoc() {
        XtdbDocument.Builder builder = super.toDoc();
        builder.put(EntityProxyMapping.ENTITY_PROXY_ONLY_MARKER, (Object)false);
        InstancePropertiesMapping.addToDoc(this.xtdbConnector, builder, this.instanceHeader.getType(), ((EntityDetail)this.instanceHeader).getProperties());
        return builder;
    }

    @Override
    protected void fromDoc() {
        super.fromDoc();
        InstanceProperties ip = InstancePropertiesMapping.getFromDoc(this.xtdbConnector, this.instanceHeader.getType(), this.xtdbDoc);
        ((EntityDetail)this.instanceHeader).setProperties(ip);
    }

    public static EntityDetail fromMap(IPersistentMap doc) throws IOException, InvalidParameterException {
        if (doc == null) {
            return null;
        }
        EntityDetail ed = new EntityDetail();
        EntitySummaryMapping.fromMap((EntitySummary)ed, doc);
        InstanceType entityType = EntityDetailMapping.getTypeFromInstance(doc, null);
        InstanceProperties ip = InstancePropertiesMapping.getFromMap(entityType, doc);
        ed.setProperties(ip);
        return ed;
    }

    public static String getReference(String guid) {
        return EntitySummaryMapping.getReference(guid);
    }
}

