/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import java.util.Date;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertyValueMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import xtdb.api.XtdbDocument;

public class PrimitivePropertyValueMapping
extends InstancePropertyValueMapping {
    public static void addPrimitivePropertyValueToDoc(XtdbDocument.Builder builder, PropertyKeywords keywords, PrimitivePropertyValue value) {
        builder.put(keywords.getSearchablePath(), PrimitivePropertyValueMapping.getPrimitiveValueForComparison(value));
    }

    public static IPersistentMap addPrimitivePropertyValueToDoc(IPersistentMap doc, Keyword propertyKeyword, PrimitivePropertyValue value) {
        return doc.assoc((Object)propertyKeyword, PrimitivePropertyValueMapping.getPrimitiveValueForComparison(value));
    }

    public static Object getPrimitiveValueForComparison(PrimitivePropertyValue ppv) {
        PrimitiveDefCategory category = ppv.getPrimitiveDefCategory();
        Object value = null;
        if (category != null) {
            switch (category) {
                case OM_PRIMITIVE_TYPE_DATE: {
                    Object longForm = ppv.getPrimitiveValue();
                    if (!(longForm instanceof Long)) break;
                    value = new Date((Long)longForm);
                    break;
                }
                case OM_PRIMITIVE_TYPE_BOOLEAN: {
                    Object bool = ppv.getPrimitiveValue();
                    if (!(bool instanceof Boolean)) break;
                    value = (Boolean)bool != false ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                default: {
                    value = ppv.getPrimitiveValue();
                }
            }
        }
        return value;
    }
}

