/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.readops;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.readops.AbstractSearchOperation;
import org.odpi.egeria.connectors.juxt.xtdb.readops.GetRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryTimeoutException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;

public abstract class AbstractRelationshipSearchOperation
extends AbstractSearchOperation {
    private static final Logger log = LoggerFactory.getLogger(AbstractRelationshipSearchOperation.class);

    protected AbstractRelationshipSearchOperation(XtdbOMRSRepositoryConnector xtdb, String typeGUID, int fromElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) {
        super(xtdb, typeGUID, fromElement, limitResultsByStatus, null, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId);
    }

    protected AbstractRelationshipSearchOperation(XtdbOMRSRepositoryConnector xtdb, String typeGUID, int fromElement, List<InstanceStatus> limitResultsByStatus, IXtdbDatasource existingDB, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) {
        super(xtdb, typeGUID, fromElement, limitResultsByStatus, null, existingDB, sequencingProperty, sequencingOrder, pageSize, userId);
    }

    public List<Relationship> getResults() throws TypeErrorException, RepositoryErrorException {
        List<Relationship> results;
        if (this.existingDB != null) {
            try {
                Collection<List<?>> xtdbResults = this.runQuery(this.existingDB);
                log.debug("Found results: {}", xtdbResults);
                return this.translateResults(xtdbResults, this.existingDB);
            }
            catch (TimeoutException e) {
                throw new RepositoryTimeoutException(XtdbOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.xtdb.getRepositoryName()), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
            }
        }
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            Collection<List<?>> xtdbResults = this.runQuery(db);
            log.debug("Found results: {}", xtdbResults);
            results = this.translateResults(xtdbResults, db);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(XtdbOMRSErrorCode.QUERY_TIMEOUT.getMessageDefinition(""), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
        }
        return results;
    }

    private List<Relationship> translateResults(Collection<List<?>> xtdbResults, IXtdbDatasource db) {
        String methodName = "translateResults";
        ArrayList<Relationship> results = null;
        if (xtdbResults != null) {
            results = new ArrayList<Relationship>();
            for (List<?> xtdbResult : xtdbResults) {
                String docRef = (String)xtdbResult.get(0);
                Relationship relationship = GetRelationship.byRef(this.xtdb, db, docRef);
                if (relationship == null) {
                    this.xtdb.logProblem(this.getClass().getName(), "translateResults", XtdbOMRSAuditCode.MAPPING_FAILURE, null, "relationship", docRef, "cannot be translated to Relationship");
                    continue;
                }
                results.add(relationship);
            }
        }
        return results;
    }
}

