/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.readops;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.xtdb.readops.AbstractHistoryOperation;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public class GetRelationshipHistory
extends AbstractHistoryOperation {
    public GetRelationshipHistory(XtdbOMRSRepositoryConnector xtdb, String instanceGUID, Date fromTime, Date toTime, int fromElement, int pageSize, HistorySequencingOrder sequencingOrder) {
        super(xtdb, instanceGUID, fromTime, toTime, fromElement, pageSize, sequencingOrder);
    }

    public List<Relationship> execute() throws RelationshipNotKnownException, RepositoryErrorException {
        boolean noResults;
        String methodName = "getPreviousVersionsOfRelationship";
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        String docRef = RelationshipMapping.getReference(this.instanceGUID);
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            List<XtdbDocument> history = this.getPreviousVersions(db, docRef, this.fromTime, this.sequencingOrder);
            noResults = history.isEmpty();
            int maxResult = this.fromElement + (this.pageSize == 0 ? this.xtdb.getMaxPageSize() : this.pageSize);
            int currentIndex = 0;
            for (XtdbDocument version : history) {
                RelationshipMapping rm;
                Relationship detail;
                if (currentIndex >= maxResult) {
                    break;
                }
                if (currentIndex >= this.fromElement && (detail = (rm = new RelationshipMapping(this.xtdb, version, db)).toEgeria()) != null) {
                    results.add(detail);
                }
                ++currentIndex;
            }
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getPreviousVersionsOfRelationship", (Throwable)e);
        }
        if (noResults) {
            throw new RelationshipNotKnownException(XtdbOMRSErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(this.instanceGUID), this.getClass().getName(), "getPreviousVersionsOfRelationship");
        }
        return results;
    }
}

