/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.SaveEntityReferenceCopy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class PurgeClassificationReferenceCopy
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(PurgeClassificationReferenceCopy.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"purgeClassificationReferenceCopy");
    private static final String CLASS_NAME = PurgeClassificationReferenceCopy.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid e rcc mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + PurgeClassificationReferenceCopy.class.getCanonicalName() + ". tx-id existing e rcc mid))          nmid (when (some? updated)                     (get updated :" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + "))" + PurgeClassificationReferenceCopy.getTxnTimeCalculation("updated") + "]         (when (some? nmid)          (if (= mid nmid)            [[:xtdb.api/put updated txt]]            [[:xtdb.api/fn " + SaveEntityReferenceCopy.FUNCTION_NAME + " eid updated mid]]))))";
    private final IPersistentMap xtdbDoc;

    public PurgeClassificationReferenceCopy(Long txId, PersistentHashMap existing, PersistentHashMap entity, Classification classification, String homeMetadataCollectionId) throws Exception {
        try {
            PersistentHashMap docToUpdate = existing;
            if (existing == null && !homeMetadataCollectionId.equals(PurgeClassificationReferenceCopy.getMetadataCollectionId((IPersistentMap)entity))) {
                docToUpdate = entity;
            }
            if (docToUpdate != null) {
                try {
                    docToUpdate = ClassificationMapping.removeFromMap((IPersistentMap)docToUpdate, classification.getName());
                }
                catch (ClassificationErrorException e) {
                    log.debug("Entity with GUID {} had no classification {}, nothing to purge.", (Object)PurgeClassificationReferenceCopy.getGUID((IPersistentMap)entity), (Object)classification.getName());
                    docToUpdate = null;
                }
            }
            this.xtdbDoc = docToUpdate;
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static void transact(XtdbOMRSRepositoryConnector xtdb, EntityDetail toPurgeFrom, Classification classification) throws EntityConflictException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(toPurgeFrom.getGUID());
        EntityDetailMapping edm = new EntityDetailMapping(xtdb, toPurgeFrom);
        XtdbDocument toPurgeFromXT = edm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, toPurgeFromXT.toMap(), classification, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (EntityConflictException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        PurgeClassificationReferenceCopy.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

