/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentVector;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.Keywords;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.tx.Transaction;

public class ReLinkRelationship
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(ReLinkRelationship.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"reLinkRelationship");
    private static final String CLASS_NAME = ReLinkRelationship.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx rid eid nid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db rid)          relinked (.doc (" + ReLinkRelationship.class.getCanonicalName() + ". tx-id existing rid eid nid))" + ReLinkRelationship.getTxnTimeCalculation("relinked") + "]         [[:xtdb.api/put relinked txt]]))";
    private final IPersistentMap xtdbDoc;

    public ReLinkRelationship(Long txId, PersistentHashMap existing, String relationshipGUID, String oldEntityGUID, String newEntityGUID) throws Exception {
        try {
            IPersistentVector newProxies;
            if (existing == null) {
                throw new RelationshipNotKnownException(XtdbOMRSErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID), this.getClass().getName(), METHOD_NAME);
            }
            IPersistentVector proxies = (IPersistentVector)existing.valAt((Object)Keywords.ENTITY_PROXIES);
            if (proxies != null && proxies.length() == 2) {
                String proxyOneGUID = (String)proxies.nth(0);
                String proxyTwoGUID = (String)proxies.nth(1);
                newProxies = proxies;
                if (proxyOneGUID.equals(oldEntityGUID)) {
                    newProxies = PersistentVector.create((Object[])new Object[]{newEntityGUID, proxyTwoGUID});
                } else if (proxyTwoGUID.equals(oldEntityGUID)) {
                    newProxies = PersistentVector.create((Object[])new Object[]{proxyOneGUID, newEntityGUID});
                }
            } else {
                throw new RepositoryErrorException(XtdbOMRSErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(relationshipGUID, "one or both proxies are missing", existing.toString()), CLASS_NAME, METHOD_NAME);
            }
            this.xtdbDoc = existing.assoc((Object)Keywords.ENTITY_PROXIES, (Object)newProxies);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Relationship being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        ReLinkRelationship.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

