/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.SaveEntityReferenceCopy;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class SaveClassificationReferenceCopy
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(SaveClassificationReferenceCopy.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"saveClassificationReferenceCopy");
    private static final String CLASS_NAME = SaveClassificationReferenceCopy.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid e rcc mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + SaveClassificationReferenceCopy.class.getCanonicalName() + ". tx-id eid existing e rcc mid))" + SaveClassificationReferenceCopy.getTxnTimeCalculation("updated") + "          nmid (when (some? updated)                     (get updated :" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + "))]         (when (some? nmid)          (if (= mid nmid)            [[:xtdb.api/put updated txt]]            [[:xtdb.api/fn " + SaveEntityReferenceCopy.FUNCTION_NAME + " eid updated mid]]))))";
    private final IPersistentMap xtdbDoc;

    public SaveClassificationReferenceCopy(Long txId, String entityGUID, PersistentHashMap existing, PersistentHashMap entity, Classification classification, String homeMetadataCollectionId) throws Exception {
        try {
            PersistentHashMap docToUpdate = existing;
            if (existing == null && !homeMetadataCollectionId.equals(SaveClassificationReferenceCopy.getMetadataCollectionId((IPersistentMap)entity))) {
                docToUpdate = entity;
            }
            if (docToUpdate != null) {
                try {
                    TxnValidations.entityFromStore(entityGUID, (IPersistentMap)docToUpdate, CLASS_NAME, METHOD_NAME);
                    TxnValidations.instanceIsNotDeleted((IPersistentMap)docToUpdate, entityGUID, CLASS_NAME, METHOD_NAME);
                    TxnValidations.instanceType((IPersistentMap)docToUpdate, CLASS_NAME, METHOD_NAME);
                    TxnValidations.classification(classification.getName(), SaveClassificationReferenceCopy.getTypeDefForInstance((IPersistentMap)docToUpdate).getName(), CLASS_NAME, METHOD_NAME);
                    TxnValidations.classificationProperties(classification.getName(), classification.getProperties(), CLASS_NAME, METHOD_NAME);
                    docToUpdate = ClassificationMapping.addToMap((IPersistentMap)docToUpdate, classification);
                }
                catch (EntityNotKnownException e) {
                    log.debug("Entity with GUID {} was not known, so classification not stored.", (Object)entityGUID);
                    docToUpdate = null;
                }
                catch (ClassificationErrorException e) {
                    throw new TypeErrorException((OMRSCheckedExceptionBase)e);
                }
            }
            this.xtdbDoc = docToUpdate;
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static void transact(XtdbOMRSRepositoryConnector xtdb, EntityDetail toStoreAgainst, Classification classification) throws EntityConflictException, TypeErrorException, PropertyErrorException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(toStoreAgainst.getGUID());
        EntityDetailMapping edm = new EntityDetailMapping(xtdb, toStoreAgainst);
        XtdbDocument toStoreAgainstXT = edm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, toStoreAgainstXT.toMap(), classification, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (EntityConflictException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        SaveClassificationReferenceCopy.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

