/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ClassifyEntityProxy;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.DeclassifyEntity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class DeclassifyEntityProxy
extends DeclassifyEntity {
    private static final Logger log = LoggerFactory.getLogger(DeclassifyEntityProxy.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"declassifyEntityProxy");
    private static final String CLASS_NAME = DeclassifyEntityProxy.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid pxy cname]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + DeclassifyEntityProxy.class.getCanonicalName() + ". tx-id existing eid pxy cname))" + DeclassifyEntityProxy.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";

    public DeclassifyEntityProxy(Long txId, PersistentHashMap existing, PersistentHashMap proxy, String entityGUID, String classificationName) throws Exception {
        super(CLASS_NAME, METHOD_NAME, txId, existing, proxy, entityGUID, classificationName);
    }

    public static Classification transact(XtdbOMRSRepositoryConnector xtdb, EntityProxy entityProxy, String classificationName) throws EntityNotKnownException, InvalidParameterException, ClassificationErrorException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityProxy.getGUID());
        EntityProxyMapping epm = new EntityProxyMapping(xtdb, entityProxy);
        XtdbDocument epXT = epm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, epXT.toMap(), classificationName});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            EntitySummary result = xtdb.getResultingEntitySummary(docId, results, METHOD_NAME);
            if (result != null) {
                for (Classification cls : result.getClassifications()) {
                    if (!cls.getName().equals(classificationName)) continue;
                    return cls;
                }
            }
            return null;
        }
        catch (ClassificationErrorException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), ClassifyEntityProxy.class.getName(), METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        DeclassifyEntityProxy.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

